/*
 * Decompiled with CFR 0.152.
 */
package org.appng.application.scheduler.business;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.appng.api.DataContainer;
import org.appng.api.DataProvider;
import org.appng.api.Environment;
import org.appng.api.FieldProcessor;
import org.appng.api.Options;
import org.appng.api.Request;
import org.appng.api.ScheduledJobResult;
import org.appng.api.model.Application;
import org.appng.api.model.Site;
import org.appng.api.support.SelectionBuilder;
import org.appng.api.support.SelectionFactory;
import org.appng.application.scheduler.model.JobRecord;
import org.appng.application.scheduler.service.JobRecordService;
import org.appng.xml.platform.SelectionGroup;
import org.springframework.stereotype.Component;

@Component
public class Records
implements DataProvider {
    private static final String START_FILTER_DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm";
    private static final String APPLICATION_FILTER = "ap";
    private static final String JOB_FILTER = "job";
    private static final String START_AFTER_FILTER = "sa";
    private static final String START_BEFORE_FILTER = "sb";
    private static final String MIN_DURATION_FILTER = "du";
    private static final String RESULT_FILTER = "re";
    private JobRecordService jobRecordService;

    public Records(JobRecordService jobRecordService) {
        this.jobRecordService = jobRecordService;
    }

    public DataContainer getData(Site site, Application application, Environment environment, Options options, Request request, FieldProcessor fieldProcessor) {
        DataContainer dc = new DataContainer(fieldProcessor);
        String recordId = options.getOptionValue("id", "value");
        String jobId = options.getOptionValue("jobId", "value");
        if (StringUtils.isNotBlank((CharSequence)jobId)) {
            List<JobRecord> records = this.jobRecordService.getRecords(site.getName(), null, jobId, null, null, null, null);
            dc.setPage(records, fieldProcessor.getPageable());
        } else if (StringUtils.isNotBlank((CharSequence)recordId)) {
            JobRecord item = this.jobRecordService.getRecord(site.getName(), recordId);
            dc.setItem((Object)item);
        } else {
            SelectionGroup filter = new SelectionGroup();
            dc.getSelectionGroups().add(filter);
            String aFilter = request.getParameter(APPLICATION_FILTER);
            String jFilter = request.getParameter(JOB_FILTER);
            String result = request.getParameter(RESULT_FILTER);
            String duration = request.getParameter(MIN_DURATION_FILTER);
            String start = request.getParameter(START_AFTER_FILTER);
            String end = request.getParameter(START_BEFORE_FILTER);
            this.addFilter(site, filter, request);
            List<JobRecord> records = this.jobRecordService.getRecords(site.getName(), aFilter, jFilter, start, end, result, duration);
            dc.setPage(records, fieldProcessor.getPageable());
        }
        return dc;
    }

    private void addFilter(Site site, SelectionGroup filter, Request request) {
        List<String> appNames = this.jobRecordService.getDistinctElements(site.getName(), "application");
        appNames.add(0, "");
        SelectionBuilder.Selection appFilter = new SelectionBuilder(APPLICATION_FILTER).title("filter.record.applicationName").select((Object)request.getParameter(APPLICATION_FILTER)).options(appNames).build();
        filter.getSelections().add(appFilter);
        List<String> jobNames = this.jobRecordService.getDistinctElements(site.getName(), "job_name");
        jobNames.add(0, "");
        SelectionBuilder.Selection jobFilter = new SelectionBuilder(JOB_FILTER).title("filter.record.jobName").select((Object)request.getParameter(JOB_FILTER)).options(jobNames).build();
        filter.getSelections().add(jobFilter);
        SelectionBuilder.Selection resultFilter = new SelectionBuilder(RESULT_FILTER).title("filter.record.result").select((Object)request.getParameter(RESULT_FILTER)).options((Iterable)Lists.newArrayList((Object[])new String[]{"", ScheduledJobResult.ExecutionResult.SUCCESS.toString(), ScheduledJobResult.ExecutionResult.FAIL.toString()})).build();
        filter.getSelections().add(resultFilter);
        SelectionFactory selectionFactory = new SelectionFactory();
        filter.getSelections().add(selectionFactory.getTextSelection(MIN_DURATION_FILTER, "filter.record.minDuration", request.getParameter(MIN_DURATION_FILTER)));
        SelectionFactory.Selection startedAfterFilter = selectionFactory.getDateSelection(START_AFTER_FILTER, "filter.record.startedAfter", request.getParameter(START_AFTER_FILTER), START_FILTER_DATE_TIME_FORMAT);
        filter.getSelections().add(startedAfterFilter);
        SelectionFactory.Selection startedBeforeFilter = selectionFactory.getDateSelection(START_BEFORE_FILTER, "filter.record.startedBefore", request.getParameter(START_BEFORE_FILTER), START_FILTER_DATE_TIME_FORMAT);
        filter.getSelections().add(startedBeforeFilter);
    }
}

