/*
 * Decompiled with CFR 0.152.
 */
package org.appng.application.scheduler.business;

import org.apache.commons.lang3.StringUtils;
import org.appng.api.ActionProvider;
import org.appng.api.Environment;
import org.appng.api.FieldProcessor;
import org.appng.api.Options;
import org.appng.api.Request;
import org.appng.api.ScheduledJob;
import org.appng.api.Scope;
import org.appng.api.model.Application;
import org.appng.api.model.Properties;
import org.appng.api.model.Site;
import org.appng.application.scheduler.SchedulerUtils;
import org.appng.application.scheduler.business.SchedulerAware;
import org.appng.application.scheduler.model.JobForm;
import org.appng.application.scheduler.model.JobModel;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateSchedulerAction
extends SchedulerAware
implements ActionProvider<JobForm> {
    private static final Logger log = LoggerFactory.getLogger(CreateSchedulerAction.class);

    public void perform(Site site, Application application, Environment environment, Options options, Request request, JobForm valueHolder, FieldProcessor fp) {
        String message = null;
        try {
            JobModel jobModel = valueHolder.getJobModel();
            SchedulerUtils schedulerUtils = new SchedulerUtils(this.scheduler, fp, request);
            Properties appProps = (Properties)environment.getAttribute(Scope.PLATFORM, "platformConfig");
            String locale = appProps.getString("locale");
            String jobName = jobModel.getAvailableJob();
            String[] splittedJobName = jobName.split("_");
            String applicationName = splittedJobName[0];
            Application app = site.getApplication(applicationName);
            String beanName = splittedJobName[1];
            ScheduledJob scheduledJob = (ScheduledJob)app.getBean(beanName);
            JobKey jobKey = schedulerUtils.getJobKey(site.getName(), applicationName, jobModel.getName());
            JobDetail jobDetail = schedulerUtils.getJobDetail(jobKey, site, applicationName, scheduledJob, beanName);
            if (StringUtils.isNotBlank((CharSequence)locale)) {
                jobDetail.getJobDataMap().put("locale", locale);
            } else {
                jobDetail.getJobDataMap().put("locale", "en");
            }
            schedulerUtils.addJob(jobDetail, jobModel.getDescription(), jobModel.getCronExpression());
            message = request.getMessage("job.created", new Object[]{jobKey.getName()});
        }
        catch (Exception e) {
            log.error("SchedulerException while creating scheduler", (Throwable)e);
        }
        if (!fp.hasErrors()) {
            fp.addOkMessage(message);
        }
    }
}

