/*
 * Decompiled with CFR 0.152.
 */
package org.appng.application.scheduler;

import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.appng.api.FieldProcessor;
import org.appng.api.Request;
import org.appng.api.ScheduledJob;
import org.appng.api.model.Site;
import org.appng.application.scheduler.quartz.SchedulerJobDetail;
import org.appng.xml.platform.FieldDef;
import org.quartz.CronExpression;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.matchers.GroupMatcher;

public class SchedulerUtils {
    public static final String JOB_SEPARATOR = "_";
    private Scheduler scheduler;
    private FieldProcessor fp;
    private Request request;

    public SchedulerUtils(Scheduler scheduler, FieldProcessor fp) {
        this(scheduler, fp, null);
    }

    public SchedulerUtils(Scheduler scheduler, FieldProcessor fp, Request request) {
        this.scheduler = scheduler;
        this.fp = fp;
        this.request = request;
    }

    public void addSimpleTrigger(JobDetail jobDetail, String id) throws SchedulerException {
        if (this.isRunning(jobDetail)) {
            this.addMessage(this.request, this.fp, "job.running.error", true, false, "", id);
        } else {
            JobKey key = jobDetail.getKey();
            Trigger trigger = TriggerBuilder.newTrigger().withIdentity("simpletrigger-" + this.hashCode(), key.getGroup()).startNow().forJob(key).build();
            this.scheduler.scheduleJob(trigger);
            this.addMessage(this.request, this.fp, "job.running", false, false, null, id);
        }
    }

    public void scheduleJob(JobDetail jobDetail, String cronExpression, String id, String jobDesc, String triggerGroup) throws SchedulerException {
        List triggersOfJob = this.scheduler.getTriggersOfJob(jobDetail.getKey());
        if (0 == triggersOfJob.size()) {
            this.addCronTrigger(jobDetail, cronExpression, id, jobDesc, triggerGroup);
        } else {
            this.addMessage(this.request, this.fp, "job.active", true, false, null, id);
        }
    }

    public void rescheduleJob(JobDetail jobDetail, String cronExpression, String id, String jobDesc, String triggerGroup) throws SchedulerException {
        TriggerKey triggerKey = this.getTriggerKey(jobDetail, id);
        jobDetail.getJobDataMap().put("cronExpression", cronExpression);
        if (triggerKey != null) {
            CronTrigger cronTrigger = this.getCronTrigger(jobDetail, cronExpression, id, jobDesc, triggerGroup);
            if (cronTrigger != null) {
                this.scheduler.rescheduleJob(triggerKey, (Trigger)cronTrigger);
                this.addMessage(this.request, this.fp, "job.updated", false, false, null, id);
                return;
            }
            this.addMessage(this.request, this.fp, "job.update.error", true, false, null, id);
            return;
        }
        this.saveJob(jobDetail);
        this.addMessage(this.request, this.fp, "job.updated", false, false, null, id);
    }

    public boolean isRunning(JobDetail jobDetail) throws SchedulerException {
        for (JobExecutionContext job : this.scheduler.getCurrentlyExecutingJobs()) {
            if (!jobDetail.getKey().equals((Object)job.getJobDetail().getKey())) continue;
            return true;
        }
        return false;
    }

    public boolean deleteTrigger(JobDetail jobDetail, String id) throws SchedulerException {
        List triggersOfJob = this.scheduler.getTriggersOfJob(jobDetail.getKey());
        if (0 == triggersOfJob.size()) {
            this.addMessage(this.request, this.fp, "job.not.exists.error", true, false, null, id);
            return false;
        }
        CronTrigger cronTrigger = (CronTrigger)triggersOfJob.get(0);
        String exp = cronTrigger.getCronExpression();
        jobDetail.getJobDataMap().put("cronExpression", exp);
        this.saveJob(jobDetail);
        boolean unscheduled = this.scheduler.unscheduleJob(((Trigger)triggersOfJob.get(0)).getKey());
        this.addMessage(this.request, this.fp, "job.unscheduled", false, false, null, id);
        return unscheduled;
    }

    public TriggerKey getTriggerKey(JobDetail jobDetail, String id) throws SchedulerException {
        List triggersOfJob = this.scheduler.getTriggersOfJob(jobDetail.getKey());
        if (triggersOfJob.size() > 0) {
            return ((Trigger)triggersOfJob.get(0)).getKey();
        }
        return null;
    }

    public void addCronTrigger(JobDetail jobDetail, String cronExpression, String id, String jobDesc, String triggerGroup) throws SchedulerException {
        CronTrigger cronTrigger;
        if (this.isValidExpression(cronExpression) && (cronTrigger = this.getCronTrigger(jobDetail, cronExpression, id, jobDesc, triggerGroup)) != null) {
            this.scheduler.scheduleJob((Trigger)cronTrigger);
            this.addMessage(this.request, this.fp, "job.scheduled.expr", false, false, null, id, cronExpression);
        }
    }

    public CronTrigger getCronTrigger(JobDetail jobDetail, String cronExpression, String id, String jobDesc, String triggerGroup) {
        if (this.isValidExpression(cronExpression)) {
            TriggerKey triggerKey = new TriggerKey(id + "-crontrigger-" + this.hashCode(), triggerGroup);
            CronTrigger cronTrigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(triggerKey).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronExpression)).forJob(jobDetail).build();
            return cronTrigger;
        }
        return null;
    }

    public boolean isValidExpression(String cronExpression) {
        if (null == cronExpression || !CronExpression.isValidExpression((String)cronExpression)) {
            this.addMessage(this.request, this.fp, "job.cronexpression.invalid", true, true, "jobModel.cronExpression", new Object[0]);
            return false;
        }
        return true;
    }

    public void deleteJob(JobDetail jobDetail, String id) throws SchedulerException {
        JobKey key = jobDetail.getKey();
        if (!this.isRunning(jobDetail)) {
            this.scheduler.deleteJob(key);
            this.addMessage(this.request, this.fp, "job.deleted", false, false, null, id);
        } else {
            this.addMessage(this.request, this.fp, "job.delete.error", true, false, null, id);
        }
    }

    public void addMessage(Request request, FieldProcessor fieldProcessor, String key, boolean isError, boolean attachToField, String fieldName, Object ... args) {
        if (request != null) {
            String message = request.getMessage(key, args);
            if (isError) {
                if (attachToField) {
                    if (!"".equals(fieldName) && fieldName != null) {
                        FieldDef field = fieldProcessor.getField(fieldName);
                        if (field != null) {
                            fieldProcessor.addErrorMessage(field, message);
                        } else {
                            fieldProcessor.addErrorMessage(message);
                        }
                    }
                } else {
                    fieldProcessor.addErrorMessage(message);
                }
            } else {
                fieldProcessor.addOkMessage(message);
            }
        }
    }

    public JobDetail getJobDetail(JobKey jobKey, Site site, String applicationName, ScheduledJob scheduledJob, String beanName) throws SchedulerException {
        JobDetail jobDetail = this.getJobDetail(jobKey);
        if (null == jobDetail) {
            jobDetail = new SchedulerJobDetail(jobKey, scheduledJob.getDescription());
        } else {
            jobDetail.getJobDataMap().clear();
        }
        JobDataMap jobDataMap = jobDetail.getJobDataMap();
        jobDataMap.put("SCHEDULED_JOB", scheduledJob.getClass().getName());
        jobDataMap.put("origin", applicationName);
        jobDataMap.put("siteName", site.getName());
        jobDataMap.put("jobBeanName", beanName);
        if (null != scheduledJob.getJobDataMap()) {
            jobDataMap.putAll(scheduledJob.getJobDataMap());
        }
        return jobDetail;
    }

    public JobDetail getJobDetail(JobKey jobKey) throws SchedulerException {
        return this.scheduler.getJobDetail(jobKey);
    }

    public JobKey getJobKey(String siteName, String applicationName, String jobBeanName) {
        return new JobKey(applicationName + JOB_SEPARATOR + jobBeanName, siteName);
    }

    public void addJob(JobDetail jobDetail, String description, String cronExpression) throws SchedulerException {
        this.saveJob(jobDetail);
        if (StringUtils.isNotBlank((CharSequence)description)) {
            jobDetail.getJobDataMap().put("description", description);
        }
        JobKey jobKey = jobDetail.getKey();
        this.addCronTrigger(jobDetail, cronExpression, jobKey.getName(), "", jobKey.getGroup());
    }

    public void saveJob(JobDetail jobDetail) throws SchedulerException {
        this.scheduler.addJob(jobDetail, true);
    }

    public Set<JobKey> getJobsForSite(String siteName) throws SchedulerException {
        return this.scheduler.getJobKeys(GroupMatcher.jobGroupEquals((String)siteName));
    }
}

