package org.appng.application.scheduler;

/** Property constants for Scheduler 1.12.0 */
public class PropertyConstants {

	/** shared secret for the job records rest API. API is not available if this property is blank */
	public static final String BEARER_TOKEN = "bearerToken";
	/** so to false to disable that scheduler saves records for each job execution */
	public static final String ENABLE_JOB_RECORD = "enableJobRecord";
	public static final String FEATURE_INDEXING = "featureIndexing";
	public static final String HOUSE_KEEPING_ENABLED = "houseKeepingEnabled";
	public static final String HOUSE_KEEPING_EXPRESSION = "houseKeepingExpression";
	public static final String INDEX_ENABLED = "indexEnabled";
	public static final String INDEX_EXPRESSION = "indexExpression";
	/** The timeout in milliseconds when indexing files */
	public static final String INDEX_TIMEOUT = "indexTimeout";
	/** the intervall in ms to check for failed jobs on the cluster */
	public static final String QUARTZ_CLUSTER_CHECKIN_INTERVAL = "quartzClusterCheckinInterval";
	/** the driver delegate for quartz */
	public static final String QUARTZ_DRIVER_DELEGATE = "quartzDriverDelegate";
	/** set to true to enable quartz clustering support */
	public static final String QUARTZ_IS_CLUSTERED = "quartzIsClustered";
	/** life time of job record entries before getting erased from the database. Leaf blank for endless life time */
	public static final String RECORD_LIFE_TIME = "recordLifeTime";
	/** validate jobs on startup */
	public static final String VALIDATE_JOBS_ON_STARTUP = "validateJobsOnStartup";

}