/*
 * Decompiled with CFR 0.152.
 */
package org.appng.application.scheduler.quartz;

import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.ServletContext;
import org.appng.api.Environment;
import org.appng.api.Scope;
import org.appng.api.messaging.Event;
import org.appng.api.model.Properties;
import org.appng.api.model.Site;
import org.appng.api.support.environment.DefaultEnvironment;
import org.appng.application.scheduler.quartz.RunJobEvent;
import org.appng.core.model.ApplicationContext;
import org.quartz.InterruptableJob;
import org.quartz.Job;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobKey;
import org.quartz.UnableToInterruptJobException;
import org.quartz.spi.TriggerFiredBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.quartz.AdaptableJobFactory;
import org.springframework.web.context.WebApplicationContext;

public class SpringQuartzSchedulerFactory
extends AdaptableJobFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringQuartzSchedulerFactory.class);
    @Autowired
    private ApplicationContext applicationContext;
    private AtomicInteger id = new AtomicInteger(1);

    protected Job createJobInstance(TriggerFiredBundle bundle) throws Exception {
        JobDetail jobDetail = bundle.getJobDetail();
        JobKey jobKey = jobDetail.getKey();
        LOGGER.debug("creating job instance for job {}", (Object)jobKey);
        Site site = this.applicationContext.getSite();
        WebApplicationContext parentContext = (WebApplicationContext)this.applicationContext.getParent();
        ServletContext servletContext = parentContext.getServletContext();
        DefaultEnvironment environment = DefaultEnvironment.get((ServletContext)servletContext);
        String eventId = ((Object)((Object)this)).hashCode() + "-" + this.id.getAndIncrement();
        if (jobDetail.getJobDataMap().getBoolean("hardInterruptable")) {
            return this.getInterruptableJob(jobDetail, jobKey, site, (Environment)environment, eventId);
        }
        return this.getJob(jobDetail, jobKey, site, (Environment)environment, eventId);
    }

    private Job getJob(final JobDetail jobDetail, final JobKey jobKey, final Site site, final Environment environment, final String eventId) {
        return new Job(){

            public void execute(JobExecutionContext context) throws JobExecutionException {
                RunJobEvent runJobEvent = new RunJobEvent(eventId, jobKey, site.getName());
                try {
                    runJobEvent.perform(environment, site);
                }
                catch (Exception e) {
                    throw new JobExecutionException((Throwable)e);
                }
                SpringQuartzSchedulerFactory.this.sendRunOnceEvent(jobDetail, jobKey, site, runJobEvent);
            }
        };
    }

    private Job getInterruptableJob(final JobDetail jobDetail, final JobKey jobKey, final Site site, final Environment environment, final String eventId) {
        Properties platformProps = (Properties)environment.getAttribute(Scope.PLATFORM, "platformConfig");
        final Integer waitTime = platformProps.getInteger("interruptableWaitTime", Integer.valueOf(5000));
        return new InterruptableJob(){
            private Thread thread;

            public void execute(JobExecutionContext context) throws JobExecutionException {
                final RunJobEvent runJobEvent = new RunJobEvent(eventId, jobKey, site.getName());
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            runJobEvent.perform(environment, site);
                        }
                        catch (Exception e) {
                            LOGGER.error("Caught Exception on job execution: ", (Throwable)e);
                        }
                        SpringQuartzSchedulerFactory.this.sendRunOnceEvent(jobDetail, jobKey, site, runJobEvent);
                    }
                };
                this.thread = new Thread(runnable, jobKey.getName());
                this.thread.start();
                boolean keepGoing = true;
                while (keepGoing) {
                    try {
                        Thread.sleep(waitTime.intValue());
                    }
                    catch (InterruptedException e) {
                        LOGGER.info("Thread " + this.thread.getName() + " was interrupted while sleeping");
                    }
                    keepGoing = this.thread.isAlive() && !this.thread.isInterrupted();
                }
            }

            public void interrupt() throws UnableToInterruptJobException {
                this.thread.interrupt();
            }
        };
    }

    private void sendRunOnceEvent(JobDetail jobDetail, JobKey jobKey, Site site, RunJobEvent runJobEvent) {
        if (jobDetail.getJobDataMap().getBoolean("runOnce")) {
            LOGGER.info("job {} has option '{}' set, no event will be send.", (Object)jobKey, (Object)"runOnce");
        } else {
            site.sendEvent((Event)runJobEvent);
            LOGGER.info("sending {}", (Object)runJobEvent);
        }
    }
}

