/*
 * Decompiled with CFR 0.152.
 */
package org.appng.application.scheduler.quartz;

import java.util.Map;
import org.appng.api.BusinessException;
import org.appng.api.Environment;
import org.appng.api.InvalidConfigurationException;
import org.appng.api.ScheduledJob;
import org.appng.api.messaging.Event;
import org.appng.api.model.Application;
import org.appng.api.model.Site;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StopWatch;

public class RunJobEvent
extends Event {
    private static final long serialVersionUID = 3439557609209638189L;
    private static final String SCHEDULER_APPLICATION = "schedulerApplication";
    private String id;
    private JobKey jobKey;

    public RunJobEvent(String id, JobKey jobKey, String siteName) {
        super(siteName);
        this.id = id;
        this.jobKey = jobKey;
    }

    public void perform(Environment environment, Site site) throws InvalidConfigurationException, BusinessException {
        Logger logger = LoggerFactory.getLogger(RunJobEvent.class);
        String appName = null;
        try {
            String schedulerAppName = site.getProperties().getString(SCHEDULER_APPLICATION, "appng-scheduler");
            Application appngScheduler = site.getApplication(schedulerAppName);
            Scheduler scheduler = (Scheduler)appngScheduler.getBean(Scheduler.class);
            JobDetail jobDetail = scheduler.getJobDetail(this.jobKey);
            appName = jobDetail.getJobDataMap().getString("origin");
            Application application = site.getApplication(appName);
            String beanName = jobDetail.getJobDataMap().getString("jobBeanName");
            ScheduledJob job = (ScheduledJob)application.getBean(beanName);
            if (null == job) {
                throw new BusinessException("ScheduledJob " + beanName + " not found in application " + appName);
            }
            job.setJobDataMap((Map)jobDetail.getJobDataMap());
            StopWatch sw = new StopWatch();
            sw.start();
            job.execute(site, application);
            sw.stop();
            Object[] args = new Object[]{this.jobKey, appName, site.getName(), sw.getTotalTimeMillis()};
            logger.debug("executing job {} for application {} in site {} took {}ms", args);
        }
        catch (SchedulerException e) {
            throw new BusinessException((Throwable)e);
        }
        catch (Exception e) {
            Object[] args = new Object[]{this.jobKey, appName, site.getName()};
            logger.warn("error while executing job {} for application {} in site {} ", args);
            if (e instanceof BusinessException) {
                throw (BusinessException)e;
            }
            throw new BusinessException((Throwable)e);
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + "#" + this.id + "[site: " + this.getSiteName() + ", job: " + this.jobKey + "]";
    }
}

