/*
 * Decompiled with CFR 0.152.
 */
package org.appng.application.scheduler.quartz;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.appng.application.scheduler.quartz.SchedulerJobDetail;
import org.quartz.Calendar;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.JobPersistenceException;
import org.quartz.TriggerKey;
import org.quartz.impl.jdbcjobstore.DriverDelegate;
import org.quartz.impl.jdbcjobstore.FiredTriggerRecord;
import org.quartz.impl.jdbcjobstore.NoSuchDelegateException;
import org.quartz.impl.jdbcjobstore.SchedulerStateRecord;
import org.quartz.impl.jdbcjobstore.TriggerStatus;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.spi.ClassLoadHelper;
import org.quartz.spi.OperableTrigger;
import org.quartz.utils.Key;
import org.slf4j.Logger;

public class DriverDelegateWrapper
implements DriverDelegate {
    DriverDelegate delegate;

    public void initialize(Logger logger, String tablePrefix, String schedName, String instanceId, ClassLoadHelper classLoadHelper, boolean useProperties, String initString) throws NoSuchDelegateException {
        if (StringUtils.isBlank((CharSequence)initString) || !StringUtils.contains((CharSequence)initString, (CharSequence)"delegate=")) {
            throw new NoSuchDelegateException("initString must contain delegate=<delegate-class-name>");
        }
        String[] realDelegate = initString.split("\\|")[0].split("=");
        String delegateClass = realDelegate[1];
        try {
            this.delegate = (DriverDelegate)classLoadHelper.loadClass(delegateClass, DriverDelegate.class).newInstance();
            this.delegate.initialize(logger, tablePrefix, schedName, instanceId, classLoadHelper, useProperties, null);
        }
        catch (ReflectiveOperationException e) {
            throw new NoSuchDelegateException(delegateClass, (Throwable)e);
        }
    }

    public SchedulerJobDetail selectJobDetail(Connection conn, JobKey jobKey, ClassLoadHelper loadHelper) throws ClassNotFoundException, IOException, SQLException {
        JobDetail jobDetail = this.delegate.selectJobDetail(conn, jobKey, loadHelper);
        return null != jobDetail ? new SchedulerJobDetail(jobDetail) : null;
    }

    public int updateTriggerStatesFromOtherStates(Connection conn, String newState, String oldState1, String oldState2) throws SQLException {
        return this.delegate.updateTriggerStatesFromOtherStates(conn, newState, oldState1, oldState2);
    }

    public List<TriggerKey> selectMisfiredTriggers(Connection conn, long ts) throws SQLException {
        return this.delegate.selectMisfiredTriggers(conn, ts);
    }

    public List<TriggerKey> selectMisfiredTriggersInState(Connection conn, String state, long ts) throws SQLException {
        return this.delegate.selectMisfiredTriggersInState(conn, state, ts);
    }

    public boolean hasMisfiredTriggersInState(Connection conn, String state1, long ts, int count, List<TriggerKey> resultList) throws SQLException {
        return this.delegate.hasMisfiredTriggersInState(conn, state1, ts, count, resultList);
    }

    public int countMisfiredTriggersInState(Connection conn, String state1, long ts) throws SQLException {
        return this.delegate.countMisfiredTriggersInState(conn, state1, ts);
    }

    public List<TriggerKey> selectMisfiredTriggersInGroupInState(Connection conn, String groupName, String state, long ts) throws SQLException {
        return this.delegate.selectMisfiredTriggersInGroupInState(conn, groupName, state, ts);
    }

    public List<OperableTrigger> selectTriggersForRecoveringJobs(Connection conn) throws SQLException, IOException, ClassNotFoundException {
        return this.delegate.selectTriggersForRecoveringJobs(conn);
    }

    public int deleteFiredTriggers(Connection conn) throws SQLException {
        return this.delegate.deleteFiredTriggers(conn);
    }

    public int deleteFiredTriggers(Connection conn, String instanceId) throws SQLException {
        return this.delegate.deleteFiredTriggers(conn, instanceId);
    }

    public int insertJobDetail(Connection conn, JobDetail job) throws IOException, SQLException {
        return this.delegate.insertJobDetail(conn, job);
    }

    public int updateJobDetail(Connection conn, JobDetail job) throws IOException, SQLException {
        return this.delegate.updateJobDetail(conn, job);
    }

    public List<TriggerKey> selectTriggerKeysForJob(Connection conn, JobKey jobKey) throws SQLException {
        return this.delegate.selectTriggerKeysForJob(conn, jobKey);
    }

    public int deleteJobDetail(Connection conn, JobKey jobKey) throws SQLException {
        return this.delegate.deleteJobDetail(conn, jobKey);
    }

    public boolean isJobNonConcurrent(Connection conn, JobKey jobKey) throws SQLException {
        return this.delegate.isJobNonConcurrent(conn, jobKey);
    }

    public boolean jobExists(Connection conn, JobKey jobKey) throws SQLException {
        return this.delegate.jobExists(conn, jobKey);
    }

    public int updateJobData(Connection conn, JobDetail job) throws IOException, SQLException {
        return this.delegate.updateJobData(conn, job);
    }

    public int selectNumJobs(Connection conn) throws SQLException {
        return this.delegate.selectNumJobs(conn);
    }

    public List<String> selectJobGroups(Connection conn) throws SQLException {
        return this.delegate.selectJobGroups(conn);
    }

    public Set<JobKey> selectJobsInGroup(Connection conn, GroupMatcher<JobKey> matcher) throws SQLException {
        return this.delegate.selectJobsInGroup(conn, matcher);
    }

    public int insertTrigger(Connection conn, OperableTrigger trigger, String state, JobDetail jobDetail) throws SQLException, IOException {
        return this.delegate.insertTrigger(conn, trigger, state, jobDetail);
    }

    public int updateTrigger(Connection conn, OperableTrigger trigger, String state, JobDetail jobDetail) throws SQLException, IOException {
        return this.delegate.updateTrigger(conn, trigger, state, jobDetail);
    }

    public boolean triggerExists(Connection conn, TriggerKey triggerKey) throws SQLException {
        return this.delegate.triggerExists(conn, triggerKey);
    }

    public int updateTriggerState(Connection conn, TriggerKey triggerKey, String state) throws SQLException {
        return this.delegate.updateTriggerState(conn, triggerKey, state);
    }

    public int updateTriggerStateFromOtherState(Connection conn, TriggerKey triggerKey, String newState, String oldState) throws SQLException {
        return this.delegate.updateTriggerStateFromOtherState(conn, triggerKey, newState, oldState);
    }

    public int updateTriggerStateFromOtherStates(Connection conn, TriggerKey triggerKey, String newState, String oldState1, String oldState2, String oldState3) throws SQLException {
        return this.delegate.updateTriggerStateFromOtherStates(conn, triggerKey, newState, oldState1, oldState2, oldState3);
    }

    public int updateTriggerGroupStateFromOtherStates(Connection conn, GroupMatcher<TriggerKey> matcher, String newState, String oldState1, String oldState2, String oldState3) throws SQLException {
        return this.delegate.updateTriggerGroupStateFromOtherStates(conn, matcher, newState, oldState1, oldState2, oldState3);
    }

    public int updateTriggerGroupStateFromOtherState(Connection conn, GroupMatcher<TriggerKey> matcher, String newState, String oldState) throws SQLException {
        return this.delegate.updateTriggerGroupStateFromOtherState(conn, matcher, newState, oldState);
    }

    public int updateTriggerStatesForJob(Connection conn, JobKey jobKey, String state) throws SQLException {
        return this.delegate.updateTriggerStatesForJob(conn, jobKey, state);
    }

    public int updateTriggerStatesForJobFromOtherState(Connection conn, JobKey jobKey, String state, String oldState) throws SQLException {
        return this.delegate.updateTriggerStatesForJobFromOtherState(conn, jobKey, state, oldState);
    }

    public int deleteTrigger(Connection conn, TriggerKey triggerKey) throws SQLException {
        return this.delegate.deleteTrigger(conn, triggerKey);
    }

    public int selectNumTriggersForJob(Connection conn, JobKey jobKey) throws SQLException {
        return this.delegate.selectNumTriggersForJob(conn, jobKey);
    }

    public JobDetail selectJobForTrigger(Connection conn, ClassLoadHelper loadHelper, TriggerKey triggerKey) throws ClassNotFoundException, SQLException {
        return this.delegate.selectJobForTrigger(conn, loadHelper, triggerKey);
    }

    public JobDetail selectJobForTrigger(Connection conn, ClassLoadHelper loadHelper, TriggerKey triggerKey, boolean loadJobClass) throws ClassNotFoundException, SQLException {
        return this.delegate.selectJobForTrigger(conn, loadHelper, triggerKey, loadJobClass);
    }

    public List<OperableTrigger> selectTriggersForJob(Connection conn, JobKey jobKey) throws SQLException, ClassNotFoundException, IOException, JobPersistenceException {
        return this.delegate.selectTriggersForJob(conn, jobKey);
    }

    public List<OperableTrigger> selectTriggersForCalendar(Connection conn, String calName) throws SQLException, ClassNotFoundException, IOException, JobPersistenceException {
        return this.delegate.selectTriggersForCalendar(conn, calName);
    }

    public OperableTrigger selectTrigger(Connection conn, TriggerKey triggerKey) throws SQLException, ClassNotFoundException, IOException, JobPersistenceException {
        return this.delegate.selectTrigger(conn, triggerKey);
    }

    public JobDataMap selectTriggerJobDataMap(Connection conn, String triggerName, String groupName) throws SQLException, ClassNotFoundException, IOException {
        return this.delegate.selectTriggerJobDataMap(conn, triggerName, groupName);
    }

    public String selectTriggerState(Connection conn, TriggerKey triggerKey) throws SQLException {
        return this.delegate.selectTriggerState(conn, triggerKey);
    }

    public TriggerStatus selectTriggerStatus(Connection conn, TriggerKey triggerKey) throws SQLException {
        return this.delegate.selectTriggerStatus(conn, triggerKey);
    }

    public int selectNumTriggers(Connection conn) throws SQLException {
        return this.delegate.selectNumTriggers(conn);
    }

    public List<String> selectTriggerGroups(Connection conn) throws SQLException {
        return this.delegate.selectTriggerGroups(conn);
    }

    public List<String> selectTriggerGroups(Connection conn, GroupMatcher<TriggerKey> matcher) throws SQLException {
        return this.delegate.selectTriggerGroups(conn, matcher);
    }

    public Set<TriggerKey> selectTriggersInGroup(Connection conn, GroupMatcher<TriggerKey> matcher) throws SQLException {
        return this.delegate.selectTriggersInGroup(conn, matcher);
    }

    public List<TriggerKey> selectTriggersInState(Connection conn, String state) throws SQLException {
        return this.delegate.selectTriggersInState(conn, state);
    }

    public int insertPausedTriggerGroup(Connection conn, String groupName) throws SQLException {
        return this.delegate.insertPausedTriggerGroup(conn, groupName);
    }

    public int deletePausedTriggerGroup(Connection conn, String groupName) throws SQLException {
        return this.delegate.deletePausedTriggerGroup(conn, groupName);
    }

    public int deletePausedTriggerGroup(Connection conn, GroupMatcher<TriggerKey> matcher) throws SQLException {
        return this.delegate.deletePausedTriggerGroup(conn, matcher);
    }

    public int deleteAllPausedTriggerGroups(Connection conn) throws SQLException {
        return this.delegate.deleteAllPausedTriggerGroups(conn);
    }

    public boolean isTriggerGroupPaused(Connection conn, String groupName) throws SQLException {
        return this.delegate.isTriggerGroupPaused(conn, groupName);
    }

    public Set<String> selectPausedTriggerGroups(Connection conn) throws SQLException {
        return this.delegate.selectPausedTriggerGroups(conn);
    }

    public boolean isExistingTriggerGroup(Connection conn, String groupName) throws SQLException {
        return this.delegate.isExistingTriggerGroup(conn, groupName);
    }

    public int insertCalendar(Connection conn, String calendarName, Calendar calendar) throws IOException, SQLException {
        return this.delegate.insertCalendar(conn, calendarName, calendar);
    }

    public int updateCalendar(Connection conn, String calendarName, Calendar calendar) throws IOException, SQLException {
        return this.delegate.updateCalendar(conn, calendarName, calendar);
    }

    public boolean calendarExists(Connection conn, String calendarName) throws SQLException {
        return this.delegate.calendarExists(conn, calendarName);
    }

    public Calendar selectCalendar(Connection conn, String calendarName) throws ClassNotFoundException, IOException, SQLException {
        return this.delegate.selectCalendar(conn, calendarName);
    }

    public boolean calendarIsReferenced(Connection conn, String calendarName) throws SQLException {
        return this.delegate.calendarIsReferenced(conn, calendarName);
    }

    public int deleteCalendar(Connection conn, String calendarName) throws SQLException {
        return this.delegate.deleteCalendar(conn, calendarName);
    }

    public int selectNumCalendars(Connection conn) throws SQLException {
        return this.delegate.selectNumCalendars(conn);
    }

    public List<String> selectCalendars(Connection conn) throws SQLException {
        return this.delegate.selectCalendars(conn);
    }

    public long selectNextFireTime(Connection conn) throws SQLException {
        return this.delegate.selectNextFireTime(conn);
    }

    public Key<?> selectTriggerForFireTime(Connection conn, long fireTime) throws SQLException {
        return this.delegate.selectTriggerForFireTime(conn, fireTime);
    }

    public List<TriggerKey> selectTriggerToAcquire(Connection conn, long noLaterThan, long noEarlierThan) throws SQLException {
        return this.delegate.selectTriggerToAcquire(conn, noLaterThan, noEarlierThan);
    }

    public List<TriggerKey> selectTriggerToAcquire(Connection conn, long noLaterThan, long noEarlierThan, int maxCount) throws SQLException {
        return this.delegate.selectTriggerToAcquire(conn, noLaterThan, noEarlierThan, maxCount);
    }

    public int insertFiredTrigger(Connection conn, OperableTrigger trigger, String state, JobDetail jobDetail) throws SQLException {
        return this.delegate.insertFiredTrigger(conn, trigger, state, jobDetail);
    }

    public int updateFiredTrigger(Connection conn, OperableTrigger trigger, String state, JobDetail jobDetail) throws SQLException {
        return this.delegate.updateFiredTrigger(conn, trigger, state, jobDetail);
    }

    public List<FiredTriggerRecord> selectFiredTriggerRecords(Connection conn, String triggerName, String groupName) throws SQLException {
        return this.delegate.selectFiredTriggerRecords(conn, triggerName, groupName);
    }

    public List<FiredTriggerRecord> selectFiredTriggerRecordsByJob(Connection conn, String jobName, String groupName) throws SQLException {
        return this.delegate.selectFiredTriggerRecordsByJob(conn, jobName, groupName);
    }

    public List<FiredTriggerRecord> selectInstancesFiredTriggerRecords(Connection conn, String instanceName) throws SQLException {
        return this.delegate.selectInstancesFiredTriggerRecords(conn, instanceName);
    }

    public Set<String> selectFiredTriggerInstanceNames(Connection conn) throws SQLException {
        return this.delegate.selectFiredTriggerInstanceNames(conn);
    }

    public int deleteFiredTrigger(Connection conn, String entryId) throws SQLException {
        return this.delegate.deleteFiredTrigger(conn, entryId);
    }

    public int selectJobExecutionCount(Connection conn, JobKey jobKey) throws SQLException {
        return this.delegate.selectJobExecutionCount(conn, jobKey);
    }

    public int insertSchedulerState(Connection conn, String instanceId, long checkInTime, long interval) throws SQLException {
        return this.delegate.insertSchedulerState(conn, instanceId, checkInTime, interval);
    }

    public int deleteSchedulerState(Connection conn, String instanceId) throws SQLException {
        return this.delegate.deleteSchedulerState(conn, instanceId);
    }

    public int updateSchedulerState(Connection conn, String instanceId, long checkInTime) throws SQLException {
        return this.delegate.updateSchedulerState(conn, instanceId, checkInTime);
    }

    public List<SchedulerStateRecord> selectSchedulerStateRecords(Connection conn, String instanceId) throws SQLException {
        return this.delegate.selectSchedulerStateRecords(conn, instanceId);
    }

    public void clearData(Connection conn) throws SQLException {
        this.delegate.clearData(conn);
    }
}

