/*
 * Decompiled with CFR 0.152.
 */
package org.appng.application.scheduler.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.appng.api.ScheduledJob;
import org.appng.api.model.Application;
import org.appng.api.model.Site;
import org.appng.application.scheduler.SchedulerUtils;
import org.appng.application.scheduler.model.JobModel;
import org.quartz.CronTrigger;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.impl.matchers.GroupMatcher;

public class JobXmlModel {
    public List<JobModel> getJobs(Scheduler scheduler, Site site) throws SchedulerException {
        ArrayList<JobModel> list = new ArrayList<JobModel>();
        Set jobKeys = scheduler.getJobKeys(GroupMatcher.jobGroupEquals((String)site.getName()));
        for (JobKey jobKey : jobKeys) {
            JobModel job = this.getJob(jobKey.getName(), scheduler, site);
            list.add(job);
        }
        Collections.sort(list);
        return list;
    }

    public JobModel getJob(String jobName, Scheduler scheduler, Site site) throws SchedulerException {
        if (null != jobName) {
            return this.getModel(scheduler, jobName, site);
        }
        return null;
    }

    private JobModel getModel(Scheduler scheduler, String jobName, Site site) throws SchedulerException {
        JobModel jobModel = null;
        JobDetail jobDetail = scheduler.getJobDetail(new JobKey(jobName, site.getName()));
        if (null != jobDetail) {
            JobDataMap jobDataMap = jobDetail.getJobDataMap();
            String jobClass = jobDataMap.getString("SCHEDULED_JOB");
            String origin = jobDataMap.getString("origin");
            String beanName = jobDataMap.getString("jobBeanName");
            Application application = site.getApplication(origin);
            jobModel = new JobModel();
            jobModel.setName(jobName);
            jobModel.setJobClass(jobClass);
            jobModel.setOrigin(origin);
            boolean beanAvailable = null != application && null != application.getBean(beanName, ScheduledJob.class);
            jobModel.setBeanAvailable(beanAvailable);
            List triggers = scheduler.getTriggersOfJob(jobDetail.getKey());
            if (triggers.size() > 0) {
                for (Trigger trigger : triggers) {
                    if (!(trigger instanceof CronTrigger)) continue;
                    CronTrigger cronTrigger = (CronTrigger)trigger;
                    String cronExpression = cronTrigger.getCronExpression();
                    Date previousFireTime = cronTrigger.getPreviousFireTime();
                    Date nextFireTime = cronTrigger.getNextFireTime();
                    jobModel.setCronExpression(cronExpression);
                    jobModel.setPreviousFireTime(previousFireTime);
                    jobModel.setNextFireTime(nextFireTime);
                }
                if (new SchedulerUtils(scheduler, null).isRunning(jobDetail)) {
                    jobModel.setRunning(true);
                }
            } else {
                String cronExpression = (String)jobDataMap.get((Object)"cronExpression");
                jobModel.setCronExpression(cronExpression);
            }
        }
        return jobModel;
    }
}

