/*
 * Decompiled with CFR 0.152.
 */
package org.appng.application.scheduler.model;

import java.util.Set;
import org.appng.api.Environment;
import org.appng.api.FieldProcessor;
import org.appng.api.FormValidator;
import org.appng.api.Options;
import org.appng.api.Request;
import org.appng.api.model.Application;
import org.appng.api.model.Site;
import org.appng.application.scheduler.model.JobModel;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.impl.matchers.GroupMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobForm
implements FormValidator {
    private static Logger log = LoggerFactory.getLogger(JobForm.class);
    private static String JOB_NAME = "jobModel.name";
    private JobModel jobModel;

    public JobForm() {
        this.jobModel = new JobModel();
    }

    public JobForm(JobModel jobModel) {
        this.jobModel = jobModel;
    }

    public void validate(Site site, Application application, Environment environment, Options options, Request request, FieldProcessor fp) {
        try {
            Scheduler scheduler = (Scheduler)application.getBean(Scheduler.class);
            Set jobKeys = scheduler.getJobKeys(GroupMatcher.jobGroupEquals((String)site.getName()));
            if (this.jobModel.getName() == null || "".equals(this.jobModel.getName())) {
                String message = request.getMessage("job.not.name.error", new Object[0]);
                fp.addErrorMessage(fp.getField(JOB_NAME), message);
            } else {
                JobKey newKey = new JobKey(application.getName() + "_" + this.jobModel.getName(), site.getName());
                if (jobKeys.contains(newKey)) {
                    String message = request.getMessage("job.name.exists.error", new Object[]{this.jobModel.getName()});
                    fp.addErrorMessage(fp.getField(JOB_NAME), message);
                }
            }
        }
        catch (SchedulerException e) {
            log.error("Error while validating name " + this.getJobModel().getName(), (Throwable)e);
        }
    }

    public JobModel getJobModel() {
        return this.jobModel;
    }

    public void setJobModel(JobModel jobModel) {
        this.jobModel = jobModel;
    }
}

