/*
 * Decompiled with CFR 0.152.
 */
package org.appng.application.scheduler.business;

import org.appng.api.ActionProvider;
import org.appng.api.Environment;
import org.appng.api.FieldProcessor;
import org.appng.api.Options;
import org.appng.api.Request;
import org.appng.api.model.Application;
import org.appng.api.model.Site;
import org.appng.application.scheduler.SchedulerUtils;
import org.appng.application.scheduler.business.SchedulerAware;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetSchedulerStateAction
extends SchedulerAware
implements ActionProvider<Void> {
    private static final String ACTION_DELETE = "delete";
    private static final String ACTION_START = "start";
    private static final String ACTION_UNSCHEDULE = "unschedule";
    private static final String ACTION_SCHEDULE = "schedule";
    private static Logger log = LoggerFactory.getLogger(SetSchedulerStateAction.class);

    public void perform(Site site, Application application, Environment environment, Options options, Request request, Void valueHolder, FieldProcessor fp) {
        String siteName = site.getName();
        String action = options.getString("job", "action");
        String id = options.getString("job", "id");
        try {
            SchedulerUtils schedulerUtils = new SchedulerUtils(this.scheduler, fp, request);
            JobKey jobKey = new JobKey(id, siteName);
            JobDetail jobDetail = this.scheduler.getJobDetail(jobKey);
            if (ACTION_SCHEDULE.equals(action)) {
                if (null == jobDetail) {
                    fp.addErrorMessage(request.getMessage("job.not.exists.error", new Object[]{id}));
                } else {
                    String cronExpression = (String)jobDetail.getJobDataMap().get((Object)"cronExpression");
                    schedulerUtils.scheduleJob(jobDetail, cronExpression, id, "", siteName);
                }
            } else if (ACTION_UNSCHEDULE.equals(action)) {
                schedulerUtils.deleteTrigger(jobDetail, id);
            } else if (ACTION_START.equals(action)) {
                schedulerUtils.addSimpleTrigger(jobDetail, id);
            } else if (ACTION_DELETE.equals(action)) {
                schedulerUtils.deleteJob(jobDetail, id);
            }
        }
        catch (SchedulerException e) {
            log.error("Error while changing scheduler state", (Throwable)e);
        }
    }
}

