/*
 * Decompiled with CFR 0.152.
 */
package org.appng.application.scheduler.search;

import java.util.Map;
import org.appng.api.ScheduledJob;
import org.appng.api.model.Application;
import org.appng.api.model.Site;
import org.appng.api.search.Consumer;
import org.appng.search.indexer.GlobalIndexer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexJob
implements ScheduledJob {
    private static final Logger LOG = LoggerFactory.getLogger(IndexJob.class);
    private Map<String, Object> jobDataMap;
    private String description;

    public void execute(Site site, Application application) throws Exception {
        LOG.debug("started IndexJob ({}) for site {}", (Object)this.description, (Object)site.getName());
        Consumer indexer = application.getFeatureProvider().getIndexer();
        String jspFileType = (String)this.getJobDataMap().get("jspFileType");
        new GlobalIndexer(indexer).doIndex(site, jspFileType);
        LOG.debug("finished IndexJob ({}) for site {}", (Object)this.description, (Object)site.getName());
    }

    public Map<String, Object> getJobDataMap() {
        return this.jobDataMap;
    }

    public void setJobDataMap(Map<String, Object> jobDataMap) {
        this.jobDataMap = jobDataMap;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

