/*
 * Decompiled with CFR 0.152.
 */
package org.appng.application.scheduler;

import org.apache.log4j.Logger;
import org.appng.api.ActionProvider;
import org.appng.api.Environment;
import org.appng.api.FieldProcessor;
import org.appng.api.Options;
import org.appng.api.Request;
import org.appng.api.model.Application;
import org.appng.api.model.Site;
import org.appng.application.scheduler.JobModel;
import org.appng.application.scheduler.SchedulerAware;
import org.appng.application.scheduler.SchedulerUtils;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.SchedulerException;

public class UpdateSchedulerAction
extends SchedulerAware
implements ActionProvider<JobModel> {
    private static Logger log = Logger.getLogger(UpdateSchedulerAction.class);

    public void perform(Site site, Application application, Environment environment, Options options, Request request, JobModel valueHolder, FieldProcessor fp) {
        String siteName = site.getName();
        String id = options.getOption("job").getAttribute("id");
        String cronExpn = valueHolder.getCronExpression();
        String jobDesc = valueHolder.getDescription();
        try {
            SchedulerUtils schedulerUtils = new SchedulerUtils(this.scheduler, fp, request);
            JobKey jobKey = new JobKey(id, siteName);
            JobDetail jobDetail = this.scheduler.getJobDetail(jobKey);
            if (cronExpn != null && !schedulerUtils.isValidExpression(cronExpn)) {
                return;
            }
            if (null != jobDetail && this.scheduler.checkExists(jobDetail.getKey())) {
                schedulerUtils.rescheduleJob(jobDetail, cronExpn, id, jobDesc, siteName);
            } else {
                String message = request.getMessage("job.not.exists.error", new Object[]{id});
                fp.addErrorMessage(message);
            }
        }
        catch (SchedulerException e) {
            log.error((Object)"SchedulerException while updating scheduler", (Throwable)e);
        }
    }
}

