/*
 * Decompiled with CFR 0.152.
 */
package org.appng.application.scheduler;

import java.util.List;
import org.appng.api.ApplicationController;
import org.appng.api.Environment;
import org.appng.api.FieldProcessor;
import org.appng.api.ScheduledJob;
import org.appng.api.model.Application;
import org.appng.api.model.Site;
import org.appng.application.scheduler.SchedulerAware;
import org.appng.application.scheduler.SchedulerUtils;
import org.appng.xml.platform.FieldDef;
import org.appng.xml.platform.Linkpanel;
import org.appng.xml.platform.Messages;
import org.appng.xml.platform.MetaData;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Pageable;

public class SchedulingController
extends SchedulerAware
implements ApplicationController {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchedulingController.class);

    public boolean start(Site site, Application application, Environment env) {
        try {
            SchedulerUtils schedulerUtils = new SchedulerUtils(this.scheduler, this.getLoggingFieldProcessor());
            for (Application a : site.getApplications()) {
                String[] jobBeanNames;
                for (String jobBeanName : jobBeanNames = a.getBeanNames(ScheduledJob.class)) {
                    ScheduledJob scheduledJob = (ScheduledJob)a.getBean(jobBeanName);
                    if (null == scheduledJob) {
                        LOGGER.warn("error retrieving {} from {}", (Object)jobBeanName, (Object)a.getName());
                        continue;
                    }
                    try {
                        JobKey jobKey = schedulerUtils.getJobKey(site.getName(), a.getName(), jobBeanName);
                        JobDetail jobDetail = schedulerUtils.getJobDetail(jobKey, site, a.getName(), scheduledJob);
                        boolean isNewJob = !this.scheduler.checkExists(jobKey);
                        boolean enabled = "true".equalsIgnoreCase((String)jobDetail.getJobDataMap().get((Object)"enabled"));
                        if (isNewJob && enabled) {
                            String cronExpression = (String)jobDetail.getJobDataMap().get((Object)"cronExpression");
                            String description = scheduledJob.getDescription();
                            schedulerUtils.addJob(jobDetail, description, cronExpression);
                            continue;
                        }
                        this.scheduler.addJob(jobDetail, true);
                    }
                    catch (Exception e) {
                        LOGGER.error("error starting job '" + jobBeanName + "' of application " + application.getName() + " (type is" + scheduledJob.getClass().getName() + ")", (Throwable)e);
                    }
                }
            }
            this.scheduler.start();
        }
        catch (SchedulerException e) {
            LOGGER.error("error while starting scheduler", (Throwable)e);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeSite(Site site, Application application, Environment environment) {
        try {
            this.scheduler.clear();
            this.scheduler.shutdown(false);
            this.scheduler.getContext().clear();
            boolean bl = true;
            return bl;
        }
        catch (SchedulerException e) {
            LOGGER.error("error while removing scheduler from site " + site.getName(), (Throwable)e);
        }
        finally {
            this.scheduler = null;
        }
        return false;
    }

    public boolean shutdown(Site site, Application application, Environment environment) {
        return true;
    }

    private FieldProcessor getLoggingFieldProcessor() {
        return new FieldProcessor(){

            public void addOkMessage(FieldDef field, String message) {
                this.addOkMessage(message);
            }

            public void addOkMessage(String message) {
                LOGGER.info(message);
            }

            public void addNoticeMessage(FieldDef field, String message) {
                this.addNoticeMessage(message);
            }

            public void addNoticeMessage(String message) {
                LOGGER.debug(message);
            }

            public void addInvalidMessage(FieldDef field, String message) {
                this.addInvalidMessage(message);
            }

            public void addInvalidMessage(String message) {
                LOGGER.warn(message);
            }

            public void addErrorMessage(FieldDef field, String message) {
                this.addErrorMessage(message);
            }

            public void addErrorMessage(String message) {
                LOGGER.error(message);
            }

            public List<FieldDef> getFields() {
                return null;
            }

            public FieldDef getField(String fieldBinding) {
                return null;
            }

            public MetaData getMetaData() {
                return null;
            }

            public boolean hasField(String fieldBinding) {
                return false;
            }

            public String getReference() {
                return null;
            }

            public boolean hasErrors() {
                return false;
            }

            public boolean hasFieldErrors() {
                return false;
            }

            public void addLinkPanels(List<Linkpanel> panels) {
            }

            public Linkpanel getLinkPanel(String fieldName) {
                return null;
            }

            public Messages getMessages() {
                return null;
            }

            public void clearMessages() {
            }

            public void clearFieldMessages() {
            }

            public void clearFieldMessages(String ... fieldBindings) {
            }

            public Pageable getPageable() {
                return null;
            }
        };
    }

    public boolean addSite(Site site, Application application, Environment environment) {
        return true;
    }
}

