/*
 * Decompiled with CFR 0.152.
 */
package org.appng.application.scheduler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.appng.application.scheduler.JobModel;
import org.appng.application.scheduler.SchedulerUtils;
import org.quartz.CronTrigger;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.impl.matchers.GroupMatcher;

public class JobXmlModel {
    private String jobGroup;

    public JobXmlModel(String jobGroup) {
        this.jobGroup = jobGroup;
    }

    public List<JobModel> getJobs(Scheduler scheduler) throws SchedulerException {
        ArrayList<JobModel> list = new ArrayList<JobModel>();
        Set jobKeys = scheduler.getJobKeys(GroupMatcher.jobGroupEquals((String)this.jobGroup));
        for (JobKey jobKey : jobKeys) {
            JobModel job = this.getJob(jobKey.getName(), scheduler);
            list.add(job);
        }
        Collections.sort(list);
        return list;
    }

    public JobModel getJob(String jobName, Scheduler scheduler) throws SchedulerException {
        if (null != jobName) {
            return this.getModel(scheduler, jobName);
        }
        return null;
    }

    private JobModel getModel(Scheduler scheduler, String jobName) throws SchedulerException {
        JobModel jobModel = null;
        JobDetail jobDetail = scheduler.getJobDetail(new JobKey(jobName, this.jobGroup));
        if (null != jobDetail) {
            JobDataMap jobDataMap = jobDetail.getJobDataMap();
            String jobClass = (String)jobDataMap.get((Object)"SCHEDULED_JOB");
            String origin = (String)jobDataMap.get((Object)"origin");
            jobModel = new JobModel();
            jobModel.setName(jobName);
            jobModel.setJobClass(jobClass);
            jobModel.setOrigin(origin);
            List triggers = scheduler.getTriggersOfJob(jobDetail.getKey());
            if (triggers.size() > 0) {
                for (Trigger trigger : triggers) {
                    if (!(trigger instanceof CronTrigger)) continue;
                    CronTrigger cronTrigger = (CronTrigger)trigger;
                    String cronExpression = cronTrigger.getCronExpression();
                    Date previousFireTime = cronTrigger.getPreviousFireTime();
                    Date nextFireTime = cronTrigger.getNextFireTime();
                    jobModel.setCronExpression(cronExpression);
                    jobModel.setPreviousFireTime(previousFireTime);
                    jobModel.setNextFireTime(nextFireTime);
                }
                if (new SchedulerUtils(scheduler, null).isRunning(jobDetail)) {
                    jobModel.setRunning(true);
                }
            } else {
                String cronExpression = (String)jobDataMap.get((Object)"cronExpression");
                jobModel.setCronExpression(cronExpression);
            }
        }
        return jobModel;
    }
}

