/*
 * Decompiled with CFR 0.152.
 */
package org.appng.application.scheduler;

import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.appng.api.ActionProvider;
import org.appng.api.Environment;
import org.appng.api.FieldProcessor;
import org.appng.api.Options;
import org.appng.api.Request;
import org.appng.api.ScheduledJob;
import org.appng.api.Scope;
import org.appng.api.model.Application;
import org.appng.api.model.Properties;
import org.appng.api.model.Site;
import org.appng.application.scheduler.JobModel;
import org.appng.application.scheduler.SchedulerAware;
import org.appng.application.scheduler.SchedulerUtils;
import org.appng.application.scheduler.form.JobForm;
import org.quartz.JobDetail;
import org.quartz.JobKey;

public class CreateSchedulerAction
extends SchedulerAware
implements ActionProvider<JobForm> {
    private static final Logger log = Logger.getLogger(CreateSchedulerAction.class);

    public void perform(Site site, Application application, Environment environment, Options options, Request request, JobForm valueHolder, FieldProcessor fp) {
        String message = null;
        try {
            JobModel jobModel = valueHolder.getJobModel();
            SchedulerUtils schedulerUtils = new SchedulerUtils(this.scheduler, fp, request);
            Properties appProps = (Properties)environment.getAttribute(Scope.PLATFORM, "platformConfig");
            String locale = appProps.getString("locale");
            String jobName = jobModel.getAvailableJob();
            String[] splittedJobName = jobName.split("_");
            String applicationName = splittedJobName[0];
            Application app = site.getApplication(applicationName);
            ScheduledJob scheduledJob = (ScheduledJob)app.getBean(splittedJobName[1]);
            JobKey jobKey = schedulerUtils.getJobKey(site.getName(), applicationName, jobModel.getName());
            JobDetail jobDetail = schedulerUtils.getJobDetail(jobKey, site, applicationName, scheduledJob);
            if (StringUtils.isNotBlank((CharSequence)locale)) {
                jobDetail.getJobDataMap().put("locale", locale);
            } else {
                jobDetail.getJobDataMap().put("locale", "en");
            }
            schedulerUtils.addJob(jobDetail, jobModel.getDescription(), jobModel.getCronExpression());
            message = request.getMessage("job.created", new Object[]{jobKey.getName()});
        }
        catch (Exception e) {
            log.error((Object)"SchedulerException while creating scheduler", (Throwable)e);
        }
        if (!fp.hasErrors()) {
            fp.addOkMessage(message);
        }
    }
}

