/*
 * Decompiled with CFR 0.152.
 */
package org.appng.api.rest;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.appng.api.rest.model.Datasource;
import org.appng.api.rest.model.Element;
import org.appng.api.rest.model.FieldValue;
import org.appng.api.rest.model.Filter;
import org.appng.api.rest.model.Link;
import org.appng.api.rest.model.Page;
import org.springframework.http.ResponseEntity;

public class DataSourceHelper {
    private ResponseEntity<Datasource> dataSource;

    public DataSourceHelper(ResponseEntity<Datasource> dataSource) {
        this.dataSource = dataSource;
    }

    public static DataSourceHelper create(ResponseEntity<Datasource> dataSource) {
        return new DataSourceHelper(dataSource);
    }

    @Deprecated
    public Optional<Element> getResult(int i) {
        return this.getElement(i);
    }

    public Optional<Element> getElement(int i) {
        Page page = ((Datasource)this.dataSource.getBody()).getPage();
        if (null != page && null != page.getElements() && i > -1 && page.getElements().size() > i) {
            return Optional.of(page.getElements().get(i));
        }
        return Optional.empty();
    }

    public Optional<Link> getLink(Element item, String linkId) {
        return item.getLinks().stream().filter(l -> l.getId().equals(linkId)).findFirst();
    }

    public Optional<FieldValue> getField(Element item, String name) {
        return this.getField(item.getFields(), name);
    }

    private Optional<FieldValue> getField(List<FieldValue> fields, String name) {
        if (!name.contains(".")) {
            return fields.stream().filter(f -> f.getName().equals(name)).findFirst();
        }
        String[] segments = name.split("\\.");
        Optional<FieldValue> root = fields.stream().filter(f -> f.getName().equals(segments[0])).findFirst();
        if (root.isPresent()) {
            return this.getField(root.get().getValues(), StringUtils.join((Object[])Arrays.copyOfRange(segments, 1, segments.length), (String)"."));
        }
        return Optional.empty();
    }

    public Optional<Filter> getFilter(String name) {
        List<Filter> filters = ((Datasource)this.dataSource.getBody()).getFilters();
        if (null == filters) {
            return Optional.empty();
        }
        return filters.parallelStream().filter(f -> f.getName().equals(name)).findFirst();
    }
}

