/*
 * Decompiled with CFR 0.152.
 */
package org.appng.api.rest;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.appng.api.rest.model.Action;
import org.appng.api.rest.model.ActionField;
import org.appng.api.rest.model.FieldType;
import org.appng.api.rest.model.Options;
import org.springframework.http.ResponseEntity;

public class ActionHelper {
    private ResponseEntity<Action> action;

    public ActionHelper(ResponseEntity<Action> action) {
        this.action = action;
    }

    public static ActionHelper create(ResponseEntity<Action> action) {
        return new ActionHelper(action);
    }

    public ActionHelper setFieldValue(String name, Object value) {
        Optional<ActionField> field = this.getField(name);
        if (field.isPresent() && !this.isSelectionType(field.get())) {
            field.get().setValue(value);
        }
        return this;
    }

    public ActionHelper setFieldSelectionValue(String name, String value) {
        Optional<ActionField> field = this.getField(name);
        if (field.isPresent() && this.isSelectionType(field.get())) {
            Options options = field.get().getOptions();
            options.getEntries().forEach(o -> {
                boolean selected = Objects.equals(value, o.getValue());
                if (selected || !Boolean.TRUE.equals(options.isMultiple())) {
                    o.setSelected(selected);
                }
            });
        }
        return this;
    }

    public ActionHelper deselectAllOptions(String name) {
        Optional<ActionField> field = this.getField(name);
        if (field.isPresent() && this.isSelectionType(field.get())) {
            field.get().getOptions().getEntries().forEach(o -> o.setSelected(false));
        }
        return this;
    }

    private boolean isSelectionType(ActionField actionField) {
        return Arrays.asList(FieldType.LIST_CHECKBOX, FieldType.LIST_RADIO, FieldType.LIST_SELECT).contains((Object)actionField.getFieldType());
    }

    public Optional<ActionField> getField(List<ActionField> fields, String name) {
        Optional<ActionField> flatField = fields.stream().filter(f -> f.getName().equals(name)).findFirst();
        if (flatField.isPresent()) {
            return flatField;
        }
        if (!name.contains(".")) {
            return Optional.empty();
        }
        String[] segments = name.split("\\.");
        Optional<ActionField> root = fields.stream().filter(f -> f.getName().equals(segments[0])).findFirst();
        if (root.isPresent()) {
            return this.getField(root.get().getFields(), StringUtils.join((Object[])Arrays.copyOfRange(segments, 1, segments.length), (String)"."));
        }
        return Optional.empty();
    }

    public Optional<ActionField> getField(String name) {
        return this.getField(((Action)this.action.getBody()).getFields(), name);
    }
}

