/*
 * appNG REST API
 * The REST API for appNG
 *
 * OpenAPI spec version: 1.0.0
 * Contact: matthias.mueller@appng.org
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package org.appng.api.rest.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.appng.api.rest.model.ActionField;
import org.appng.api.rest.model.Message;
import org.appng.api.rest.model.Parameter;
import org.appng.api.rest.model.Permission;
import org.appng.api.rest.model.User;
import java.io.Serializable;

/**
 * An action, representing an executable operation.
 */
@ApiModel(description = "An action, representing an executable operation.")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-09-24T08:50:35.297+02:00")
public class Action implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("id")
  private String id = null;

  @JsonProperty("event-id")
  private String eventId = null;

  @JsonProperty("parameters")
  private List<Parameter> parameters = null;

  @JsonProperty("user")
  private User user = null;

  @JsonProperty("messages")
  private List<Message> messages = null;

  @JsonProperty("fields")
  private List<ActionField> fields = null;

  @JsonProperty("permissions")
  private List<Permission> permissions = null;

  public Action id(String id) {
    this.id = id;
    return this;
  }

   /**
   * The Id of the action.
   * @return id
  **/
  @ApiModelProperty(value = "The Id of the action.")
  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public Action eventId(String eventId) {
    this.eventId = eventId;
    return this;
  }

   /**
   * The event-Id of the action.
   * @return eventId
  **/
  @ApiModelProperty(value = "The event-Id of the action.")
  public String getEventId() {
    return eventId;
  }

  public void setEventId(String eventId) {
    this.eventId = eventId;
  }

  public Action parameters(List<Parameter> parameters) {
    this.parameters = parameters;
    return this;
  }

  public Action addParametersItem(Parameter parametersItem) {
    if (this.parameters == null) {
      this.parameters = new ArrayList<Parameter>();
    }
    this.parameters.add(parametersItem);
    return this;
  }

   /**
   * A list of parameters for the action
   * @return parameters
  **/
  @ApiModelProperty(value = "A list of parameters for the action")
  public List<Parameter> getParameters() {
    return parameters;
  }

  public void setParameters(List<Parameter> parameters) {
    this.parameters = parameters;
  }

  public Action user(User user) {
    this.user = user;
    return this;
  }

   /**
   * The current user.
   * @return user
  **/
  @ApiModelProperty(value = "The current user.")
  public User getUser() {
    return user;
  }

  public void setUser(User user) {
    this.user = user;
  }

  public Action messages(List<Message> messages) {
    this.messages = messages;
    return this;
  }

  public Action addMessagesItem(Message messagesItem) {
    if (this.messages == null) {
      this.messages = new ArrayList<Message>();
    }
    this.messages.add(messagesItem);
    return this;
  }

   /**
   * A list of messages.
   * @return messages
  **/
  @ApiModelProperty(value = "A list of messages.")
  public List<Message> getMessages() {
    return messages;
  }

  public void setMessages(List<Message> messages) {
    this.messages = messages;
  }

  public Action fields(List<ActionField> fields) {
    this.fields = fields;
    return this;
  }

  public Action addFieldsItem(ActionField fieldsItem) {
    if (this.fields == null) {
      this.fields = new ArrayList<ActionField>();
    }
    this.fields.add(fieldsItem);
    return this;
  }

   /**
   * A list of action-fields.
   * @return fields
  **/
  @ApiModelProperty(value = "A list of action-fields.")
  public List<ActionField> getFields() {
    return fields;
  }

  public void setFields(List<ActionField> fields) {
    this.fields = fields;
  }

  public Action permissions(List<Permission> permissions) {
    this.permissions = permissions;
    return this;
  }

  public Action addPermissionsItem(Permission permissionsItem) {
    if (this.permissions == null) {
      this.permissions = new ArrayList<Permission>();
    }
    this.permissions.add(permissionsItem);
    return this;
  }

   /**
   * The permissions for this action.
   * @return permissions
  **/
  @ApiModelProperty(value = "The permissions for this action.")
  public List<Permission> getPermissions() {
    return permissions;
  }

  public void setPermissions(List<Permission> permissions) {
    this.permissions = permissions;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Action action = (Action) o;
    return Objects.equals(this.id, action.id) &&
        Objects.equals(this.eventId, action.eventId) &&
        Objects.equals(this.parameters, action.parameters) &&
        Objects.equals(this.user, action.user) &&
        Objects.equals(this.messages, action.messages) &&
        Objects.equals(this.fields, action.fields) &&
        Objects.equals(this.permissions, action.permissions);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, eventId, parameters, user, messages, fields, permissions);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Action {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    eventId: ").append(toIndentedString(eventId)).append("\n");
    sb.append("    parameters: ").append(toIndentedString(parameters)).append("\n");
    sb.append("    user: ").append(toIndentedString(user)).append("\n");
    sb.append("    messages: ").append(toIndentedString(messages)).append("\n");
    sb.append("    fields: ").append(toIndentedString(fields)).append("\n");
    sb.append("    permissions: ").append(toIndentedString(permissions)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

