/*
 * Decompiled with CFR 0.152.
 */
package org.appng.api.rest.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.appng.api.rest.model.FieldType;
import org.appng.api.rest.model.Sort;
import org.appng.api.rest.model.ValidationRule;

@ApiModel(description="A field that is part of a datasource.")
public class Field
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="label")
    private String label = null;
    @JsonProperty(value="fieldType")
    private FieldType fieldType = null;
    @JsonProperty(value="sort")
    private Sort sort = null;
    @JsonProperty(value="format")
    private String format = null;
    @JsonProperty(value="rules")
    private List<ValidationRule> rules = null;
    @JsonProperty(value="fields")
    private List<Field> fields = null;

    public Field name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="The name for this field.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Field label(String label) {
        this.label = label;
        return this;
    }

    @ApiModelProperty(value="The label for this field.")
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Field fieldType(FieldType fieldType) {
        this.fieldType = fieldType;
        return this;
    }

    @ApiModelProperty(required=true, value="The type for this field.")
    public FieldType getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(FieldType fieldType) {
        this.fieldType = fieldType;
    }

    public Field sort(Sort sort) {
        this.sort = sort;
        return this;
    }

    @ApiModelProperty(value="The sort for this field.")
    public Sort getSort() {
        return this.sort;
    }

    public void setSort(Sort sort) {
        this.sort = sort;
    }

    public Field format(String format) {
        this.format = format;
        return this;
    }

    @ApiModelProperty(value="The format for this field, depending on its type.")
    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public Field rules(List<ValidationRule> rules) {
        this.rules = rules;
        return this;
    }

    public Field addRulesItem(ValidationRule rulesItem) {
        if (this.rules == null) {
            this.rules = new ArrayList<ValidationRule>();
        }
        this.rules.add(rulesItem);
        return this;
    }

    @ApiModelProperty(value="The validation rules that should be applied for this field.")
    public List<ValidationRule> getRules() {
        return this.rules;
    }

    public void setRules(List<ValidationRule> rules) {
        this.rules = rules;
    }

    public Field fields(List<Field> fields) {
        this.fields = fields;
        return this;
    }

    public Field addFieldsItem(Field fieldsItem) {
        if (this.fields == null) {
            this.fields = new ArrayList<Field>();
        }
        this.fields.add(fieldsItem);
        return this;
    }

    @ApiModelProperty(value="The child fields of this field.")
    public List<Field> getFields() {
        return this.fields;
    }

    public void setFields(List<Field> fields) {
        this.fields = fields;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Field field = (Field)o;
        return Objects.equals(this.name, field.name) && Objects.equals(this.label, field.label) && Objects.equals((Object)this.fieldType, (Object)field.fieldType) && Objects.equals(this.sort, field.sort) && Objects.equals(this.format, field.format) && Objects.equals(this.rules, field.rules) && Objects.equals(this.fields, field.fields);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.label, this.fieldType, this.sort, this.format, this.rules, this.fields});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Field {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    label: ").append(this.toIndentedString(this.label)).append("\n");
        sb.append("    fieldType: ").append(this.toIndentedString((Object)this.fieldType)).append("\n");
        sb.append("    sort: ").append(this.toIndentedString(this.sort)).append("\n");
        sb.append("    format: ").append(this.toIndentedString(this.format)).append("\n");
        sb.append("    rules: ").append(this.toIndentedString(this.rules)).append("\n");
        sb.append("    fields: ").append(this.toIndentedString(this.fields)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

