/*
 * Decompiled with CFR 0.152.
 */
package org.appng.api.rest.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.appng.api.rest.model.FieldType;
import org.appng.api.rest.model.Message;
import org.appng.api.rest.model.Options;
import org.appng.api.rest.model.ValidationRule;

@ApiModel(description="A single field as a part of an action.")
public class ActionField
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="value")
    private Object value = null;
    @JsonProperty(value="label")
    private String label = null;
    @JsonProperty(value="fieldType")
    private FieldType fieldType = null;
    @JsonProperty(value="readonly")
    private Boolean readonly = null;
    @JsonProperty(value="visible")
    private Boolean visible = null;
    @JsonProperty(value="format")
    private String format = null;
    @JsonProperty(value="formattedValue")
    private String formattedValue = null;
    @JsonProperty(value="options")
    private Options options = null;
    @JsonProperty(value="rules")
    private List<ValidationRule> rules = null;
    @JsonProperty(value="messages")
    private List<Message> messages = null;
    @JsonProperty(value="fields")
    private List<ActionField> fields = null;

    public ActionField name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The name of the field.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ActionField value(Object value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(value="The value of the field. The concrete type of that object depends on the fieldType of this field.")
    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public ActionField label(String label) {
        this.label = label;
        return this;
    }

    @ApiModelProperty(value="The label for the field.")
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public ActionField fieldType(FieldType fieldType) {
        this.fieldType = fieldType;
        return this;
    }

    @ApiModelProperty(value="The type for the field.")
    public FieldType getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(FieldType fieldType) {
        this.fieldType = fieldType;
    }

    public ActionField readonly(Boolean readonly) {
        this.readonly = readonly;
        return this;
    }

    @ApiModelProperty(value="Whether or not this field is read-only.")
    public Boolean isReadonly() {
        return this.readonly;
    }

    public void setReadonly(Boolean readonly) {
        this.readonly = readonly;
    }

    public ActionField visible(Boolean visible) {
        this.visible = visible;
        return this;
    }

    @ApiModelProperty(value="Whether or not this field should be visible.")
    public Boolean isVisible() {
        return this.visible;
    }

    public void setVisible(Boolean visible) {
        this.visible = visible;
    }

    public ActionField format(String format) {
        this.format = format;
        return this;
    }

    @ApiModelProperty(value="The format for this field, depending on its type.")
    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public ActionField formattedValue(String formattedValue) {
        this.formattedValue = formattedValue;
        return this;
    }

    @ApiModelProperty(value="The formatted value for this field.")
    public String getFormattedValue() {
        return this.formattedValue;
    }

    public void setFormattedValue(String formattedValue) {
        this.formattedValue = formattedValue;
    }

    public ActionField options(Options options) {
        this.options = options;
        return this;
    }

    @ApiModelProperty(value="The options for this filter.")
    public Options getOptions() {
        return this.options;
    }

    public void setOptions(Options options) {
        this.options = options;
    }

    public ActionField rules(List<ValidationRule> rules) {
        this.rules = rules;
        return this;
    }

    public ActionField addRulesItem(ValidationRule rulesItem) {
        if (this.rules == null) {
            this.rules = new ArrayList<ValidationRule>();
        }
        this.rules.add(rulesItem);
        return this;
    }

    @ApiModelProperty(value="The validation rules that should be applied for this field.")
    public List<ValidationRule> getRules() {
        return this.rules;
    }

    public void setRules(List<ValidationRule> rules) {
        this.rules = rules;
    }

    public ActionField messages(List<Message> messages) {
        this.messages = messages;
        return this;
    }

    public ActionField addMessagesItem(Message messagesItem) {
        if (this.messages == null) {
            this.messages = new ArrayList<Message>();
        }
        this.messages.add(messagesItem);
        return this;
    }

    @ApiModelProperty(value="The messages related to this field.")
    public List<Message> getMessages() {
        return this.messages;
    }

    public void setMessages(List<Message> messages) {
        this.messages = messages;
    }

    public ActionField fields(List<ActionField> fields) {
        this.fields = fields;
        return this;
    }

    public ActionField addFieldsItem(ActionField fieldsItem) {
        if (this.fields == null) {
            this.fields = new ArrayList<ActionField>();
        }
        this.fields.add(fieldsItem);
        return this;
    }

    @ApiModelProperty(value="The child fields of this fieldValue.")
    public List<ActionField> getFields() {
        return this.fields;
    }

    public void setFields(List<ActionField> fields) {
        this.fields = fields;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActionField actionField = (ActionField)o;
        return Objects.equals(this.name, actionField.name) && Objects.equals(this.value, actionField.value) && Objects.equals(this.label, actionField.label) && Objects.equals((Object)this.fieldType, (Object)actionField.fieldType) && Objects.equals(this.readonly, actionField.readonly) && Objects.equals(this.visible, actionField.visible) && Objects.equals(this.format, actionField.format) && Objects.equals(this.formattedValue, actionField.formattedValue) && Objects.equals(this.options, actionField.options) && Objects.equals(this.rules, actionField.rules) && Objects.equals(this.messages, actionField.messages) && Objects.equals(this.fields, actionField.fields);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.value, this.label, this.fieldType, this.readonly, this.visible, this.format, this.formattedValue, this.options, this.rules, this.messages, this.fields});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ActionField {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    label: ").append(this.toIndentedString(this.label)).append("\n");
        sb.append("    fieldType: ").append(this.toIndentedString((Object)this.fieldType)).append("\n");
        sb.append("    readonly: ").append(this.toIndentedString(this.readonly)).append("\n");
        sb.append("    visible: ").append(this.toIndentedString(this.visible)).append("\n");
        sb.append("    format: ").append(this.toIndentedString(this.format)).append("\n");
        sb.append("    formattedValue: ").append(this.toIndentedString(this.formattedValue)).append("\n");
        sb.append("    options: ").append(this.toIndentedString(this.options)).append("\n");
        sb.append("    rules: ").append(this.toIndentedString(this.rules)).append("\n");
        sb.append("    messages: ").append(this.toIndentedString(this.messages)).append("\n");
        sb.append("    fields: ").append(this.toIndentedString(this.fields)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

