/*
 * Decompiled with CFR 0.152.
 */
package org.appng.api.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.appng.api.rest.RestResponseEntity;
import org.appng.api.rest.model.Action;
import org.appng.api.rest.model.Datasource;
import org.appng.api.rest.model.ErrorModel;
import org.appng.api.rest.model.Link;
import org.appng.api.rest.model.Parameter;
import org.appng.api.rest.model.Sort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.ResourceHttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.DefaultResponseErrorHandler;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;

public class RestClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestClient.class);
    private static final String PATH_SEPARATOR = "/";
    protected RestTemplate restTemplate;
    protected Map<String, String> cookies;
    protected String url;
    private ObjectMapper objectMapper;

    public RestClient(String url) {
        this(url, new HashMap<String, String>());
    }

    public RestClient(String url, Map<String, String> cookies) {
        this.url = url;
        this.cookies = cookies;
        this.restTemplate = new RestTemplate(Arrays.asList(new ByteArrayHttpMessageConverter(), new StringHttpMessageConverter(), new MappingJackson2HttpMessageConverter(), new ResourceHttpMessageConverter()));
        this.restTemplate.setErrorHandler((ResponseErrorHandler)new DefaultResponseErrorHandler(){

            protected boolean hasError(HttpStatus statusCode) {
                return statusCode.series() == HttpStatus.Series.SERVER_ERROR;
            }
        });
        this.objectMapper = new ObjectMapper();
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_ABSENT);
    }

    public RestResponseEntity<Datasource> datasource(String application, String id) throws URISyntaxException {
        return this.datasource(application, id, (Pageable)null);
    }

    public RestResponseEntity<Datasource> datasource(String application, String id, Pageable pageable) throws URISyntaxException {
        return this.datasource(application, id, pageable, null);
    }

    public RestResponseEntity<Datasource> datasource(String application, String id, MultiValueMap<String, String> parameters) throws URISyntaxException {
        return this.datasource(application, id, null, parameters);
    }

    public RestResponseEntity<Datasource> datasource(String application, String id, Pageable pageable, MultiValueMap<String, String> parameters) throws URISyntaxException {
        StringBuilder uriBuilder = new StringBuilder(this.url).append(PATH_SEPARATOR).append(application);
        uriBuilder.append("/rest/datasource/").append(id).append("?");
        if (null != pageable) {
            uriBuilder.append("sort").append(StringUtils.capitalize((String)id)).append("=").append(pageable.getSortQuery()).append("&");
        }
        if (null != parameters) {
            parameters.keySet().forEach(key -> ((List)parameters.get(key)).forEach(value -> uriBuilder.append((String)key).append("=").append((String)value).append("&")));
        }
        return this.exchange(new URI(uriBuilder.toString()), null, HttpMethod.GET, Datasource.class);
    }

    public RestResponseEntity<Action> getAction(String application, String eventId, String actionId, String ... pathVariables) throws URISyntaxException {
        URI actionURL = this.getActionURL(application, eventId, actionId, pathVariables);
        return this.exchange(actionURL, null, HttpMethod.GET, Action.class);
    }

    private void doLog(String prefix, Object body, HttpStatus httpStatus) {
        if (LOGGER.isDebugEnabled()) {
            String content = "";
            if (null != body) {
                Class<?> bodyType = body.getClass();
                if (!bodyType.isPrimitive() && !bodyType.isArray() && bodyType.getPackage().getName().startsWith("org.appng.api.rest.model")) {
                    try {
                        content = this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(body);
                    }
                    catch (JsonProcessingException e) {
                        LOGGER.error("error parsing JSON body", (Throwable)e);
                    }
                } else {
                    content = body.toString();
                }
            }
            String status = null != httpStatus ? " " + httpStatus.value() : "";
            LOGGER.debug("{}: {} {}", new Object[]{prefix, status, content});
        }
    }

    public RestResponseEntity<Action> getAction(Link link) throws URISyntaxException {
        String[] pathSegments = link.getTarget().split(PATH_SEPARATOR);
        String servicePath = StringUtils.join((Object[])Arrays.copyOfRange(pathSegments, 3, pathSegments.length), (String)PATH_SEPARATOR);
        URI uri = new URI(this.url + PATH_SEPARATOR + servicePath);
        return this.exchange(uri, null, HttpMethod.GET, Action.class);
    }

    public RestResponseEntity<Action> performAction(Action data, Link link) throws URISyntaxException {
        String[] pathSegments = link.getTarget().split(PATH_SEPARATOR);
        URI uri = new URI(this.url + PATH_SEPARATOR + StringUtils.join((Object[])Arrays.copyOfRange(pathSegments, 3, pathSegments.length), (String)PATH_SEPARATOR));
        this.addFormAction(data);
        return this.exchange(uri, data, HttpMethod.POST, Action.class);
    }

    private void addFormAction(Action data) {
        Parameter formAction = new Parameter();
        formAction.setName("form_action");
        formAction.setValue(data.getId());
        data.addParametersItem(formAction);
    }

    protected void setCookies(ResponseEntity<?> entity) {
        List setCookies = entity.getHeaders().get((Object)"Set-Cookie");
        if (null != setCookies) {
            for (String c : setCookies) {
                int valueStart = c.indexOf(61);
                String name = c.substring(0, valueStart);
                int end = c.indexOf(59);
                String value = c.substring(valueStart + 1, end < 0 ? c.length() : end);
                this.cookies.put(name, value);
                LOGGER.debug("received cookie: {}={}", (Object)name, (Object)value);
            }
        }
    }

    protected URI getActionURL(String application, String eventId, String actionId, String[] pathVariables) throws URISyntaxException {
        String uriString = String.format("%s/%s/rest/action/%s/%s/%s", this.url, application, eventId, actionId, StringUtils.join((Object[])pathVariables, (String)PATH_SEPARATOR));
        return new URI(uriString);
    }

    public RestResponseEntity<Action> performAction(String application, Action data, String ... pathVariables) throws URISyntaxException {
        this.addFormAction(data);
        URI actionURL = this.getActionURL(application, data.getEventId(), data.getId(), pathVariables);
        return this.exchange(actionURL, data, HttpMethod.POST, Action.class);
    }

    protected HttpHeaders getHeaders(boolean acceptAnyType) {
        HttpHeaders headers = new HttpHeaders();
        if (!this.cookies.isEmpty()) {
            this.cookies.keySet().forEach(k -> {
                String cookie = this.cookies.get(k);
                headers.add("Cookie", k + "=" + cookie);
                LOGGER.debug("sent cookie: {}={}", k, (Object)this.cookies.get(k));
            });
        }
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        List<MediaType> acceptableMediaTypes = acceptAnyType ? Arrays.asList(MediaType.ALL) : Arrays.asList(MediaType.APPLICATION_JSON_UTF8);
        headers.setAccept(acceptableMediaTypes);
        headers.set("User-Agent", "appNG Rest Client");
        return headers;
    }

    public Map<String, String> getCookies() {
        return this.cookies;
    }

    public RestResponseEntity<byte[]> getBinaryData(Link link) throws URISyntaxException {
        String path = this.getRelativePathFromLink(link);
        return this.getResource(path, byte[].class);
    }

    private String getRelativePathFromLink(Link link) {
        String[] pathSegments = link.getTarget().split(PATH_SEPARATOR);
        String path = PATH_SEPARATOR + StringUtils.join((Object[])Arrays.copyOfRange(pathSegments, 3, pathSegments.length), (String)PATH_SEPARATOR);
        return path;
    }

    public RestResponseEntity<byte[]> getBinaryData(String relativePath) throws URISyntaxException {
        return this.getResource(relativePath, byte[].class);
    }

    public <OUT, IN> RestResponseEntity<IN> exchange(String path, OUT body, Class<IN> returnType, HttpMethod method) throws URISyntaxException {
        return this.exchange(new URI(this.url + path), body, method, returnType);
    }

    protected <IN, OUT> RestResponseEntity<IN> exchange(URI uri, OUT body, HttpMethod method, Class<IN> returnType) {
        return this.exchange(uri, body, method, returnType, false);
    }

    protected <IN, OUT> RestResponseEntity<IN> exchange(URI uri, OUT body, HttpMethod method, Class<IN> returnType, boolean acceptAnyType) {
        if (LOGGER.isDebugEnabled() && body != null) {
            this.doLog("OUT", body, null);
        }
        try {
            RequestEntity out = new RequestEntity(body, (MultiValueMap)this.getHeaders(acceptAnyType), method, uri);
            ResponseEntity in = this.restTemplate.exchange(out, returnType);
            this.setCookies(in);
            if (LOGGER.isDebugEnabled() && in.getBody() != null) {
                this.doLog("IN", in.getBody(), in.getStatusCode());
            }
            return RestResponseEntity.of(in);
        }
        catch (HttpServerErrorException e) {
            ErrorModel errorModel = null;
            try {
                String bodyAsString = e.getResponseBodyAsString();
                if (StringUtils.isNotBlank((CharSequence)bodyAsString)) {
                    errorModel = (ErrorModel)this.objectMapper.readerFor(ErrorModel.class).readValue(bodyAsString);
                }
            }
            catch (IOException ioe) {
                LOGGER.error("could not read error from response", (Throwable)e);
            }
            if (null == errorModel) {
                errorModel = new ErrorModel();
                errorModel.setCode(e.getStatusCode().value());
                errorModel.setMessage(e.getMessage());
            }
            return new RestResponseEntity(errorModel, (MultiValueMap<String, String>)e.getResponseHeaders(), e.getStatusCode());
        }
    }

    public <IN> RestResponseEntity<IN> getResource(String path, Class<IN> returnType) throws URISyntaxException {
        return this.exchange(new URI(this.url + path), null, HttpMethod.GET, returnType, true);
    }

    public static class Pageable {
        private int page = 0;
        private int pageSize = 10;
        private Map<String, Sort.OrderEnum> fieldSorts = new HashMap<String, Sort.OrderEnum>();
        private boolean reset = false;

        public Pageable(int page, int pageSize) {
            this(page, pageSize, false);
        }

        public Pageable(int page, int pageSize, boolean reset) {
            this.page = page;
            this.pageSize = pageSize;
            this.reset = reset;
        }

        public Pageable(int page, int pageSize, String field, Sort.OrderEnum order) {
            this(page, pageSize, field, order, false);
        }

        public Pageable(int page, int pageSize, String field, Sort.OrderEnum order, boolean reset) {
            this.setPage(page);
            this.setPageSize(pageSize);
            this.addSort(field, order);
            this.reset = reset;
        }

        public Pageable addSort(String field, Sort.OrderEnum direction) {
            this.fieldSorts.put(field, direction);
            return this;
        }

        public String getSortQuery() {
            StringBuilder sortBuilder = new StringBuilder();
            sortBuilder.append("page:").append(this.page).append(";");
            sortBuilder.append("pageSize:").append(this.pageSize).append(";");
            if (this.fieldSorts != null) {
                for (String field : this.fieldSorts.keySet()) {
                    sortBuilder.append(field).append(":").append(this.fieldSorts.get(field).getValue()).append(";");
                }
            }
            if (this.reset) {
                sortBuilder.append("reset");
            }
            return sortBuilder.toString();
        }

        public int getPage() {
            return this.page;
        }

        public int getPageSize() {
            return this.pageSize;
        }

        public Map<String, Sort.OrderEnum> getFieldSorts() {
            return this.fieldSorts;
        }

        public boolean isReset() {
            return this.reset;
        }

        public void setPage(int page) {
            this.page = page;
        }

        public void setPageSize(int pageSize) {
            this.pageSize = pageSize;
        }

        public void setFieldSorts(Map<String, Sort.OrderEnum> fieldSorts) {
            this.fieldSorts = fieldSorts;
        }

        public void setReset(boolean reset) {
            this.reset = reset;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Pageable)) {
                return false;
            }
            Pageable other = (Pageable)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getPage() != other.getPage()) {
                return false;
            }
            if (this.getPageSize() != other.getPageSize()) {
                return false;
            }
            Map<String, Sort.OrderEnum> this$fieldSorts = this.getFieldSorts();
            Map<String, Sort.OrderEnum> other$fieldSorts = other.getFieldSorts();
            if (this$fieldSorts == null ? other$fieldSorts != null : !((Object)this$fieldSorts).equals(other$fieldSorts)) {
                return false;
            }
            return this.isReset() == other.isReset();
        }

        protected boolean canEqual(Object other) {
            return other instanceof Pageable;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getPage();
            result = result * 59 + this.getPageSize();
            Map<String, Sort.OrderEnum> $fieldSorts = this.getFieldSorts();
            result = result * 59 + ($fieldSorts == null ? 43 : ((Object)$fieldSorts).hashCode());
            result = result * 59 + (this.isReset() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "RestClient.Pageable(page=" + this.getPage() + ", pageSize=" + this.getPageSize() + ", fieldSorts=" + this.getFieldSorts() + ", reset=" + this.isReset() + ")";
        }

        public Pageable() {
        }

        @ConstructorProperties(value={"page", "pageSize", "fieldSorts", "reset"})
        public Pageable(int page, int pageSize, Map<String, Sort.OrderEnum> fieldSorts, boolean reset) {
            this.page = page;
            this.pageSize = pageSize;
            this.fieldSorts = fieldSorts;
            this.reset = reset;
        }
    }
}

