package org.appng.application.manager;

public class MessageConstants {

	/** All Applications */
	public static final String REPOSITORY_MODE_ALL = "RepositoryMode.ALL";
	/** Only Snapshot-Applications */
	public static final String REPOSITORY_MODE_SNAPSHOT = "RepositoryMode.SNAPSHOT";
	/** Only Stable-Applications */
	public static final String REPOSITORY_MODE_STABLE = "RepositoryMode.STABLE";
	/** Local Repository */
	public static final String REPOSITORY_TYPE_LOCAL = "RepositoryType.LOCAL";
	/** Published Repository */
	public static final String REPOSITORY_TYPE_REMOTE = "RepositoryType.REMOTE";
	/** LDAP Group */
	public static final String USER_TYPE_GLOBAL_GROUP = "UserType.GLOBAL_GROUP";
	/** LDAP User */
	public static final String USER_TYPE_GLOBAL_USER = "UserType.GLOBAL_USER";
	/** Local User */
	public static final String USER_TYPE_LOCAL_USER = "UserType.LOCAL_USER";
	/** Actions */
	public static final String ACTIONS = "actions";
	/** Activate */
	public static final String ACTIVATE = "activate";
	/** Active */
	public static final String ACTIVE = "active";
	/** Active Value */
	public static final String ACTIVE_VALUE = "activeValue";
	/** appNG version */
	public static final String APP_NG_VERSION = "appNGVersion";
	/** Application */
	public static final String APPLICATION = "application";
	/** Application {0} has been activated. */
	public static final String APPLICATION_ACTIVATED = "application.activated";
	/** Do you really want to deactivate the application "{0}" for the site "{1}"? This causes the loss of the application''s configuration for this site and -if the root database connection is managed- also of its data! */
	public static final String APPLICATION_DEACTIVATE_CONFIRM = "application.deactivate.confirm";
	/** Application {0} has been deactivated. */
	public static final String APPLICATION_DEACTIVATED = "application.deactivated";
	/** Delete application */
	public static final String APPLICATION_DELETE = "application.delete";
	/** Do you really want to delete the application "{0}"? */
	public static final String APPLICATION_DELETE_CONFIRM = "application.delete.confirm";
	/** Failed to delete the application. */
	public static final String APPLICATION_DELETE_ERROR = "application.delete.error";
	/** Application cannot be deleted, because it is used by active site "{0}" with ID {1}. */
	public static final String APPLICATION_DELETE_ERROR_WITH_CAUSE = "application.delete.error.with.cause";
	/** Application has been deleted. */
	public static final String APPLICATION_DELETED = "application.deleted";
	/** Required application does not exist. */
	public static final String APPLICATION_NOT_EXISTS = "application.notExists";
	/** Application properties */
	public static final String APPLICATION_PROPERTIES = "application.properties";
	/** Application has been removed from site {0}. */
	public static final String APPLICATION_REMOVED_FROM_SITE = "application.removed.from.site";
	/** Toggle application */
	public static final String APPLICATION_TOGGLE = "application.toggle";
	/** Update application */
	public static final String APPLICATION_UPDATE = "application.update";
	/** Failed to update the application. */
	public static final String APPLICATION_UPDATE_ERROR = "application.update.error";
	/** Application has been updated. */
	public static final String APPLICATION_UPDATED = "application.updated";
	/** Applications */
	public static final String APPLICATIONS = "applications";
	/** Beans */
	public static final String BEANS = "beans";
	/** Show Beans */
	public static final String BEANS_SHOW = "beans.show";
	/** Clear cache */
	public static final String CACHE_CLEAR = "cache.clear";
	/** Cache has been cleared. */
	public static final String CACHE_CLEARED = "cache.cleared";
	/** The element has been removed from cache. */
	public static final String CACHE_ELEMENT_DELETED = "cache.element.deleted";
	/** Remove element from cache */
	public static final String CACHE_ELEMENT_EXPIRE = "cache.element.expire";
	/** The cache element does not exist. */
	public static final String CACHE_ELEMENT_NOT_EXISTS = "cache.element.notExists";
	/** Cache elements */
	public static final String CACHE_ELEMENTS = "cache.elements";
	/** Cache statistics */
	public static final String CACHE_STATISTICS = "cache.statistics";
	/** Clear cache statistics */
	public static final String CACHE_STATISTICS_CLEAR = "cache.statistics.clear";
	/** Cache statistics have been cleared. */
	public static final String CACHE_STATISTICS_CLEARED = "cache.statistics.cleared";
	/** Changed on */
	public static final String CHANGED_ON = "changedOn";
	/** Multilined value */
	public static final String CLOBVALUE = "clobvalue";
	/** Clustering is disabled. */
	public static final String CLUSTER_DISABLED = "cluster.disabled";
	/** No cluster information available, please check your configuration! */
	public static final String CLUSTER_NOT_AVAILABLE = "cluster.notAvailable";
	/** Cluster Status */
	public static final String CLUSTER_STATE = "clusterState";
	/** Database connection */
	public static final String CONNECTION = "connection";
	/** Do you really want to reset the database connection "{0}"? */
	public static final String CONNECTION_CONFIRM_RESET = "connection.confirm.reset";
	/** Create database connection */
	public static final String CONNECTION_CREATE = "connection.create";
	/** Connection created. */
	public static final String CONNECTION_CREATED = "connection.created";
	/** Delete database connection */
	public static final String CONNECTION_DELETE = "connection.delete";
	/** Do you really want to delete the database connection "{0}"? */
	public static final String CONNECTION_DELETE_CONFIRM = "connection.delete.confirm";
	/** Connection deleted. */
	public static final String CONNECTION_DELETED = "connection.deleted";
	/** Edit database connection */
	public static final String CONNECTION_EDIT = "connection.edit";
	/** Execute SQL */
	public static final String CONNECTION_EXECUTE_SQL = "connection.executeSql";
	/** Connection is not working, please check settings! */
	public static final String CONNECTION_FAILED = "connection.failed";
	/** Unknown connection */
	public static final String CONNECTION_NO_SUCH_ID = "connection.noSuchId";
	/** Connection "{0}" is not working and therefore was deactivated. */
	public static final String CONNECTION_NOT_ACTIVE = "connection.notActive";
	/** Reset database connection */
	public static final String CONNECTION_RESET = "connection.reset";
	/** Connection is working: {0} */
	public static final String CONNECTION_SUCCESSFULL = "connection.successfull";
	/** Test database connection */
	public static final String CONNECTION_TEST = "connection.test";
	/** Connection updated. */
	public static final String CONNECTION_UPDATED = "connection.updated";
	/** Database connections */
	public static final String CONNECTIONS = "connections";
	/** Content */
	public static final String CONTENT = "content";
	/** Context */
	public static final String CONTEXT = "context";
	/** Created */
	public static final String CREATED = "created";
	/** Created after */
	public static final String CREATED_AFTER = "createdAfter";
	/** Created before */
	public static final String CREATED_BEFORE = "createdBefore";
	/** Created or updated */
	public static final String CREATED_OR_UPDATED = "createdOrUpdated";
	/** Date */
	public static final String DATE = "date";
	/** Deactivate */
	public static final String DEACTIVATE = "deactivate";
	/** Default-Value */
	public static final String DEFAULTVALUE = "defaultvalue";
	/** Delete */
	public static final String DELETE = "delete";
	/** Description */
	public static final String DESCRIPTION = "description";
	/** Dictionary */
	public static final String DICTIONARY = "dictionary";
	/** Digest */
	public static final String DIGEST = "digest";
	/** Display name */
	public static final String DISPLAY_NAME = "displayName";
	/** Domain */
	public static final String DOMAIN = "domain";
	/** Driver-Class */
	public static final String DRIVER_CLASS = "driverClass";
	/** Edit */
	public static final String EDIT = "edit";
	/** E-mail */
	public static final String EMAIL = "email";
	/** Environment */
	public static final String ENVIRONMENT = "environment";
	/** Event */
	public static final String EVENT = "event";
	/** {0} database for site ''{1}'' located at ''{3}'' is not reachable */
	public static final String EVENT_DATABASE_NOTREACHABLE = "event.database.notreachable";
	/** Size of {0} root database located at ''{1}'' is {3}MB */
	public static final String EVENT_DATABASE_ROOT_SIZE = "event.database.root.size";
	/** Size of {0} database for site ''{1}'' located at ''{2}'' is {3}MB */
	public static final String EVENT_DATABASE_SIZE = "event.database.size";
	/** Events */
	public static final String EVENTS = "events";
	/** Export to .xlsx */
	public static final String EVENTS_EXPORT = "events.export";
	/** Expiration time */
	public static final String EXPIRATION_TIME = "expirationTime";
	/** Expires */
	public static final String EXPIRES = "expires";
	/** File-based */
	public static final String FILEBASED = "filebased";
	/** Grant */
	public static final String GRANT = "grant";
	/** Granted by */
	public static final String GRANTED_BY = "granted.by";
	/** Granted to */
	public static final String GRANTED_TO = "granted.to";
	/** Group */
	public static final String GROUP = "group";
	/** Failed to assign the group(s). */
	public static final String GROUP_ASSIGN_ERROR = "group.assign.error";
	/** Groups have been assigned. */
	public static final String GROUP_ASSIGNED = "group.assigned";
	/** Create group */
	public static final String GROUP_CREATE = "group.create";
	/** Failed to create the group. */
	public static final String GROUP_CREATE_ERROR = "group.create.error";
	/** Group has been created. */
	public static final String GROUP_CREATED = "group.created";
	/** Delete group */
	public static final String GROUP_DELETE = "group.delete";
	/** Do you really want to delete the group "{0}"? */
	public static final String GROUP_DELETE_CONFIRM = "group.delete.confirm";
	/** Failed to delete the group. */
	public static final String GROUP_DELETE_ERROR = "group.delete.error";
	/** Group has been deleted. */
	public static final String GROUP_DELETED = "group.deleted";
	/** Edit group */
	public static final String GROUP_EDIT = "group.edit";
	/** A group with that name already exists! */
	public static final String GROUP_EXISTS = "group.exists";
	/** Group does not exist. */
	public static final String GROUP_NOT_EXISTS = "group.not.exists";
	/** Failed to update the group. */
	public static final String GROUP_UPDATE_ERROR = "group.update.error";
	/** Group has been updated. */
	public static final String GROUP_UPDATED = "group.updated";
	/** Groups */
	public static final String GROUPS = "groups";
	/** Heap max. */
	public static final String HEAP_MAX = "heap.max";
	/** Heap used */
	public static final String HEAP_USED = "heap.used";
	/** Percentage */
	public static final String HEAP_USED_PERCENT = "heap.usedPercent";
	/** Hidden */
	public static final String HIDDEN = "hidden";
	/** Hits */
	public static final String HIT_COUNT = "hitCount";
	/** Host */
	public static final String HOST = "host";
	/** Host name */
	public static final String HOST_NAME = "hostName";
	/** ID */
	public static final String ID = "id";
	/** Install latest release */
	public static final String INSTALL_LATESTRELEASE = "install.latestrelease";
	/** Install latest snapshot */
	public static final String INSTALL_LATESTSNAPSHOT = "install.latestsnapshot";
	/** Installation */
	public static final String INSTALLATION = "installation";
	/** Installed version */
	public static final String INSTALLED_VERSION = "installedVersion";
	/** JAR-Files */
	public static final String JARS = "jars";
	/** Tomcat JAR-Files */
	public static final String JARS_TOMCAT = "jars.tomcat";
	/** JDBC-URL */
	public static final String JDBC_URL = "jdbcUrl";
	/** JVM Arguments */
	public static final String JVM_ARGUMENTS = "jvmArguments";
	/** Language */
	public static final String LANGUAGE = "language";
	/** Last accessed */
	public static final String LAST_ACCESSED = "lastAccessed";
	/** Last updated */
	public static final String LAST_UPDATED = "lastUpdated";
	/** Latest release */
	public static final String LATEST_RELEASE = "latestRelease";
	/** Latest snapshot */
	public static final String LATEST_SNAPSHOT = "latestSnapshot";
	/** Edit logging configuration */
	public static final String LOGCONFIG_EDIT = "logconfig.edit";
	/** No changes were made, no need to reload. */
	public static final String LOGCONFIG_NOCHANGE = "logconfig.nochange";
	/** Log4j Configuration has been reloaded! */
	public static final String LOGCONFIG_RELOADED = "logconfig.reloaded";
	/** Apply to all cluster nodes */
	public static final String LOGCONFIG_SPREAD_CLUSTER_WIDE = "logconfig.spreadClusterWide";
	/** Logfile */
	public static final String LOGFILE = "logfile";
	/** Long Description */
	public static final String LONG_DESCRIPTION = "longDescription";
	/** managed */
	public static final String MANAGED = "managed";
	/** Max. number of connections */
	public static final String MAX_CONNECTIONS = "maxConnections";
	/** Memory */
	public static final String MEMORY = "memory";
	/** Checksum */
	public static final String MIGRATION_CHECKSUM = "migration.checksum";
	/** Error while deleting the Application-Database: {0}! */
	public static final String MIGRATION_DB_DELETE_FAILED = "migration.dbDeleteFailed";
	/** Application-Database has been deleted: {0} */
	public static final String MIGRATION_DB_DELETED = "migration.dbDeleted";
	/** No matching database is available! */
	public static final String MIGRATION_DB_NOT_AVAILABLE = "migration.dbNotAvailable";
	/** Application-Database has not been deleted: {0} */
	public static final String MIGRATION_DB_NOT_DELETED = "migration.dbNotDeleted";
	/** The required database needs to be configured! */
	public static final String MIGRATION_DB_SUPPORTED = "migration.dbSupported";
	/** Name */
	public static final String MIGRATION_DESCRIPTION = "migration.description";
	/** Migration of database failed! */
	public static final String MIGRATION_FAILED = "migration.failed";
	/** User */
	public static final String MIGRATION_INSTALLED_BY = "migration.installedBy";
	/** Date */
	public static final String MIGRATION_INSTALLED_ON = "migration.installedOn";
	/** Rank */
	public static final String MIGRATION_INSTALLED_RANK = "migration.installedRank";
	/** Application does not require a database. */
	public static final String MIGRATION_NO_DB_SUPPORTED = "migration.noDbSupported";
	/** State */
	public static final String MIGRATION_STATE = "migration.state";
	/** Migration of database successful! */
	public static final String MIGRATION_SUCCESS = "migration.success";
	/** Version */
	public static final String MIGRATION_VERSION = "migration.version";
	/** Migrations */
	public static final String MIGRATIONS = "migrations";
	/** Min. number of connections */
	public static final String MIN_CONNECTIONS = "minConnections";
	/** Mode */
	public static final String MODE = "mode";
	/** Name */
	public static final String NAME = "name";
	/** Node ID */
	public static final String NODE_ID = "nodeId";
	/** non-heap max. */
	public static final String NON_HEAP_MAX = "nonHeap.max";
	/** non-heap used */
	public static final String NON_HEAP_USED = "nonHeap.used";
	/** Percentage */
	public static final String NON_HEAP_USED_PERCENT = "nonHeap.usedPercent";
	/** The required appNG version {0} is newer than the current {1}! */
	public static final String PACKAGE_APP_NG_VERSION_MISMATCH = "package.appNGVersionMismatch";
	/** Failed to delete the package {1}-{2}.  */
	public static final String PACKAGE_DELETE_ERROR = "package.delete.error";
	/** Package {1}-{2} has been deleted. */
	public static final String PACKAGE_DELETED = "package.deleted";
	/** Failed to install the package {1}-{2}.  */
	public static final String PACKAGE_INSTALL_ERROR = "package.install.error";
	/** Package {1}-{2} has been installed. */
	public static final String PACKAGE_INSTALLED = "package.installed";
	/** Show package versions */
	public static final String PACKAGE_SHOW_VERSIONS = "package.showVersions";
	/** Package archive */
	public static final String PACKAGE_ARCHIVE = "packageArchive";
	/** Not a valid package archive! */
	public static final String PACKAGE_ARCHIVE_INVALID = "packageArchive.invalid";
	/** No file selected */
	public static final String PACKAGE_ARCHIVE_NO_FILE = "packageArchive.noFile";
	/** Package versions */
	public static final String PACKAGE_VERSIONS = "packageVersions";
	/** Packages */
	public static final String PACKAGES = "packages";
	/** Package version */
	public static final String PACKAGEVERSION = "packageversion";
	/** Do you really want to delete the package {0}-{1}-{2}? */
	public static final String PACKAGEVERSION_DELETE_CONFIRM = "packageversion.delete.confirm";
	/** Page */
	public static final String PAGE = "page";
	/** Parent */
	public static final String PARENT = "parent";
	/** Password */
	public static final String PASSWORD = "password";
	/** Password confirmation */
	public static final String PASSWORD_CONFIRMATION = "password.confirmation";
	/** Permission */
	public static final String PERMISSION = "permission";
	/** Failed to assign the permission. */
	public static final String PERMISSION_ASSIGN_ERROR = "permission.assign.error";
	/** Permission is assigned. */
	public static final String PERMISSION_ASSIGNED = "permission.assigned";
	/** Create Permission */
	public static final String PERMISSION_CREATE = "permission.create";
	/** Failed to create the permission. */
	public static final String PERMISSION_CREATE_ERROR = "permission.create.error";
	/** Permission has been created. */
	public static final String PERMISSION_CREATED = "permission.created";
	/** Delete Permission */
	public static final String PERMISSION_DELETE = "permission.delete";
	/** Do you really want to delete the permission "{0}"? */
	public static final String PERMISSION_DELETE_CONFIRM = "permission.delete.confirm";
	/** Failed to delete the permission. */
	public static final String PERMISSION_DELETE_ERROR = "permission.delete.error";
	/** Permission has been deleted. */
	public static final String PERMISSION_DELETED = "permission.deleted";
	/** Edit Permission */
	public static final String PERMISSION_EDIT = "permission.edit";
	/** A permission with this name already exists! */
	public static final String PERMISSION_EXISTS = "permission.exists";
	/** Permission does not exist. */
	public static final String PERMISSION_NOT_EXISTS = "permission.not.exists";
	/** Failed to update the permission. */
	public static final String PERMISSION_UPDATE_ERROR = "permission.update.error";
	/** Permission has been updated. */
	public static final String PERMISSION_UPDATED = "permission.updated";
	/** Permissions */
	public static final String PERMISSIONS = "permissions";
	/** Platform */
	public static final String PLATFORM = "platform";
	/** Platform properties */
	public static final String PLATFORM_PROPERTIES = "platform.properties";
	/** Reload platform */
	public static final String PLATFORM_RELOAD = "platform.reload";
	/** Do you really want to reload the platform? */
	public static final String PLATFORM_RELOAD_CONFIRM = "platform.reload.confirm";
	/** Failed to reload the platform. */
	public static final String PLATFORM_RELOAD_ERROR = "platform.reload.error";
	/** Platform has been reloaded! */
	public static final String PLATFORM_RELOADED = "platform.reloaded";
	/** Privileged Application */
	public static final String PRIVILEGED = "privileged";
	/** Create property */
	public static final String PROPERTY_CREATE = "property.create";
	/** Failed to create the property. */
	public static final String PROPERTY_CREATE_ERROR = "property.create.error";
	/** Property has been created. */
	public static final String PROPERTY_CREATED = "property.created";
	/** Delete property */
	public static final String PROPERTY_DELETE = "property.delete";
	/** Do you really want to delete the property "{0}"? */
	public static final String PROPERTY_DELETE_CONFIRM = "property.delete.confirm";
	/** Failed to delete the property. */
	public static final String PROPERTY_DELETE_ERROR = "property.delete.error";
	/** Property has been deleted. */
	public static final String PROPERTY_DELETED = "property.deleted";
	/** Edit property */
	public static final String PROPERTY_EDIT = "property.edit";
	/** Another property with this name already exists. */
	public static final String PROPERTY_EXISTS = "property.exists";
	/** Property does not exist. */
	public static final String PROPERTY_NOT_EXISTS = "property.not.exists";
	/** Please set the value or the multilined value. */
	public static final String PROPERTY_STRING_OR_CLOB = "property.stringOrClob";
	/** Failed to update the property. */
	public static final String PROPERTY_UPDATE_ERROR = "property.update.error";
	/** Property has been updated. */
	public static final String PROPERTY_UPDATED = "property.updated";
	/** Published */
	public static final String PUBLISHED = "published";
	/** Real name */
	public static final String REALNAME = "realname";
	/** Reload */
	public static final String RELOAD = "reload";
	/** Reload the platform to apply the changes!  */
	public static final String RELOAD_PLATFORM = "reloadPlatform";
	/** Requires reload */
	public static final String RELOAD_REQUIRED = "reloadRequired";
	/** Reload the affected site(s) to apply the changes! */
	public static final String RELOAD_SITE = "reloadSite";
	/** Repositories */
	public static final String REPOSITORIES = "repositories";
	/** Repository */
	public static final String REPOSITORY = "repository";
	/** Previously existing file {0} has been overwritten. */
	public static final String REPOSITORY_ARCHIVE_REPLACED = "repository.archive.replaced";
	/** Error while adding {1} to repository. */
	public static final String REPOSITORY_ARCHIVE_UPLOAD_ERROR = "repository.archive.upload.error";
	/** {1} has been added to the repository. */
	public static final String REPOSITORY_ARCHIVE_UPLOADED = "repository.archive.uploaded";
	/** Repository in mode {0} does not allow {1} versions. */
	public static final String REPOSITORY_ARCHIVE_WRONG_MODE = "repository.archive.wrongMode";
	/** Create repository */
	public static final String REPOSITORY_CREATE = "repository.create";
	/** Failed to create the repository. */
	public static final String REPOSITORY_CREATE_ERROR = "repository.create.error";
	/** Repository has been created. */
	public static final String REPOSITORY_CREATED = "repository.created";
	/** Delete repository */
	public static final String REPOSITORY_DELETE = "repository.delete";
	/** Do you really want to delete the repository "{0}"? */
	public static final String REPOSITORY_DELETE_CONFIRM = "repository.delete.confirm";
	/** Failed to delete the repository. */
	public static final String REPOSITORY_DELETE_ERROR = "repository.delete.error";
	/** Delete package */
	public static final String REPOSITORY_DELETE_PACKAGE = "repository.delete.package";
	/** Repository has been deleted. */
	public static final String REPOSITORY_DELETED = "repository.deleted";
	/** Edit repository */
	public static final String REPOSITORY_EDIT = "repository.edit";
	/** Error retrieving packages from repository {0} at {1} */
	public static final String REPOSITORY_ERROR = "repository.error";
	/** A repository with this name already exists! */
	public static final String REPOSITORY_EXISTS = "repository.exists";
	/** Install package */
	public static final String REPOSITORY_INSTALL = "repository.install";
	/** The URI "{0}" does not reference a directory: "{1}" */
	public static final String REPOSITORY_NOT_DIRECTORY_ERROR = "repository.not.directory.error";
	/** The required repository does not exist. */
	public static final String REPOSITORY_NOT_EXISTS = "repository.not.exists";
	/** Package upload */
	public static final String REPOSITORY_PACKAGE_UPLOAD = "repository.packageUpload";
	/** Reload repository */
	public static final String REPOSITORY_RELOAD = "repository.reload";
	/** Do you really want to reload the repository "{0}"? */
	public static final String REPOSITORY_RELOAD_CONFIRM = "repository.reload.confirm";
	/** Failed to reload the Repository. */
	public static final String REPOSITORY_RELOAD_ERROR = "repository.reload.error";
	/** Repository has been reloaded. */
	public static final String REPOSITORY_RELOADED = "repository.reloaded";
	/** Name of remote repository */
	public static final String REPOSITORY_REMOTE_NAME = "repository.remoteName";
	/** Failed to update the repository. */
	public static final String REPOSITORY_UPDATE_ERROR = "repository.update.error";
	/** Repository has been updated. */
	public static final String REPOSITORY_UPDATED = "repository.updated";
	/** Repository-Mode */
	public static final String REPOSITORYMODE = "repositorymode";
	/** Repository-Type */
	public static final String REPOSITORYTYPE = "repositorytype";
	/** Request */
	public static final String REQUEST = "request";
	/** Requests */
	public static final String REQUESTS = "requests";
	/** Reset */
	public static final String RESET = "reset";
	/** Delete resource */
	public static final String RESOURCE_DELETE = "resource.delete";
	/** Do you really want to delete the resource "{0}"? */
	public static final String RESOURCE_DELETE_CONFIRM = "resource.delete.confirm";
	/** Failed to delete the resource. */
	public static final String RESOURCE_DELETE_ERROR = "resource.delete.error";
	/** Resource has been deleted. */
	public static final String RESOURCE_DELETED = "resource.deleted";
	/** Edit resource */
	public static final String RESOURCE_EDIT = "resource.edit";
	/** Existing resource "{0}" was overridden. */
	public static final String RESOURCE_OVERRIDDEN = "resource.overridden";
	/** Updated resource "{0}" in database ({1} bytes) */
	public static final String RESOURCE_UPDATED_DATABASED = "resource.updated.databased";
	/** Error while updating resource "{0}" in database */
	public static final String RESOURCE_UPDATED_DATABASED_ERROR = "resource.updated.databased.error";
	/** Updated resource "{0}" in filesystem ({1} bytes) */
	public static final String RESOURCE_UPDATED_FILEBASED = "resource.updated.filebased";
	/** Error while updating resource "{0}" in filesystem */
	public static final String RESOURCE_UPDATED_FILEBASED_ERROR = "resource.updated.filebased.error";
	/** Upload resource */
	public static final String RESOURCE_UPLOAD = "resource.upload";
	/** Failed to upload the resource or unknown resource-Type. */
	public static final String RESOURCE_UPLOAD_ERROR = "resource.upload.error";
	/** Resource has been uploaded. */
	public static final String RESOURCE_UPLOADED = "resource.uploaded";
	/** If resource-type is "{0}", the file extension must be one of {1} */
	public static final String RESOURCE_WRONG_TYPE = "resource.wrongType";
	/** Resources */
	public static final String RESOURCES = "resources";
	/** Edit resources */
	public static final String RESOURCES_EDIT = "resources.edit";
	/** Result */
	public static final String RESULT = "result";
	/** Role */
	public static final String ROLE = "role";
	/** Create role */
	public static final String ROLE_CREATE = "role.create";
	/** Failed to create the role. */
	public static final String ROLE_CREATE_ERROR = "role.create.error";
	/** Role has been created. */
	public static final String ROLE_CREATED = "role.created";
	/** Do you really want to delete the role "{0}"? */
	public static final String ROLE_DELETE_CONFIRM = "role.delete.confirm";
	/** Failed to delete the role. */
	public static final String ROLE_DELETE_ERROR = "role.delete.error";
	/** Role has been deleted. */
	public static final String ROLE_DELETED = "role.deleted";
	/** Edit role */
	public static final String ROLE_EDIT = "role.edit";
	/** A Role with this name already exists. */
	public static final String ROLE_EXISTS = "role.exists";
	/** Role does not exist. */
	public static final String ROLE_NOT_EXISTS = "role.not.exists";
	/** Failed to update the role. */
	public static final String ROLE_UPDATE_ERROR = "role.update.error";
	/** Role has been updated. */
	public static final String ROLE_UPDATED = "role.updated";
	/** Roles */
	public static final String ROLES = "roles";
	/** Running */
	public static final String RUNNING = "running";
	/** Select */
	public static final String SELECT = "select";
	/** Selected */
	public static final String SELECTED = "selected";
	/** Session */
	public static final String SESSION = "session";
	/** Expire */
	public static final String SESSION_EXPIRE = "session.expire";
	/** Expire all */
	public static final String SESSION_EXPIRE_ALL = "session.expireAll";
	/** Sessions */
	public static final String SESSIONS = "sessions";
	/** Site */
	public static final String SITE = "site";
	/** Alias "{0}" has been deleted. */
	public static final String SITE_ALIAS_DELETED = "site.alias.deleted";
	/** Configure applications */
	public static final String SITE_CONFIGURE_APPLICATIONS = "site.configure.applications";
	/** Create site */
	public static final String SITE_CREATE = "site.create";
	/** Failed to create the site. */
	public static final String SITE_CREATE_ERROR = "site.create.error";
	/** Create folder for JSP-contents */
	public static final String SITE_CREATE_REPOSITORY = "site.createRepository";
	/** Site has been created. */
	public static final String SITE_CREATED = "site.created";
	/** The current site "{0}" can not be deleted. */
	public static final String SITE_CURRENT_DELETE_ERROR = "site.current.delete.error";
	/** Delete site */
	public static final String SITE_DELETE = "site.delete";
	/** Do you really want to delete the site "{0}"? */
	public static final String SITE_DELETE_CONFIRM = "site.delete.confirm";
	/** Failed to delete the site. */
	public static final String SITE_DELETE_ERROR = "site.delete.error";
	/** Site has been deleted. */
	public static final String SITE_DELETED = "site.deleted";
	/** A different site with this domain already exists! */
	public static final String SITE_DOMAIN_EXISTS = "site.domain.exists";
	/** Site {0} */
	public static final String SITE_EDIT = "site.edit";
	/** Grant access to sites */
	public static final String SITE_GRANT = "site.grant";
	/** A different site with this host already exists! */
	public static final String SITE_HOST_EXISTS = "site.host.exists";
	/** A different site with this name already exists! */
	public static final String SITE_NAME_EXISTS = "site.name.exists";
	/** Site does not exist. */
	public static final String SITE_NOT_EXISTS = "site.not.exists";
	/** Site properties */
	public static final String SITE_PROPERTIES = "site.properties";
	/** Reload site */
	public static final String SITE_RELOAD = "site.reload";
	/** Site has been reloaded. */
	public static final String SITE_RELOADED = "site.reloaded";
	/** Failed to reload the site. */
	public static final String SITE_RELOADED_ERROR = "site.reloaded.error";
	/** Select site */
	public static final String SITE_SELECT = "site.select";
	/** Failed to update the site. */
	public static final String SITE_UPDATE_ERROR = "site.update.error";
	/** Site has been updated. */
	public static final String SITE_UPDATED = "site.updated";
	/** Site Status */
	public static final String SITE_STATE = "siteState";
	/** Sites */
	public static final String SITES = "sites";
	/** Size */
	public static final String SIZE = "size";
	/** Size (MB) */
	public static final String SIZE_MB = "sizeMB";
	/** SQL Statement */
	public static final String SQL_STATEMENT = "sqlStatement";
	/** Startup time */
	public static final String STARTUP_TIME = "startupTime";
	/** Status */
	public static final String STATUS = "status";
	/** Subject */
	public static final String SUBJECT = "subject";
	/** Create user */
	public static final String SUBJECT_CREATE = "subject.create";
	/** Failed to create the user. */
	public static final String SUBJECT_CREATE_ERROR = "subject.create.error";
	/** User has been created. */
	public static final String SUBJECT_CREATED = "subject.created";
	/** Delete user */
	public static final String SUBJECT_DELETE = "subject.delete";
	/** Do you really want to delete the user "{0}"? */
	public static final String SUBJECT_DELETE_CONFIRM = "subject.delete.confirm";
	/** Failed to delete the user. */
	public static final String SUBJECT_DELETE_ERROR = "subject.delete.error";
	/** User has been deleted. */
	public static final String SUBJECT_DELETED = "subject.deleted";
	/** Edit user */
	public static final String SUBJECT_EDIT = "subject.edit";
	/** Please enter an e-mail address. */
	public static final String SUBJECT_ENTER_EMAIL = "subject.enter.email";
	/** Please enter the password. */
	public static final String SUBJECT_ENTER_PASSWORD = "subject.enter.password";
	/** Please confirm the password. */
	public static final String SUBJECT_ENTER_PASSWORD_CONFIRMATION = "subject.enter.passwordConfirmation";
	/** Another user with this username already exists. */
	public static final String SUBJECT_EXISTS = "subject.exists";
	/** User does not exist. */
	public static final String SUBJECT_NOT_EXISTS = "subject.not.exists";
	/** Failed to update the password. */
	public static final String SUBJECT_PASSWORD_UPDATE_ERROR = "subject.password.update.error";
	/** Password has been updated. */
	public static final String SUBJECT_PASSWORD_UPDATED = "subject.password.updated";
	/** Password and password-confirmation do not match! */
	public static final String SUBJECT_PASSWORDS_NO_MATCH = "subject.passwords.no.match";
	/** Failed to update the user. */
	public static final String SUBJECT_UPDATE_ERROR = "subject.update.error";
	/** User has been updated. */
	public static final String SUBJECT_UPDATED = "subject.updated";
	/** Users */
	public static final String SUBJECTS = "subjects";
	/** System */
	public static final String SYSTEM = "system";
	/** System Environment */
	public static final String SYSTEM_ENVIRONMENT = "systemEnvironment";
	/** System Properties */
	public static final String SYSTEM_PROPERTIES = "systemProperties";
	/** System Report */
	public static final String SYSTEM_REPORT = "systemReport";
	/** Template */
	public static final String TEMPLATE = "template";
	/** Do your really want to delete the template "{0}"? */
	public static final String TEMPLATE_DELETE_CONFIRM = "template.delete.confirm";
	/** No such template: "{0}" */
	public static final String TEMPLATE_DELETE_STATUS____1 = "template.delete.status.-1";
	/** Template "{0}" is in use an can not be deleted. */
	public static final String TEMPLATE_DELETE_STATUS____2 = "template.delete.status.-2";
	/** Template "{0}" has been deleted. */
	public static final String TEMPLATE_DELETE_STATUS_0 = "template.delete.status.0";
	/** Templates */
	public static final String TEMPLATES = "templates";
	/** Test */
	public static final String TEST = "test";
	/** Threads */
	public static final String THREADS = "threads";
	/** Timeout */
	public static final String TIMEOUT = "timeout";
	/** Timestamp */
	public static final String TIMESTAMP = "timestamp";
	/** Timezone */
	public static final String TIMEZONE = "timezone";
	/** Type */
	public static final String TYPE = "type";
	/** URI */
	public static final String URI = "uri";
	/** User */
	public static final String USER = "user";
	/** Logged in users only? */
	public static final String USER_LOGGED_IN = "user.loggedIn";
	/** User Agent */
	public static final String USER_AGENT = "userAgent";
	/** <none> */
	public static final String USER_AGENT_NONE = "userAgent.none";
	/** User-Name */
	public static final String USER_NAME = "userName";
	/** Validation query */
	public static final String VALIDATION_QUERY = "validationQuery";
	/** Value */
	public static final String VALUE = "value";
	/** Vendor */
	public static final String VENDOR = "vendor";
	/** Version */
	public static final String VERSION = "version";
	/** View */
	public static final String VIEW = "view";

}