package org.appng.application.manager;

/** Property constants for appNG Manager 1.14.0 */
public class ManagerSettings {

	/** the name of the network interface who's first assigned IP address is used as system property appng.node.id in case it was not set an JVM startup */
	public static final String CLUSTER_INTERFACE_NAME = "clusterInterfaceName";
	/** a semicolon separted list of receviers for DatabaseReportJob, additional to all users with role 'Database report receiver' */
	public static final String DATABASE_REPORT_RECEIVERS = "databaseReportReceivers";
	/** the sender for the database report email */
	public static final String DATABASE_REPORT_SENDER = "databaseReportSender";
	/** the subject for the database report email */
	public static final String DATABASE_REPORT_SUBJECT = "databaseReportSubject";
	/** the text for the database report email */
	public static final String DATABASE_REPORT_TEXT = "databaseReportText";
	/** a semicolon separted list of receviers for PlatformEventReportJob, additional to all users with role 'Event report receiver' */
	public static final String EVENT_REPORT_RECEIVERS = "eventReportReceivers";
	/** the sender for the event report email */
	public static final String EVENT_REPORT_SENDER = "eventReportSender";
	/** the subject for the event report email */
	public static final String EVENT_REPORT_SUBJECT = "eventReportSubject";
	/** the text for the event report email */
	public static final String EVENT_REPORT_TEXT = "eventReportText";
	/** the event types to be included in the even report email (CREATE, UPDATE, DELETE, INFO, ERROR, WARN) */
	public static final String EVENT_REPORT_TYPES = "eventReportTypes";

}