/*
 * Decompiled with CFR 0.152.
 */
package org.appng.application.manager.soap.endpoint;

import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.appng.api.BusinessException;
import org.appng.api.Environment;
import org.appng.api.FieldProcessor;
import org.appng.api.SoapService;
import org.appng.api.model.Application;
import org.appng.api.model.Site;
import org.appng.api.support.FieldProcessorImpl;
import org.appng.core.domain.PackageArchiveImpl;
import org.appng.core.model.PackageArchive;
import org.appng.core.model.RepositoryUtils;
import org.appng.core.xml.repository.GetPackageRequest;
import org.appng.core.xml.repository.GetPackageResponse;
import org.appng.core.xml.repository.GetPackageVersionsRequest;
import org.appng.core.xml.repository.GetPackageVersionsResponse;
import org.appng.core.xml.repository.GetPackagesRequest;
import org.appng.core.xml.repository.GetPackagesResponse;
import org.appng.core.xml.repository.PackageVersions;
import org.appng.core.xml.repository.Packages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;
import org.springframework.ws.server.endpoint.annotation.Endpoint;
import org.springframework.ws.server.endpoint.annotation.PayloadRoot;
import org.springframework.ws.server.endpoint.annotation.RequestPayload;
import org.springframework.ws.server.endpoint.annotation.ResponsePayload;

@Endpoint
@Scope(value="request")
@Service
public class RepositoryService
implements SoapService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RepositoryService.class);
    private static final String SCHEMA_LOCATION = "appng-repository.xsd";
    private static final String REPOSITORY = "repository";
    private static final String NAMESPACE = "http://www.appng.org/schema/repository";
    private static final String GET_PACKAGES = "getPackagesRequest";
    private static final String GET_PACKAGE_VERSIONS = "getPackageVersionsRequest";
    private static final String GET_PACKAGE = "getPackageRequest";
    @Autowired
    private org.appng.application.manager.service.Service service;

    @PayloadRoot(localPart="getPackagesRequest", namespace="http://www.appng.org/schema/repository")
    @ResponsePayload
    public GetPackagesResponse getPackages(@RequestPayload GetPackagesRequest request) throws BusinessException {
        String repositoryName = request.getRepositoryName();
        try {
            GetPackagesResponse response = new GetPackagesResponse();
            FieldProcessorImpl fp = new FieldProcessorImpl(REPOSITORY);
            Packages packages = this.service.searchPackages((FieldProcessor)fp, repositoryName, request.getDigest());
            response.setPackages(packages);
            return response;
        }
        catch (BusinessException e) {
            LOGGER.error("error while retrieving packages from repository: " + repositoryName, (Throwable)e);
            throw e;
        }
    }

    @PayloadRoot(localPart="getPackageVersionsRequest", namespace="http://www.appng.org/schema/repository")
    @ResponsePayload
    public GetPackageVersionsResponse getPackageVersions(@RequestPayload GetPackageVersionsRequest request) throws BusinessException {
        String repositoryName = request.getRepositoryName();
        String packageName = request.getPackageName();
        try {
            GetPackageVersionsResponse response = new GetPackageVersionsResponse();
            FieldProcessorImpl fp = new FieldProcessorImpl(REPOSITORY);
            PackageVersions packageVersions = this.service.searchPackageVersions((FieldProcessor)fp, repositoryName, packageName, request.getDigest());
            response.setPackageVersions(packageVersions);
            return response;
        }
        catch (BusinessException e) {
            LOGGER.error("error while retrieving package versions from repository: " + repositoryName + ", package: " + packageName, (Throwable)e);
            throw e;
        }
    }

    @PayloadRoot(localPart="getPackageRequest", namespace="http://www.appng.org/schema/repository")
    @ResponsePayload
    public GetPackageResponse getPackage(@RequestPayload GetPackageRequest request) throws BusinessException {
        String repositoryName = request.getRepositoryName();
        String packageName = request.getPackageName();
        String version = request.getPackageVersion();
        String timestamp = request.getPackageTimestamp();
        try {
            PackageArchive archive = this.service.getPackageArchive(repositoryName, packageName, version, timestamp, request.getDigest());
            try {
                if (StringUtils.isBlank((CharSequence)timestamp)) {
                    timestamp = archive.getPackageInfo().getTimestamp();
                }
                GetPackageResponse response = new GetPackageResponse();
                response.setChecksum(archive.getChecksum());
                response.setData(archive.getBytes());
                response.setFileName(PackageArchiveImpl.getFileName((String)packageName, (String)version, (String)timestamp));
                return response;
            }
            catch (IOException e) {
                throw new BusinessException("error getting bytes from " + archive, (Throwable)e);
            }
        }
        catch (BusinessException e) {
            LOGGER.error("error while retrieving package archive from remote repository: " + repositoryName + ", package: " + packageName + ", version: " + version + ", timestamp: " + timestamp, (Throwable)e);
            throw e;
        }
    }

    public String getContextPath() {
        return RepositoryUtils.getContextPath();
    }

    public String getSchemaLocation() {
        return SCHEMA_LOCATION;
    }

    public void setApplication(Application application) {
    }

    public void setSite(Site site) {
    }

    public void setEnvironment(Environment environment) {
    }

    public org.appng.application.manager.service.Service getService() {
        return this.service;
    }

    public void setService(org.appng.application.manager.service.Service service) {
        this.service = service;
    }
}

