/*
 * Decompiled with CFR 0.152.
 */
package org.appng.application.manager.service;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.appng.application.manager.business.PlatformEvents;
import org.appng.core.domain.PlatformEvent;
import org.appng.core.repository.PlatformEventRepository;
import org.appng.persistence.repository.SearchQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class PlatformEventService {
    PlatformEventRepository platformEventRepository;

    @Autowired
    public PlatformEventService(PlatformEventRepository platformEventRepository) {
        this.platformEventRepository = platformEventRepository;
    }

    public Page<PlatformEvent> getEvents(Pageable pageable, PlatformEvents.EventFilter eventFilter) {
        SearchQuery query = this.platformEventRepository.createSearchQuery();
        query.greaterEquals("created", (Object)eventFilter.getEA());
        query.lessEquals("created", (Object)eventFilter.getEB());
        query.equals("origin", (Object)StringUtils.trimToNull((String)eventFilter.getEH()));
        query.equals("hostName", (Object)StringUtils.trimToNull((String)eventFilter.getEN()));
        query.equals("user", (Object)StringUtils.trimToNull((String)eventFilter.getEU()));
        query.equals("application", (Object)StringUtils.trimToNull((String)eventFilter.getEAp()));
        query.in("type", eventFilter.eventTypes());
        query.contains("event", (Object)StringUtils.trimToNull((String)eventFilter.getEX()));
        return this.platformEventRepository.search(query, pageable);
    }

    public List<PlatformEvent> getEvents(PlatformEvents.EventFilter eventFilter) {
        return this.getEvents((Pageable)new PageRequest(0, Integer.MAX_VALUE), eventFilter).getContent();
    }

    public List<String> getUsers() {
        return this.platformEventRepository.findDistinctUsers();
    }

    public List<String> getApplications() {
        return this.platformEventRepository.findDistinctApplications();
    }

    public List<String> getHostNames() {
        return this.platformEventRepository.findDistinctHostNames();
    }

    public List<String> getOrigins() {
        return this.platformEventRepository.findDistinctOrigins();
    }
}

