/*
 * Decompiled with CFR 0.152.
 */
package org.appng.application.manager.service;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections.comparators.ComparatorChain;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.appng.api.ApplicationException;
import org.appng.api.BusinessException;
import org.appng.api.DataContainer;
import org.appng.api.Environment;
import org.appng.api.FieldProcessor;
import org.appng.api.InvalidConfigurationException;
import org.appng.api.Request;
import org.appng.api.RequestUtil;
import org.appng.api.Scope;
import org.appng.api.model.Application;
import org.appng.api.model.Group;
import org.appng.api.model.Identifier;
import org.appng.api.model.NameProvider;
import org.appng.api.model.Nameable;
import org.appng.api.model.Permission;
import org.appng.api.model.Properties;
import org.appng.api.model.Resource;
import org.appng.api.model.ResourceType;
import org.appng.api.model.Resources;
import org.appng.api.model.Role;
import org.appng.api.model.Site;
import org.appng.api.model.Subject;
import org.appng.api.model.UserType;
import org.appng.api.support.OptionGroupFactory;
import org.appng.api.support.OptionOwner;
import org.appng.api.support.SelectionFactory;
import org.appng.application.manager.form.GroupForm;
import org.appng.application.manager.form.PropertyForm;
import org.appng.application.manager.form.RepositoryForm;
import org.appng.application.manager.form.ResourceForm;
import org.appng.application.manager.form.RoleForm;
import org.appng.application.manager.form.SiteForm;
import org.appng.application.manager.form.SubjectForm;
import org.appng.application.manager.form.UploadForm;
import org.appng.application.manager.service.Service;
import org.appng.core.controller.AppngCache;
import org.appng.core.domain.ApplicationImpl;
import org.appng.core.domain.DatabaseConnection;
import org.appng.core.domain.GroupImpl;
import org.appng.core.domain.PermissionImpl;
import org.appng.core.domain.PlatformEvent;
import org.appng.core.domain.PropertyImpl;
import org.appng.core.domain.RepositoryImpl;
import org.appng.core.domain.ResourceImpl;
import org.appng.core.domain.RoleImpl;
import org.appng.core.domain.SiteApplication;
import org.appng.core.domain.SiteApplicationPK;
import org.appng.core.domain.SiteImpl;
import org.appng.core.domain.SubjectImpl;
import org.appng.core.model.JarInfo;
import org.appng.core.model.PackageArchive;
import org.appng.core.model.Repository;
import org.appng.core.model.RepositoryCacheFactory;
import org.appng.core.model.RepositoryMode;
import org.appng.core.model.RepositoryType;
import org.appng.core.model.RepositoryUtils;
import org.appng.core.service.CoreService;
import org.appng.core.service.InitializerService;
import org.appng.core.service.MigrationService;
import org.appng.core.service.PropertySupport;
import org.appng.core.xml.repository.PackageVersions;
import org.appng.core.xml.repository.Packages;
import org.appng.forms.FormUpload;
import org.appng.persistence.repository.SearchQuery;
import org.appng.xml.application.PackageInfo;
import org.appng.xml.platform.Label;
import org.appng.xml.platform.Option;
import org.appng.xml.platform.OptionGroup;
import org.appng.xml.platform.Selection;
import org.appng.xml.platform.SelectionGroup;
import org.appng.xml.platform.SelectionType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.support.PropertyComparator;
import org.springframework.context.MessageSource;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={BusinessException.class})
public class ManagerService
extends CoreService
implements Service {
    private Logger logger = LoggerFactory.getLogger(ManagerService.class);
    @Autowired
    private Request request;
    @Autowired
    private Environment environment;
    @Autowired
    private SelectionFactory selectionFactory;
    @Autowired
    private OptionGroupFactory optionGroupFactory;
    private MessageSource timezoneMessages;

    @Override
    public void deleteSubject(Subject currentSubject, Integer subjectId, FieldProcessor fp) throws BusinessException {
        try {
            if (((Integer)currentSubject.getId()).equals(subjectId)) {
                throw new BusinessException("can not delete currently used subject!");
            }
            SubjectImpl subject = (SubjectImpl)this.subjectRepository.findOne((Serializable)subjectId);
            if (null == subject) {
                throw new BusinessException("No such subject " + subjectId, "subject.not.exists", new Object[0]);
            }
            this.subjectRepository.delete((Object)subject);
        }
        catch (Exception e) {
            this.getRequest().handleException(fp, e);
        }
    }

    @Override
    public void deletePermission(Integer permissionId, FieldProcessor fp) throws BusinessException {
        try {
            PermissionImpl permission = (PermissionImpl)this.permissionRepository.findOne((Serializable)permissionId);
            if (null != permission) {
                ApplicationImpl application = permission.getApplication();
                if (application.getPermissions().remove(permission)) {
                    this.logger.debug("removed permission '" + permission.getName() + "' from Application " + application.getName());
                }
                for (Role role : application.getRoles()) {
                    if (!role.getPermissions().remove(permission)) continue;
                    this.logger.debug("removed permission '" + permission.getName() + "' from Role " + role.getName());
                }
            } else {
                throw new BusinessException("No such permission " + permissionId, "permission.not.exists", new Object[0]);
            }
            this.permissionRepository.delete((Object)permission);
        }
        catch (Exception e) {
            this.getRequest().handleException(fp, e);
        }
    }

    @Override
    public void deleteRole(Integer roleId) throws BusinessException {
        String roleDeleteError = "role.delete.error";
        String roleErrorInvalid = "role.not.exists";
        this.deleteRole(roleId, roleDeleteError, roleErrorInvalid);
    }

    @Override
    public void deleteApplication(Integer appId, FieldProcessor fp) throws BusinessException {
        String deleteErrorWithCause = "application.delete.error.with.cause";
        String removedFromSite = "application.removed.from.site";
        String errorInvalid = "application.notExists";
        String roleDeleteError = "role.delete.error";
        String roleErrorInvalid = "role.not.exists";
        this.deleteApplication(this.environment, this.request, appId, fp, deleteErrorWithCause, removedFromSite, errorInvalid, roleDeleteError, roleErrorInvalid);
    }

    @Override
    public void deleteRepository(Integer repositoryId, FieldProcessor fp) throws BusinessException {
        try {
            RepositoryImpl repository = (RepositoryImpl)this.repoRepository.findOne((Serializable)repositoryId);
            if (null == repository) {
                throw new BusinessException("no such repository " + repositoryId, "repository.not.exists", new Object[0]);
            }
            this.repoRepository.delete((Object)repository);
        }
        catch (Exception e) {
            this.getRequest().handleException(fp, e);
        }
    }

    @Override
    public String deleteResource(Integer applicationId, Integer resourceId, FieldProcessor fp) throws BusinessException {
        try {
            if (null != applicationId) {
                String resourceName = this.deleteResource(this.request.getEnvironment(), applicationId, resourceId);
                String message = this.request.getMessage("resource.deleted", new Object[]{resourceName});
                fp.addOkMessage(message);
                return resourceName;
            }
        }
        catch (Exception e) {
            this.getRequest().handleException(fp, e);
        }
        return null;
    }

    @Override
    public void deleteSite(String host, Integer siteId, FieldProcessor fp, Site currentSite) throws BusinessException {
        try {
            SiteImpl site = (SiteImpl)this.siteRepository.findOne((Serializable)siteId);
            if (null != site) {
                if (site.equals((Object)currentSite) || site.getHost().equals(host)) {
                    throw new BusinessException("Can not delete current site " + site.getName(), "site.current.delete.error", new Object[]{site.getName()});
                }
            } else {
                throw new BusinessException("No such site " + siteId, "site.not.exists", new Object[0]);
            }
            this.deleteSite(this.request.getEnvironment(), site);
        }
        catch (Exception e) {
            this.getRequest().handleException(fp, e);
        }
    }

    @Override
    public void deleteGroup(Integer id, FieldProcessor fp) throws BusinessException {
        try {
            GroupImpl group = (GroupImpl)this.groupRepository.findOne((Serializable)id);
            if (null == group) {
                throw new BusinessException("No such group " + id);
            }
            this.deleteGroup(group);
        }
        catch (Exception e) {
            this.getRequest().handleException(fp, e);
        }
    }

    @Override
    public void createGroup(GroupForm groupForm, Site site, FieldProcessor fp) throws BusinessException {
        GroupImpl group = groupForm.getGroup();
        this.checkUniqueGroupName((Group)group, fp);
        this.groupRepository.save((Object)group);
        this.assignRolesToGroup((Group)group, site, groupForm.getRoleIds());
    }

    @Override
    public void updateGroup(Site site, GroupForm form, FieldProcessor fp) throws BusinessException {
        GroupImpl group = form.getGroup();
        this.checkUniqueGroupName((Group)group, fp);
        GroupImpl currentGroup = (GroupImpl)this.groupRepository.findOne((Serializable)group.getId());
        if (null == currentGroup) {
            throw new BusinessException("no such group");
        }
        this.getRequest().setPropertyValues((Object)form, (Object)new GroupForm(currentGroup), fp.getMetaData());
        this.assignRolesToGroup((Group)currentGroup, site, form.getRoleIds());
    }

    private void checkUniqueGroupName(Group group, FieldProcessor fp) throws BusinessException {
        boolean isUnique = this.groupRepository.isUnique(group.getId(), "name", (Object)group.getName());
        if (!isUnique) {
            fp.addErrorMessage(fp.getField("group.name"), this.request.getMessage("group.exists", new Object[0]));
            throw new BusinessException("group named " + group.getName() + " already exists!");
        }
    }

    @Override
    public DataContainer searchGroups(FieldProcessor fp, Site site, Integer siteId, Integer groupId) throws BusinessException {
        DataContainer data = new DataContainer(fp);
        if (groupId != null) {
            GroupImpl group = (GroupImpl)this.groupRepository.findOne((Serializable)groupId);
            if (null == group) {
                throw new BusinessException("no such group : " + groupId, "group.not.exists", new Object[0]);
            }
            Selection selection = this.getRoleSelection((Group)group, (Integer)site.getId());
            data.getSelections().add(selection);
            data.setItem((Object)new GroupForm(group));
        } else {
            Page groups = this.groupRepository.search(fp.getPageable());
            data.setPage(groups);
        }
        return data;
    }

    private Selection getRoleSelection(Group group, Integer siteId) {
        SiteImpl site = (SiteImpl)this.siteRepository.findOne((Serializable)siteId);
        Selection selection = (Selection)this.selectionFactory.fromObjects("roles", "roles", new Object[0], (OptionOwner.Selector)null);
        for (Application application : this.sortByName(new ArrayList(site.getApplications()))) {
            String name = application.getName();
            ArrayList roles = new ArrayList(application.getRoles());
            OptionGroupFactory.OptionGroup roleGroup = (OptionGroupFactory.OptionGroup)this.optionGroupFactory.fromNamed(name, name, this.sortByName(roles), (Collection)group.getRoles());
            selection.getOptionGroups().add(roleGroup);
        }
        selection.setType(SelectionType.SELECT_MULTIPLE);
        return selection;
    }

    private <T extends Nameable> List<T> sortByName(List<T> items) {
        Comparator<Nameable> nameComparator = new Comparator<Nameable>(){

            @Override
            public int compare(Nameable n1, Nameable n2) {
                return n1.getName().compareTo(n2.getName());
            }
        };
        Collections.sort(items, nameComparator);
        return items;
    }

    @Override
    public DataContainer searchRepositories(FieldProcessor fp, Integer repositoryId) {
        DataContainer data = new DataContainer(fp);
        if (repositoryId == null) {
            Page repositories = this.repoRepository.search(fp.getPageable());
            data.setPage(repositories);
        } else {
            Selection repositoryModeSelection;
            RepositoryImpl repository = (RepositoryImpl)this.repoRepository.findOne((Serializable)repositoryId);
            data.setItem((Object)new RepositoryForm(repository));
            Selection repositoryTypeSelection = this.getRepositoryTypeSelection(repository.getRepositoryType());
            if (null != repositoryTypeSelection) {
                data.getSelections().add(repositoryTypeSelection);
            }
            if (null != (repositoryModeSelection = this.getRepositoryModeSelection(repository.getRepositoryMode()))) {
                data.getSelections().add(repositoryModeSelection);
            }
        }
        return data;
    }

    @Override
    public DataContainer searchInstallablePackages(FieldProcessor fp, Integer repositoryId) throws BusinessException {
        DataContainer data = new DataContainer(fp);
        if (null != repositoryId) {
            RepositoryImpl repository = (RepositoryImpl)this.repoRepository.findOne((Serializable)repositoryId);
            try {
                if (null != repository) {
                    Page applications = this.applicationRepository.search(fp.getPageable());
                    ArrayList<Identifier> identifiers = new ArrayList<Identifier>(applications.getContent());
                    List<Identifier> templates = this.getInstalledTemplates();
                    identifiers.addAll(templates);
                    List packages = repository.getInstallablePackages(identifiers);
                    data.setPage((Collection)packages, fp.getPageable());
                }
            }
            catch (Exception e) {
                this.handleRepositoryException(fp, (Repository)repository, e);
            }
        }
        return data;
    }

    protected void handleRepositoryException(FieldProcessor fp, Repository repository, Exception e) throws BusinessException {
        Throwable handled = e;
        if (!(e instanceof BusinessException)) {
            handled = new BusinessException(null, (Throwable)e, "repository.error", new Object[]{repository.getName(), repository.getUri()});
        }
        this.request.handleException(fp, (Exception)handled);
    }

    @Override
    public DataContainer searchPackageVersions(FieldProcessor fp, Integer repositoryId, String packageName) throws BusinessException {
        DataContainer data = new DataContainer(fp);
        try {
            RepositoryImpl repository;
            if (null != repositoryId && StringUtils.isNotBlank((CharSequence)packageName) && null != (repository = (RepositoryImpl)this.repoRepository.findOne((Serializable)repositoryId))) {
                ArrayList<Identifier> packages = new ArrayList<Identifier>(this.applicationRepository.findAll());
                List<Identifier> templates = this.getInstalledTemplates();
                packages.addAll(templates);
                List packageVersions = repository.getPackageVersions(packages, packageName);
                Collections.reverse(packageVersions);
                data.setPage((Collection)packageVersions, fp.getPageable());
            }
        }
        catch (Exception e) {
            this.request.handleException(fp, e);
        }
        return data;
    }

    @Override
    public Packages searchPackages(FieldProcessor fp, String repositoryName, String digest) throws BusinessException {
        try {
            Repository repository = this.getRepository(repositoryName, digest);
            return repository.getPackages();
        }
        catch (Exception e) {
            this.request.handleException(fp, e);
            return null;
        }
    }

    @Override
    public PackageVersions searchPackageVersions(FieldProcessor fp, String repositoryName, String packageName, String digest) throws BusinessException {
        try {
            Repository repository = this.getRepository(repositoryName, digest);
            return repository.getPackageVersions(packageName);
        }
        catch (Exception e) {
            this.request.handleException(fp, e);
            return null;
        }
    }

    @Override
    public PackageArchive getPackageArchive(String repositoryName, String name, String version, String timestamp, String digest) throws BusinessException {
        Repository repository = this.getRepository(repositoryName, digest);
        return repository.getPackageArchive(name, version, timestamp);
    }

    private Repository getRepository(String repositoryName, String digest) throws BusinessException {
        RepositoryImpl repository;
        if (StringUtils.isNotBlank((CharSequence)repositoryName) && null != (repository = this.repoRepository.findByName(repositoryName)) && repository.isPublished()) {
            boolean digestOk = false;
            if (StringUtils.isBlank((CharSequence)repository.getDigest())) {
                String defaultDigest = this.getPlatformConfig().getString("repositoryDefaultDigest");
                digestOk = StringUtils.equals((CharSequence)StringUtils.trimToEmpty((String)defaultDigest), (CharSequence)StringUtils.trimToEmpty((String)digest));
            } else {
                digestOk = StringUtils.equals((CharSequence)repository.getDigest(), (CharSequence)digest);
            }
            if (digestOk) {
                return repository;
            }
        }
        throw new BusinessException("Repository not found or repository is not published: " + repositoryName);
    }

    protected Properties getPlatformConfig() {
        return (Properties)this.environment.getAttribute(Scope.PLATFORM, "platformConfig");
    }

    @Override
    public void installPackage(Integer repositoryId, String name, String version, String timestamp, FieldProcessor fp) throws BusinessException {
        try {
            Boolean isFilebased = this.getPlatformConfig().getBoolean("filebasedDeployment");
            PackageVersions packageVersions = this.getRepository(repositoryId).getPackageVersions(name);
            List versions = packageVersions.getPackage().stream().filter(p -> p.getVersion().equals(version) && p.getTimestamp().equals(timestamp)).limit(1L).collect(Collectors.toList());
            String appngVer = (String)this.environment.getAttribute(Scope.PLATFORM, "appNGVersion");
            String pkAppngVer = ((PackageInfo)versions.get(0)).getAppngVersion();
            if (pkAppngVer.compareTo(appngVer) > 0) {
                String versionMismatch = this.request.getMessage("package.appNGVersionMismatch", new Object[]{pkAppngVer, appngVer});
                fp.addNoticeMessage(versionMismatch);
            }
            this.installPackage(repositoryId, name, version, timestamp, false, false, isFilebased);
        }
        catch (Exception e) {
            this.getRequest().handleException(fp, e);
        }
    }

    @Override
    public void deletePackageVersion(Integer repositoryId, String packageName, String packageVersion, String packageTimestamp, FieldProcessor fp) throws BusinessException {
        try {
            this.deletePackageVersion(repositoryId, packageName, packageVersion, packageTimestamp);
        }
        catch (Exception e) {
            this.getRequest().handleException(fp, e);
        }
    }

    @Override
    public DataContainer searchResources(Site site, FieldProcessor fp, ResourceType type, Integer resourceId, Integer applicationId) throws BusinessException {
        DataContainer data = new DataContainer(fp);
        Application application = (Application)this.applicationRepository.findOne((Serializable)applicationId);
        try {
            File appRootFolder = this.getApplicationRootFolder(this.environment);
            Resources resourceHolder = this.getResources(application, null, appRootFolder);
            if (null == resourceId) {
                boolean isAsc = true;
                ComparatorChain comparatorChain = new ComparatorChain();
                comparatorChain.addComparator((Comparator)new PropertyComparator("resourceType", true, isAsc));
                comparatorChain.addComparator((Comparator)new PropertyComparator("name", true, isAsc));
                ArrayList resources = null;
                resources = null == type ? new ArrayList(resourceHolder.getResources()) : new ArrayList(resourceHolder.getResources(type));
                Collections.sort(resources, comparatorChain);
                data.setPage(resources, fp.getPageable());
                Selection typeSelection = (Selection)this.selectionFactory.fromEnum("resourceType", "type", (Enum[])ResourceType.values(), (Enum)type);
                typeSelection.getOptions().add(0, new Option());
                SelectionGroup selectionGroup = new SelectionGroup();
                data.getSelectionGroups().add(selectionGroup);
                selectionGroup.getSelections().add(typeSelection);
            } else {
                Resource resource = resourceHolder.getResource(resourceId);
                data.setItem((Object)new ResourceForm(resource));
            }
        }
        catch (InvalidConfigurationException e) {
            this.request.handleException(fp, (Exception)((Object)e));
        }
        return data;
    }

    @Override
    public String updateResource(Site site, Integer appId, ResourceForm form, FieldProcessor fp) throws BusinessException {
        String errorMessage = null;
        String okMessage = null;
        try {
            Integer id = form.getId();
            Application application = (Application)this.applicationRepository.findOne((Serializable)appId);
            boolean fileBased = application.isFileBased();
            String reloadMessage = this.request.getMessage("reloadSite", new Object[0]);
            File appRootFolder = this.getApplicationRootFolder(this.environment);
            Resources resourceHolder = this.getResources(application, null, appRootFolder);
            Resource resource = resourceHolder.getResource(id);
            String fileName = resource.getName();
            ResourceType type = resource.getResourceType();
            if (fileBased) {
                errorMessage = this.request.getMessage("resource.updated.filebased.error", new Object[]{fileName});
                File resourceFolder = this.getResourceFolder(application.getName(), type);
                File original = new File(resourceFolder, fileName);
                FileUtils.write((File)original, (CharSequence)form.getContent(), (String)"UTF-8", (boolean)false);
                okMessage = this.request.getMessage("resource.updated.filebased", new Object[]{fileName, FileUtils.sizeOf((File)original)});
                this.createEvent(PlatformEvent.Type.UPDATE, String.format("Resource %s of Application %s", fileName, application.getName()));
            } else {
                errorMessage = this.request.getMessage("resource.updated.databased.error", new Object[]{fileName});
                ResourceImpl dbResource = (ResourceImpl)this.resourceRepository.findOne(resource.getId());
                dbResource.setBytes(form.getContent().getBytes());
                dbResource.calculateChecksum();
                okMessage = this.request.getMessage("resource.updated.databased", new Object[]{fileName, resource.getSize()});
            }
            fp.addNoticeMessage(reloadMessage);
            fp.addOkMessage(okMessage);
            return fileName;
        }
        catch (Exception e) {
            fp.addErrorMessage(errorMessage);
            this.request.handleException(fp, e);
            return null;
        }
    }

    private File getResourceFolder(String appName, ResourceType type) {
        File appFolder = this.getApplicationFolder(this.environment, appName);
        String typeFolder = type.getFolder();
        File resourceFolder = new File(appFolder, typeFolder);
        return resourceFolder;
    }

    @Override
    public void createResource(Site site, Integer appId, UploadForm form, FieldProcessor fp) throws BusinessException {
        Application application = (Application)this.applicationRepository.findOne((Serializable)appId);
        String okMessage = null;
        String errorMessage = null;
        try {
            ResourceType type = form.getType();
            FormUpload uploadFile = form.getFile();
            File file = uploadFile.getFile();
            String originalFilename = uploadFile.getOriginalFilename();
            okMessage = this.request.getMessage("resource.uploaded", new Object[]{originalFilename, FileUtils.sizeOf((File)file)});
            errorMessage = this.request.getMessage("resource.upload.error", new Object[]{originalFilename});
            if (type.isValidFileName(originalFilename)) {
                if (application.isFileBased()) {
                    File appFolder = this.getResourceFolder(application.getName(), type);
                    File targetFile = new File(appFolder, originalFilename);
                    if (targetFile.exists()) {
                        String overriddenMssg = this.request.getMessage("resource.overridden", new Object[]{originalFilename});
                        fp.addNoticeMessage(overriddenMssg);
                    }
                    FileUtils.copyFile((File)file, (File)targetFile);
                } else {
                    ResourceImpl resource = this.resourceRepository.findByNameAndApplicationId(originalFilename, appId);
                    if (null != resource) {
                        String overriddenMssg = this.request.getMessage("resource.overridden", new Object[]{originalFilename});
                        fp.addNoticeMessage(overriddenMssg);
                    } else {
                        resource = new ResourceImpl();
                    }
                    resource.setApplication(application);
                    resource.setBytes(uploadFile.getBytes());
                    resource.setName(originalFilename);
                    resource.setResourceType(type);
                    resource.setDescription("uploaded on " + new Date());
                    resource.calculateChecksum();
                    this.resourceRepository.save((Object)resource);
                }
                String reloadMessage = this.request.getMessage("reloadSite", new Object[0]);
                fp.addNoticeMessage(reloadMessage);
                fp.addOkMessage(okMessage);
            } else {
                String invalidTypeMessage = application.getMessage(this.environment.getLocale(), "resource.wrongType", new Object[]{type.toString(), StringUtils.join((Iterable)type.getAllowedFileEndings(), (String)",")});
                fp.addErrorMessage(invalidTypeMessage);
            }
        }
        catch (Exception e) {
            fp.addErrorMessage(errorMessage);
            this.request.handleException(fp, e);
        }
    }

    @Override
    public DataContainer searchRole(FieldProcessor fp, Integer roleId, Integer appId) throws BusinessException {
        DataContainer data = new DataContainer(fp);
        if (roleId != null) {
            RoleImpl role = (RoleImpl)this.roleRepository.findOne((Serializable)roleId);
            if (null == role) {
                throw new BusinessException("no such Role " + roleId, "role.not.exists", new Object[0]);
            }
            Selection selection = this.getPermissionSelection((Integer)role.getApplication().getId(), role);
            data.getSelections().add(selection);
            RoleForm form = new RoleForm(role);
            data.setItem((Object)form);
        } else {
            Page roles;
            if (null == appId) {
                roles = this.roleRepository.search(fp.getPageable());
            } else {
                SearchQuery query = new SearchQuery(RoleImpl.class).equals("application.id", (Object)appId);
                roles = this.roleRepository.search(query, fp.getPageable());
            }
            data.setPage(roles);
        }
        return data;
    }

    private Selection getPermissionSelection(Integer appId, RoleImpl role) {
        Set permissionsFromRole = role.getPermissions();
        List allPermissions = this.permissionRepository.findByApplicationId(appId, new Sort(Sort.Direction.ASC, new String[]{"name"}));
        HashMap permissionGroups = new HashMap();
        Pattern pattern = Pattern.compile("([^\\.]+)((.)*)");
        for (Permission permission : allPermissions) {
            Matcher matcher = pattern.matcher(permission.getName());
            if (!matcher.matches()) continue;
            String group = matcher.group(1);
            if (!permissionGroups.containsKey(group)) {
                permissionGroups.put(group, new ArrayList());
            }
            ((List)permissionGroups.get(group)).add(permission);
        }
        Selection permissionSelection = (Selection)this.selectionFactory.fromObjects("permissions", "permissions", new Object[0], (OptionOwner.Selector)null);
        ArrayList groupNames = new ArrayList(permissionGroups.keySet());
        Collections.sort(groupNames);
        for (String permissionGroup : groupNames) {
            List permissions = this.sortByName((List)permissionGroups.get(permissionGroup));
            if (permissions.size() > 1) {
                OptionGroupFactory.OptionGroup group = (OptionGroupFactory.OptionGroup)this.optionGroupFactory.fromNamed(permissionGroup, permissionGroup, permissions, (Collection)permissionsFromRole);
                permissionSelection.getOptionGroups().add(group);
                continue;
            }
            List options = ((SelectionFactory.Selection)this.selectionFactory.fromNamed(permissionGroup, permissionGroup, permissions, (Collection)permissionsFromRole)).getOptions();
            permissionSelection.getOptions().addAll(options);
        }
        permissionSelection.setType(SelectionType.SELECT_MULTIPLE);
        return permissionSelection;
    }

    @Override
    public void createRole(RoleForm roleForm, Integer appId, FieldProcessor fp) throws BusinessException {
        if (null == appId) {
            throw new BusinessException("no application id given", "role.create.error", new Object[0]);
        }
        RoleImpl role = roleForm.getRole();
        Application application = (Application)this.applicationRepository.findOne((Serializable)appId);
        role.setApplication(application);
        this.checkUniqueRoleName((Role)role, role.getName(), fp);
        this.roleRepository.save((Object)role);
        this.assignPermissionsToRole((Role)role, roleForm.getPermissionIds(), fp);
    }

    @Override
    public void updateRole(RoleForm form, FieldProcessor fp) throws BusinessException {
        RoleImpl role = form.getRole();
        RoleImpl currentRole = (RoleImpl)this.roleRepository.findOne((Serializable)role.getId());
        if (null == currentRole) {
            throw new BusinessException("no such role", "role.not.exists", new Object[0]);
        }
        this.checkUniqueRoleName((Role)currentRole, role.getName(), fp);
        this.getRequest().setPropertyValues((Object)form, (Object)new RoleForm(currentRole), fp.getMetaData());
        this.assignPermissionsToRole((Role)currentRole, form.getPermissionIds(), fp);
    }

    private void checkUniqueRoleName(Role role, String name, FieldProcessor fp) throws BusinessException {
        boolean isUnique = this.roleRepository.isUnique(role.getId(), new String[]{"name", "application.id"}, new Object[]{name, role.getApplication().getId()});
        if (!isUnique) {
            fp.addErrorMessage(fp.getField("role.name"), this.request.getMessage("role.exists", new Object[0]));
            throw new BusinessException("a role " + role.getName() + " already exists for application " + role.getApplication().getName());
        }
    }

    @Override
    public DataContainer searchApplications(FieldProcessor fp, Integer siteId, Integer appId, boolean assignedOnly) throws BusinessException {
        DataContainer data = new DataContainer(fp);
        if (null == siteId) {
            if (null == appId) {
                Page applications = this.applicationRepository.search(fp.getPageable());
                data.setPage(applications);
            } else {
                ApplicationImpl application = (ApplicationImpl)this.applicationRepository.findOne((Serializable)appId);
                if (null == application) {
                    throw new BusinessException("no such application: " + appId, "application.notExists", new Object[0]);
                }
                data.setItem((Object)application);
            }
        } else if (null == appId) {
            Pageable pageable = fp.getPageable();
            if (assignedOnly) {
                SearchQuery searchQuery = new SearchQuery(SiteApplication.class);
                searchQuery.equals("site.id", (Object)siteId);
                Page applications = this.siteApplicationRepository.search(searchQuery, pageable);
                data.setPage(applications);
            } else {
                Page allApplications = this.applicationRepository.search(pageable);
                ArrayList<SiteApplication> applications = new ArrayList<SiteApplication>();
                Site site = (Site)this.siteRepository.findOne((Serializable)siteId);
                for (Application application : allApplications) {
                    SiteApplication siteApplication = ((SiteImpl)site).getSiteApplication(application.getName());
                    if (siteApplication == null) {
                        siteApplication = new SiteApplication();
                        siteApplication.setApplication(application);
                        siteApplication.setActive(false);
                        siteApplication.setReloadRequired(false);
                        siteApplication.setMarkedForDeletion(false);
                    }
                    applications.add(siteApplication);
                }
                PageRequest currentPage = new PageRequest(allApplications.getNumber(), allApplications.getSize(), allApplications.getSort());
                PageImpl page = new PageImpl(applications, (Pageable)currentPage, allApplications.getTotalElements());
                data.setPage((Page)page);
            }
        }
        return data;
    }

    @Override
    public void createRepository(RepositoryImpl repository, FieldProcessor fp) throws BusinessException {
        try {
            this.validateRepository(repository, new RepositoryImpl(), fp);
            this.createRepository(repository);
        }
        catch (Exception e) {
            this.getRequest().handleException(fp, e);
        }
    }

    @Override
    public void reloadRepository(Integer repositoryId, FieldProcessor fp) throws BusinessException {
        this.reloadRepository(fp, (RepositoryImpl)this.repoRepository.findOne((Serializable)repositoryId));
    }

    protected void reloadRepository(FieldProcessor fp, RepositoryImpl repository) throws BusinessException {
        if (null != repository) {
            try {
                repository.reload();
            }
            catch (Exception e) {
                this.handleRepositoryException(fp, (Repository)repository, e);
            }
        }
    }

    @Override
    public void updateApplication(Environment env, Application application, FieldProcessor fp) throws BusinessException {
        try {
            ApplicationImpl currentApplication;
            if (application.getId() != null) {
                currentApplication = (ApplicationImpl)this.applicationRepository.findOne(application.getId());
                if (null == currentApplication) {
                    fp.addErrorMessage(this.request.getMessage("application.notExists", new Object[0]));
                    return;
                }
            } else {
                throw new BusinessException("No such application");
            }
            this.synchronizeApplicationResources(env, (Application)currentApplication, application.isFileBased());
            this.getRequest().setPropertyValues((Object)application, (Object)currentApplication, fp.getMetaData());
        }
        catch (Exception e) {
            this.getRequest().handleException(fp, e);
        }
    }

    @Override
    public void updateRepository(RepositoryForm repositoryForm, FieldProcessor fp) throws BusinessException {
        RepositoryImpl currentRepository = (RepositoryImpl)this.repoRepository.findOne((Serializable)repositoryForm.getRepository().getId());
        try {
            if (null == currentRepository) {
                throw new BusinessException("no such repository");
            }
            this.validateRepository(repositoryForm.getRepository(), currentRepository, fp);
            this.getRequest().setPropertyValues((Object)repositoryForm, (Object)new RepositoryForm(currentRepository), fp.getMetaData());
        }
        catch (Exception e) {
            this.getRequest().handleException(fp, e);
        }
        this.reloadRepository(fp, currentRepository);
    }

    private void validateRepository(RepositoryImpl repository, RepositoryImpl currentRepository, FieldProcessor fp) throws BusinessException {
        if (null == repository.getRepositoryType()) {
            if (null == currentRepository.getRepositoryType()) {
                repository.setRepositoryType(RepositoryType.getDefault());
            } else {
                repository.setRepositoryType(currentRepository.getRepositoryType());
            }
        }
        if (null == repository.getRepositoryMode()) {
            if (null == currentRepository.getRepositoryMode()) {
                repository.setRepositoryMode(RepositoryMode.getDefault());
            } else {
                repository.setRepositoryMode(currentRepository.getRepositoryMode());
            }
        }
        this.checkUniqueRepositoryName((Repository)repository, fp);
        try {
            RepositoryCacheFactory.validateRepositoryURI((Repository)repository);
        }
        catch (BusinessException e) {
            String message = e.getMessage();
            fp.addErrorMessage(message);
            throw e;
        }
    }

    private void checkUniqueRepositoryName(Repository repository, FieldProcessor fp) throws BusinessException {
        boolean isUnique = this.repoRepository.isUnique(repository.getId(), "name", (Object)repository.getName());
        if (!isUnique) {
            fp.addErrorMessage(fp.getField("repository.name"), this.request.getMessage("repository.exists", new Object[0]));
            throw new BusinessException("repository named " + repository.getName() + " already exists!");
        }
    }

    @Override
    public DataContainer searchSites(FieldProcessor fp, Integer siteId) throws BusinessException {
        DataContainer data = new DataContainer(fp);
        if (siteId != null) {
            SiteImpl site = (SiteImpl)this.siteRepository.findOne((Serializable)siteId);
            if (null == site) {
                throw new BusinessException("no such site: " + siteId, "site.not.exists", new Object[0]);
            }
            this.addSelectionsForSite(site, data);
            data.setItem((Object)new SiteForm(site));
        } else {
            Map siteMap = (Map)this.environment.getAttribute(Scope.PLATFORM, "sites");
            Page sites = this.siteRepository.search(fp.getPageable());
            for (SiteImpl siteImpl : sites) {
                Site site = (Site)siteMap.get(siteImpl.getName());
                if (null == site) continue;
                siteImpl.setRunning(Site.SiteState.STARTED.equals((Object)site.getState()));
                siteImpl.setStartupTime(site.getStartupTime());
            }
            data.setPage(sites);
        }
        return data;
    }

    private void addSelectionsForSite(SiteImpl site, DataContainer data) {
        this.initSiteProperties(site);
        ArrayList<String> templateNames = new ArrayList<String>();
        for (Identifier identifier : this.getInstalledTemplates()) {
            templateNames.add(identifier.getDisplayName());
        }
        Collections.sort(templateNames);
        String activeTemplate = site.getProperties().getString("template");
        Selection templateSelection = (Selection)this.selectionFactory.fromObjects("template", "template", (Object[])templateNames.toArray(new String[templateNames.size()]), (Object[])new String[]{activeTemplate});
        data.getSelections().add(templateSelection);
    }

    private List<Identifier> getInstalledTemplates() {
        return this.templateService.getInstalledTemplates();
    }

    @Override
    public void createSite(SiteForm siteForm, FieldProcessor fp) throws BusinessException {
        try {
            SiteImpl site = siteForm.getSite();
            this.checkSite((Site)site, fp, (Site)site);
            this.createSite(site, this.environment);
            this.updateSiteTemplate(site, siteForm.getTemplate());
        }
        catch (Exception e) {
            this.getRequest().handleException(fp, e);
        }
    }

    @Override
    public void updateSite(SiteForm form, FieldProcessor fp) throws BusinessException {
        try {
            SiteImpl site = form.getSite();
            boolean isActive = site.isActive();
            SiteImpl currentSite = (SiteImpl)this.siteRepository.findOne((Serializable)site.getId());
            if (null == currentSite) {
                throw new BusinessException("no such site:" + site.getId());
            }
            this.checkSite((Site)site, fp, (Site)currentSite);
            boolean wasActiveBefore = currentSite.isActive();
            this.getRequest().setPropertyValues((Object)form, (Object)new SiteForm(currentSite), fp.getMetaData());
            if (isActive ^ wasActiveBefore) {
                String message = this.request.getMessage("reloadSite", new Object[0]);
                fp.addNoticeMessage(message);
            }
            this.updateSiteTemplate(currentSite, form.getTemplate());
        }
        catch (Exception e) {
            this.getRequest().handleException(fp, e);
        }
    }

    private void updateSiteTemplate(SiteImpl currentSite, String template) {
        String propertyName = PropertySupport.getPropertyName((Site)currentSite, null, (String)"template");
        this.propertyRepository.findByName(propertyName).setString(template);
    }

    private void checkSite(Site site, FieldProcessor fp, Site currentSite) throws BusinessException {
        if (fp.hasField("site.name") && !this.siteRepository.isUnique(site.getId(), "name", (Object)site.getName())) {
            fp.addErrorMessage(fp.getField("site.name"), this.request.getMessage("site.name.exists", new Object[0]));
        }
        if (!this.siteRepository.isUnique(site.getId(), "host", (Object)site.getHost())) {
            fp.addErrorMessage(fp.getField("site.host"), this.request.getMessage("site.host.exists", new Object[0]));
        }
        if (!this.siteRepository.isUnique(site.getId(), "domain", (Object)site.getDomain())) {
            fp.addErrorMessage(fp.getField("site.domain"), this.request.getMessage("site.domain.exists", new Object[0]));
        }
        if (fp.hasErrors()) {
            throw new BusinessException("invalid name, host or domain");
        }
    }

    @Override
    public DataContainer searchSubjects(Request request, FieldProcessor fp, Integer subjectId, String defaultTimezone, List<String> languages) throws BusinessException {
        DataContainer data = new DataContainer(fp);
        if (subjectId != null) {
            SubjectImpl subject = (SubjectImpl)this.subjectRepository.findOne((Serializable)subjectId);
            if (null == subject) {
                fp.addErrorMessage(request.getMessage("subject.not.exists", new Object[0]));
                throw new BusinessException("no such subject: " + subjectId, "subject.not.exists", new Object[0]);
            }
            SubjectForm subjectsForm = new SubjectForm(subject);
            data.setItem((Object)subjectsForm);
            String timeZone = subject.getTimeZone();
            this.addSelectionsForSubject(data, subject, timeZone == null ? defaultTimezone : timeZone, languages);
        } else {
            String filterParamType = "f_type";
            String filterParamName = "f_name";
            String typeFormRequest = request.getParameter(filterParamType);
            UserType userType = null != typeFormRequest && UserType.names().contains(typeFormRequest) ? UserType.valueOf((String)typeFormRequest) : null;
            String name = request.getParameter(filterParamName);
            SearchQuery searchQuery = this.subjectRepository.createSearchQuery();
            if (StringUtils.isNotBlank((CharSequence)name)) {
                searchQuery.like("name", (Object)("%" + name + "%"));
            } else {
                name = "";
            }
            if (null != userType) {
                searchQuery.equals("userType", (Object)userType);
            }
            Page subjects = this.subjectRepository.search(searchQuery, fp.getPageable());
            for (SubjectImpl subject : subjects) {
                subject.setTypeName(this.getUserTypeNameProvider().getName((Object)subject.getUserType()));
            }
            Selection userTypes = (Selection)this.selectionFactory.fromObjects(filterParamType, "type", (Object[])UserType.values(), this.getUserTypeNameProvider(), (Object[])new UserType[]{userType});
            userTypes.getOptions().add(0, new Option());
            userTypes.setType(SelectionType.SELECT);
            Selection userName = (Selection)this.selectionFactory.fromObjects(filterParamName, "name", (Object[])new String[]{name}, (Object[])new String[]{name});
            userName.setType(SelectionType.TEXT);
            SelectionGroup filterGroup = new SelectionGroup();
            filterGroup.getSelections().add(userName);
            filterGroup.getSelections().add(userTypes);
            data.getSelectionGroups().add(filterGroup);
            data.setPage(subjects);
        }
        return data;
    }

    private void addSelectionsForSubject(DataContainer data, SubjectImpl subject, String timezone, List<String> languages) {
        List allGroups = this.groupRepository.findAll(new Sort(Sort.Direction.ASC, new String[]{"name"}));
        Selection selection = (Selection)this.selectionFactory.fromNamed("groups", "groups", (Iterable)allGroups, (Collection)subject.getGroups());
        data.getSelections().add(selection);
        NameProvider<UserType> nameProvider = this.getUserTypeNameProvider();
        Selection userTypeSelection = (Selection)this.selectionFactory.fromEnum("userType", "type", (Enum[])UserType.values(), (Enum)subject.getUserType(), nameProvider);
        data.getSelections().add(userTypeSelection);
        Selection localeSelection = (Selection)this.selectionFactory.fromObjects("language", "language", languages.toArray(), new Object[]{subject.getLanguage()});
        data.getSelections().add(localeSelection);
        Selection timezoneSelection = this.getTimezoneSelection(timezone);
        data.getSelections().add(timezoneSelection);
    }

    private Selection getTimezoneSelection(String timeZone) {
        Selection timezoneSelection = new Selection();
        timezoneSelection.setId("timeZone");
        Label value = new Label();
        value.setId("timezone");
        timezoneSelection.setTitle(value);
        timezoneSelection.setType(SelectionType.SELECT);
        List<String> ids = Arrays.asList(TimeZone.getAvailableIDs());
        Collections.sort(ids);
        ArrayList<TimeZone> timeZones = new ArrayList<TimeZone>();
        for (String id : ids) {
            if (!id.matches("(Africa|America|Antarctica|Asia|Atlantic|Australia|Europe|Indian|Pacific).*")) continue;
            timeZones.add(TimeZone.getTimeZone(id));
        }
        Locale locale = this.environment.getLocale();
        String groupName = "";
        for (TimeZone tz : timeZones) {
            OptionGroup group;
            String id = tz.getID();
            int separatorIdx = id.indexOf(47);
            String area = id.substring(0, separatorIdx);
            String location = id.substring(id.indexOf(47) + 1);
            String areaKey = "timezone." + area;
            List optionGroups = timezoneSelection.getOptionGroups();
            if (!groupName.equals(area)) {
                group = new OptionGroup();
                String areaName = this.timezoneMessages.getMessage(areaKey, new Object[0], locale);
                Label optLabel = new Label();
                group.setLabel(optLabel);
                optLabel.setValue(areaName);
                optionGroups.add(group);
            } else {
                group = (OptionGroup)optionGroups.get(optionGroups.size() - 1);
            }
            groupName = area;
            Option opt = new Option();
            String locationName = this.timezoneMessages.getMessage(areaKey + "." + location, new Object[0], locale);
            double offset = (double)tz.getRawOffset() / 1000.0 / 60.0 / 60.0;
            int hours = (int)offset;
            int minutes = Math.abs((int)(60.0 * (offset - (double)hours)));
            String gmtTimezone = "GMT" + (offset >= 0.0 ? "+" : "") + StringUtils.leftPad((String)String.valueOf(hours), (int)2, (String)"0") + ":" + StringUtils.leftPad((String)String.valueOf(minutes), (int)2, (String)"0");
            opt.setName(locationName + " (" + gmtTimezone + ")");
            opt.setValue(id);
            opt.setSelected(Boolean.valueOf(id.equals(timeZone)));
            group.getOptions().add(opt);
            Collections.sort(group.getOptions(), new Comparator<Option>(){

                @Override
                public int compare(Option o1, Option o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
        }
        return timezoneSelection;
    }

    private NameProvider<UserType> getUserTypeNameProvider() {
        return new NameProvider<UserType>(){

            public String getName(UserType instance) {
                return ManagerService.this.request.getMessage(UserType.class.getSimpleName() + "." + instance.name(), new Object[0]);
            }
        };
    }

    @Override
    public void createSubject(Locale locale, SubjectForm form, FieldProcessor fp) throws BusinessException {
        try {
            SubjectImpl subject = form.getSubject();
            SubjectImpl subjectByName = this.getSubjectByName(subject.getName(), false);
            if (null != subjectByName) {
                fp.addErrorMessage(fp.getField("subject.name"), this.request.getMessage("subject.exists", new Object[0]));
                throw new BusinessException("subject '" + subject.getName() + "' already exists");
            }
            if (form.isLocalUser()) {
                this.updatePassword(form.getPassword().toCharArray(), form.getPasswordConfirmation().toCharArray(), subject);
            }
            this.subjectRepository.save((Object)subject);
            this.assignGroupsToSubject(subject.getId(), form.getGroupIds(), fp);
        }
        catch (Exception e) {
            this.getRequest().handleException(fp, e);
        }
    }

    @Override
    public Boolean updateSubject(SubjectForm subjectForm, FieldProcessor fp) throws BusinessException {
        Boolean updated = false;
        SubjectImpl subject = subjectForm.getSubject();
        try {
            SubjectImpl currentSubject;
            if (subject.getId() != null) {
                currentSubject = (SubjectImpl)this.subjectRepository.findOne((Serializable)subject.getId());
                if (null == currentSubject) {
                    fp.addErrorMessage(this.request.getMessage("subject.not.exists", new Object[0]));
                }
                if (!StringUtils.isEmpty((CharSequence)subjectForm.getPassword()) && !StringUtils.isEmpty((CharSequence)subjectForm.getPasswordConfirmation())) {
                    updated = this.updatePassword(subjectForm.getPassword().toCharArray(), subjectForm.getPasswordConfirmation().toCharArray(), currentSubject);
                }
            } else {
                throw new BusinessException("No such user exists");
            }
            this.assignGroupsToSubject(subject.getId(), subjectForm.getGroupIds(), fp);
            this.getRequest().setPropertyValues((Object)subjectForm, (Object)new SubjectForm(currentSubject), fp.getMetaData());
        }
        catch (Exception e) {
            this.getRequest().handleException(fp, e);
        }
        return updated;
    }

    @Override
    public void assignGroupsToSubject(Integer subjectId, List<Integer> groupIds, FieldProcessor fp) throws BusinessException {
        try {
            this.assignGroupsToSubject(subjectId, groupIds, true);
        }
        catch (Exception e) {
            this.getRequest().handleException(fp, e);
        }
    }

    public void assignPermissionsToRole(Role role, List<Integer> permissionsIds, FieldProcessor fp) throws BusinessException {
        try {
            role.getPermissions().clear();
            for (Integer id : permissionsIds) {
                Permission permission = (Permission)this.permissionRepository.findOne((Serializable)id);
                role.getPermissions().add(permission);
            }
        }
        catch (Exception e) {
            this.getRequest().handleException(fp, e);
        }
    }

    @Override
    public MigrationService.MigrationStatus assignApplicationToSite(Integer siteId, Integer appId, FieldProcessor fp) throws BusinessException {
        return this.assignApplicationToSite(this.environment, siteId, appId, fp, true);
    }

    @Override
    public MigrationService.MigrationStatus removeApplicationFromSite(Integer siteId, Integer appId, FieldProcessor fp) throws BusinessException {
        return this.assignApplicationToSite(this.environment, siteId, appId, fp, false);
    }

    private MigrationService.MigrationStatus assignApplicationToSite(Environment environment, Integer siteId, Integer appId, FieldProcessor fp, boolean assign) throws BusinessException {
        boolean isLive;
        boolean isAssigned;
        MigrationService.MigrationStatus migrationStatus = null;
        SiteImpl site = (SiteImpl)this.siteRepository.findOne((Serializable)siteId);
        Application application = (Application)this.applicationRepository.findOne((Serializable)appId);
        SiteApplication siteApplication = (SiteApplication)this.siteApplicationRepository.findOne((Serializable)new SiteApplicationPK(siteId, appId));
        boolean bl = isAssigned = null != siteApplication;
        if (isAssigned) {
            boolean hasConnection = null != siteApplication.getDatabaseConnection();
            migrationStatus = hasConnection ? MigrationService.MigrationStatus.DB_SUPPORTED : MigrationService.MigrationStatus.NO_DB_SUPPORTED;
        }
        Site liveSite = RequestUtil.getSiteByName((Environment)environment, (String)site.getName());
        SiteApplication liveApplication = null;
        if (null != liveSite) {
            liveApplication = ((SiteImpl)liveSite).getSiteApplication(application.getName());
        }
        boolean bl2 = isLive = null != liveApplication;
        if (assign) {
            if (isAssigned) {
                siteApplication.setActive(true);
                siteApplication.setMarkedForDeletion(false);
                siteApplication.setReloadRequired(!siteApplication.isReloadRequired());
                this.auditableListener.createEvent(PlatformEvent.Type.INFO, String.format("Assigned application %s to site %s", application.getName(), site.getName()));
            } else {
                migrationStatus = this.assignApplicationToSite(site, application, true);
                switch (migrationStatus) {
                    case ERROR: {
                        fp.addErrorMessage(this.request.getMessage("migration.failed", new Object[0]));
                        break;
                    }
                    case DB_MIGRATED: {
                        fp.addOkMessage(this.request.getMessage("migration.success", new Object[0]));
                        break;
                    }
                    case NO_DB_SUPPORTED: {
                        fp.addOkMessage(this.request.getMessage("migration.noDbSupported", new Object[0]));
                        break;
                    }
                    case DB_SUPPORTED: {
                        fp.addNoticeMessage(this.request.getMessage("migration.dbSupported", new Object[0]));
                        break;
                    }
                    case DB_NOT_AVAILABLE: {
                        fp.addErrorMessage(this.request.getMessage("migration.dbNotAvailable", new Object[0]));
                    }
                }
            }
        } else if (isAssigned) {
            this.logger.debug("removing application '" + application.getName() + "' from site '" + site.getName() + "'");
            if (!isLive) {
                migrationStatus = this.unlinkApplicationFromSite(siteApplication);
                DatabaseConnection connection = siteApplication.getDatabaseConnection();
                switch (migrationStatus) {
                    case ERROR: {
                        fp.addOkMessage(this.request.getMessage("migration.dbDeleteFailed", new Object[]{connection.getJdbcUrl()}));
                        break;
                    }
                    case DB_MIGRATED: {
                        fp.addOkMessage(this.request.getMessage("migration.dbDeleted", new Object[]{connection.getJdbcUrl()}));
                        break;
                    }
                    case DB_SUPPORTED: {
                        fp.addOkMessage(this.request.getMessage("migration.dbNotDeleted", new Object[]{connection.getJdbcUrl()}));
                        break;
                    }
                }
            } else {
                this.auditableListener.createEvent(PlatformEvent.Type.INFO, String.format("Removed application %s from site %s", siteApplication.getApplication().getName(), site.getName()));
                siteApplication.setActive(false);
                siteApplication.setMarkedForDeletion(true);
                siteApplication.setReloadRequired(!siteApplication.isReloadRequired());
            }
        }
        return migrationStatus;
    }

    @Override
    public void createPermission(PermissionImpl permission, Integer appId, FieldProcessor fp) throws BusinessException {
        if (null == appId) {
            throw new BusinessException("no application ID provided");
        }
        ApplicationImpl application = (ApplicationImpl)this.applicationRepository.findOne((Serializable)appId);
        permission.setApplication(application);
        this.checkUniquePermissionName((Permission)permission, permission.getName(), fp);
        this.permissionRepository.save((Object)permission);
    }

    @Override
    public void updatePermission(Permission permission, FieldProcessor fp) throws BusinessException {
        PermissionImpl currentPermission;
        if (permission.getId() != null) {
            currentPermission = (PermissionImpl)this.permissionRepository.findOne(permission.getId());
            if (null == currentPermission) {
                throw new BusinessException("No such permission!", "permission.not.exists", new Object[0]);
            }
        } else {
            throw new BusinessException("No such permission!", "permission.not.exists", new Object[0]);
        }
        this.checkUniquePermissionName((Permission)currentPermission, permission.getName(), fp);
        this.getRequest().setPropertyValues((Object)permission, (Object)currentPermission, fp.getMetaData());
    }

    private void checkUniquePermissionName(Permission permission, String name, FieldProcessor fp) throws BusinessException {
        boolean isUnique = this.permissionRepository.isUnique(permission.getId(), new String[]{"name", "application.id"}, new Object[]{name, permission.getApplication().getId()});
        if (!isUnique) {
            fp.addErrorMessage(fp.getField("name"), this.request.getMessage("permission.exists", new Object[0]));
            throw new BusinessException("a permission named '" + permission.getName() + "' already exists for application '" + permission.getApplication().getName() + "'");
        }
    }

    @Override
    public DataContainer searchPermissions(FieldProcessor fp, Integer permissionId, Integer appId) throws BusinessException {
        DataContainer data = new DataContainer(fp);
        if (permissionId != null) {
            PermissionImpl permission = (PermissionImpl)this.permissionRepository.findOne((Serializable)permissionId);
            if (null == permission) {
                throw new BusinessException("no such permission " + permissionId, "permission.not.exists", new Object[0]);
            }
            data.setItem((Object)permission);
        } else {
            SearchQuery query = new SearchQuery(PermissionImpl.class).equals("application.id", (Object)appId);
            Page permissions = this.permissionRepository.search(query, fp.getPageable());
            data.setPage(permissions);
        }
        return data;
    }

    @Override
    public DataContainer searchProperties(FieldProcessor fp, Integer siteId, Integer appId, String propertyName) throws BusinessException {
        DataContainer data = new DataContainer(fp);
        if (propertyName != null && propertyName.length() > 0) {
            PropertyImpl property = (PropertyImpl)this.propertyRepository.findOne((Serializable)((Object)propertyName));
            if (null == property) {
                throw new BusinessException("no such property " + propertyName, "property.not.exists", new Object[0]);
            }
            data.setItem((Object)new PropertyForm(property));
        } else {
            Page properties = this.getProperties(siteId, appId, fp.getPageable());
            data.setPage(properties);
        }
        return data;
    }

    @Override
    public void createProperty(PropertyForm propertyForm, Integer siteId, Integer appId, FieldProcessor fp) throws BusinessException {
        try {
            PropertyImpl property = propertyForm.getProperty();
            if (this.checkPropertyExists(siteId, appId, property)) {
                fp.addErrorMessage(this.request.getMessage("property.exists", new Object[0]));
                throw new BusinessException("property already exists!");
            }
            this.createProperty(siteId, appId, property);
        }
        catch (Exception e) {
            this.getRequest().handleException(fp, e);
        }
    }

    @Override
    public void updateProperty(PropertyForm propertyForm, FieldProcessor fp) throws BusinessException {
        try {
            PropertyImpl currentProperty;
            PropertyImpl property = propertyForm.getProperty();
            if (property.getName() != null) {
                currentProperty = (PropertyImpl)this.propertyRepository.findOne((Serializable)((Object)property.getName()));
                if (null == currentProperty) {
                    throw new BusinessException("no such property");
                }
            } else {
                throw new BusinessException("no propertyname given");
            }
            this.getRequest().setPropertyValues((Object)propertyForm, (Object)new PropertyForm(currentProperty), fp.getMetaData());
        }
        catch (Exception e) {
            this.getRequest().handleException(fp, e);
        }
    }

    @Override
    public void deleteProperty(String id, FieldProcessor fp) throws BusinessException {
        PropertyImpl prop = (PropertyImpl)this.propertyRepository.findOne((Serializable)((Object)id));
        try {
            if (null == prop) {
                throw new BusinessException("No such property " + id);
            }
            this.deleteProperty(prop);
        }
        catch (Exception e) {
            this.getRequest().handleException(fp, e);
        }
    }

    @Override
    public void reloadSite(Application application, Integer siteId, FieldProcessor fp) throws BusinessException {
        block5: {
            try {
                InitializerService initializerService = (InitializerService)application.getBean(InitializerService.class);
                SiteImpl site = this.getSite(siteId);
                if (null == site) break block5;
                String siteName = site.getName();
                if (site.isActive()) {
                    try {
                        initializerService.loadSite(this.environment, site, fp);
                        this.logger.info("Site reloaded: " + siteName);
                        break block5;
                    }
                    catch (InvalidConfigurationException e) {
                        throw new BusinessException("Invalid configuration for site: " + siteName, (Throwable)e);
                    }
                }
                this.shutdownSite(this.environment, siteName);
            }
            catch (Exception e) {
                this.getRequest().handleException(fp, e);
            }
        }
    }

    @Override
    public DataContainer getNewSubject(FieldProcessor fp, String timezone, List<String> languages) {
        DataContainer data = new DataContainer(fp);
        SubjectForm subjectsForm = new SubjectForm();
        SubjectImpl subject = subjectsForm.getSubject();
        subject.setGroups(new ArrayList());
        subject.setLanguage("");
        subject.setRealname("");
        subject.setName("");
        subject.setEmail("");
        subject.setUserType(UserType.LOCAL_USER);
        subject.setTimeZone(timezone);
        data.setItem((Object)subjectsForm);
        this.addSelectionsForSubject(data, subject, timezone, languages);
        return data;
    }

    @Override
    public DataContainer getNewPermission(FieldProcessor fp) {
        DataContainer data = new DataContainer(fp);
        PermissionImpl permission = new PermissionImpl();
        permission.setDescription("");
        permission.setName("");
        data.setItem((Object)permission);
        return data;
    }

    @Override
    public DataContainer getNewGroup(Site site, FieldProcessor fp) {
        DataContainer data = new DataContainer(fp);
        GroupForm groupForm = new GroupForm();
        GroupImpl group = groupForm.getGroup();
        group.setDescription("");
        group.setName("");
        group.setSubjects(new HashSet());
        data.setItem((Object)groupForm);
        Selection roleSelection = this.getRoleSelection((Group)group, (Integer)site.getId());
        data.getSelections().add(roleSelection);
        return data;
    }

    @Override
    public DataContainer getNewSite(FieldProcessor fp) {
        DataContainer data = new DataContainer(fp);
        SiteForm sitesForm = new SiteForm();
        SiteImpl site = sitesForm.getSite();
        site.setActive(false);
        site.setCreateRepository(false);
        site.setDescription("");
        site.setHost("");
        site.setName("");
        site.setDomain("");
        site.setProperties(null);
        data.setItem((Object)sitesForm);
        this.addSelectionsForSite(site, data);
        return data;
    }

    @Override
    public DataContainer getNewRepository(FieldProcessor fp) {
        DataContainer data = new DataContainer(fp);
        try {
            Selection repositoryModeSelection;
            RepositoryImpl repository = new RepositoryImpl();
            repository.setActive(false);
            repository.setDescription("");
            repository.setName("");
            repository.setRepositoryType(RepositoryType.getDefault());
            repository.setUri(new URI(""));
            repository.setPublished(false);
            repository.setRepositoryMode(RepositoryMode.getDefault());
            data.setItem((Object)new RepositoryForm(repository));
            Selection repositoryTypeSelection = this.getRepositoryTypeSelection(null);
            if (null != repositoryTypeSelection) {
                data.getSelections().add(repositoryTypeSelection);
            }
            if (null != (repositoryModeSelection = this.getRepositoryModeSelection(null))) {
                data.getSelections().add(repositoryModeSelection);
            }
        }
        catch (URISyntaxException e) {
            this.logger.error("", (Throwable)e);
        }
        return data;
    }

    private Selection getRepositoryTypeSelection(RepositoryType repositoryType) {
        return this.getTypeSelection(RepositoryType.class, repositoryType, "repositoryType", "repositoryType");
    }

    private Selection getRepositoryModeSelection(RepositoryMode repositoryMode) {
        return this.getTypeSelection(RepositoryMode.class, repositoryMode, "repositoryMode", "repositoryMode");
    }

    private <E extends Enum<E>> Selection getTypeSelection(final Class<E> clazz, E type, String id, String title) {
        NameProvider nameProvider = new NameProvider<E>(){

            public String getName(E instance) {
                return ManagerService.this.request.getMessage(clazz.getSimpleName() + "." + ((Enum)instance).name(), new Object[0]);
            }
        };
        return (Selection)this.selectionFactory.fromEnum(id, title, (Enum[])clazz.getEnumConstants(), type, nameProvider);
    }

    @Override
    public DataContainer getNewRole(FieldProcessor fp, Integer appId) {
        DataContainer data = new DataContainer(fp);
        RoleForm rolesForm = new RoleForm();
        RoleImpl role = rolesForm.getRole();
        data.setItem((Object)rolesForm);
        data.getSelections().add(this.getPermissionSelection(appId, role));
        return data;
    }

    @Override
    public DataContainer getNewProperty(FieldProcessor fp) {
        DataContainer data = new DataContainer(fp);
        PropertyForm propertiesForm = new PropertyForm();
        data.setItem((Object)propertiesForm);
        return data;
    }

    @Override
    public List<JarInfo> getJars(Environment environment, Integer siteId) {
        List jarInfos;
        if (null != siteId) {
            SiteImpl site = (SiteImpl)this.siteRepository.findOne((Serializable)siteId);
            jarInfos = (List)environment.getAttribute(Scope.PLATFORM, site.getName() + "." + "jarInfoMap");
        } else {
            jarInfos = (List)environment.getAttribute(Scope.PLATFORM, "platformConfig.jarInfoMap");
        }
        if (null != jarInfos) {
            Collections.sort(jarInfos);
        }
        return jarInfos;
    }

    public Request getRequest() {
        return this.request;
    }

    @Override
    public void setRequest(Request request) {
        this.request = request;
    }

    @Override
    public void updateDatabaseConnection(FieldProcessor fp, DatabaseConnection databaseConnection) {
        DatabaseConnection current = (DatabaseConnection)this.databaseConnectionRepository.findOne((Serializable)databaseConnection.getId());
        byte[] currentPassword = current.getPassword();
        this.request.setPropertyValues((Object)databaseConnection, (Object)current, fp.getMetaData());
        if (StringUtils.isBlank((CharSequence)current.getPasswordPlain())) {
            current.setPassword(currentPassword);
        }
        boolean isConnectionWorking = this.testConnection(fp, current, false);
        if (current.isActive() && !isConnectionWorking) {
            fp.addNoticeMessage(this.request.getMessage("connection.notActive", new Object[]{current.getName()}));
            current.setActive(false);
        } else if (!current.isRootConnection()) {
            current.setActive(isConnectionWorking);
        }
        fp.addOkMessage(this.request.getMessage("connection.updated", new Object[0]));
    }

    @Override
    public void createDatabaseConnection(FieldProcessor fp, DatabaseConnection databaseConnection, Integer siteId) {
        if (null != siteId) {
            SiteImpl site = this.getSite(siteId);
            databaseConnection.setSite((Site)site);
        }
        this.createDatabaseConnection(databaseConnection, false);
        fp.addOkMessage(this.request.getMessage("connection.created", new Object[0]));
        this.testConnection(fp, databaseConnection, true);
    }

    private boolean testConnection(FieldProcessor fp, DatabaseConnection current, boolean addError) {
        StringBuilder dbInfo = new StringBuilder();
        if (current.testConnection(dbInfo)) {
            fp.addOkMessage(this.request.getMessage("connection.successfull", new Object[]{dbInfo.toString()}));
            return true;
        }
        if (addError) {
            fp.addErrorMessage(this.request.getMessage("connection.failed", new Object[0]));
        }
        return false;
    }

    @Override
    public void testConnection(FieldProcessor fp, Integer connectionId) {
        DatabaseConnection databaseConnection = this.getDatabaseConnection(connectionId, false);
        this.testConnection(fp, databaseConnection, true);
    }

    @Override
    public void deleteDatabaseConnection(FieldProcessor fp, Integer conId) {
        DatabaseConnection current = (DatabaseConnection)this.databaseConnectionRepository.findOne((Serializable)conId);
        if (null != current) {
            this.databaseConnectionRepository.delete((Object)current);
            fp.addOkMessage(this.request.getMessage("connection.deleted", new Object[0]));
        } else {
            fp.addErrorMessage(this.request.getMessage("connection.noSuchId", new Object[0]));
        }
    }

    @Override
    public Collection<? extends Role> findRolesForSite(Integer siteId) {
        return this.roleRepository.findRolesForSite(siteId);
    }

    @Override
    public void resetConnection(Integer conId) {
        this.resetConnection(null, conId);
    }

    @Override
    public SiteApplication getSiteApplication(Integer siteId, Integer appId) {
        SiteApplication siteApplication = (SiteApplication)this.siteApplicationRepository.findOne((Serializable)new SiteApplicationPK(siteId, appId));
        siteApplication.getGrantedSites().size();
        return siteApplication;
    }

    @Override
    public List<Selection> getGrantedSelections(Integer siteId, Integer appId) {
        ArrayList<SiteImpl> grantedBy = new ArrayList<SiteImpl>();
        SiteApplication siteApplication = this.getSiteApplication(siteId, appId);
        Site grantedSite = siteApplication.getSite();
        Application application = siteApplication.getApplication();
        List allSites = this.siteRepository.findAll(new Sort(new String[]{"name"}));
        allSites.remove(grantedSite);
        for (SiteImpl site : new ArrayList(allSites)) {
            SiteApplication granted = this.siteApplicationRepository.findByApplicationNameAndGrantedSitesName(application.getName(), site.getName());
            if (null == granted || granted.equals(siteApplication)) continue;
            allSites.remove(site);
            grantedBy.add(site);
        }
        Selection granted = (Selection)this.selectionFactory.fromNamed("siteApplication.grantedSites", "sites", (Iterable)allSites, (Collection)siteApplication.getGrantedSites());
        Selection grantedSitesBy = (Selection)this.selectionFactory.fromNamed("grantedBy", "grantedBy", grantedBy, grantedBy);
        ArrayList<Selection> selections = new ArrayList<Selection>();
        selections.add(granted);
        selections.add(grantedSitesBy);
        return selections;
    }

    @Override
    public void grantSites(Integer siteId, Integer appId, Set<Integer> grantedSiteIds) {
        SiteApplication siteApplication = this.getSiteApplication(siteId, appId);
        siteApplication.getGrantedSites().clear();
        List sites = this.siteRepository.findAll(grantedSiteIds);
        siteApplication.getGrantedSites().addAll(sites);
    }

    @Override
    public String addArchiveToRepository(Integer repositoryId, FormUpload archive, FieldProcessor fp) {
        String name = null;
        File file = archive.getFile();
        String originalFilename = archive.getOriginalFilename();
        RepositoryImpl repo = (RepositoryImpl)this.repoRepository.findOne((Serializable)repositoryId);
        RepositoryMode repositoryMode = repo.getRepositoryMode();
        PackageArchive packageArchive = RepositoryUtils.getPackage((Repository)repo, (File)file, (String)originalFilename);
        if (null != packageArchive && RepositoryType.LOCAL.equals((Object)repo.getRepositoryType())) {
            File targetFolder = new File(repo.getUri().getPath());
            try {
                File targetArchive = new File(targetFolder, originalFilename);
                boolean existedBefore = targetArchive.exists();
                FileUtils.copyFile((File)file, (File)targetArchive);
                if (existedBefore) {
                    String message = this.request.getMessage("repository.archive.replaced", new Object[]{originalFilename});
                    fp.addNoticeMessage(message);
                }
                this.logger.info("copied archive from {} to {}", (Object)file, (Object)targetArchive);
                name = packageArchive.getPackageInfo().getName();
            }
            catch (IOException e) {
                throw new ApplicationException("error while copying archive to " + targetFolder, (Throwable)e);
            }
        } else {
            String message = this.request.getMessage("repository.archive.wrongMode", new Object[]{repositoryMode, repositoryMode.equals((Object)RepositoryMode.STABLE) ? "snapshot" : "stable"});
            fp.addErrorMessage(fp.getField("archive"), message);
        }
        FileUtils.deleteQuietly((File)file);
        return name;
    }

    @Override
    public RepositoryImpl getRepository(Integer repositoryId) {
        return (RepositoryImpl)this.repoRepository.findOne((Serializable)repositoryId);
    }

    @Override
    public String getNameForSite(Integer siteId) {
        Site site = (Site)this.siteRepository.findOne((Serializable)siteId);
        return site == null ? null : site.getName();
    }

    public MessageSource getTimezoneMessages() {
        return this.timezoneMessages;
    }

    public void setTimezoneMessages(MessageSource timezoneMessages) {
        this.timezoneMessages = timezoneMessages;
    }

    @Override
    public List<AppngCache> getCacheEntries(Integer siteId) {
        return super.getCacheEntries(siteId);
    }

    @Override
    public Map<String, String> getCacheStatistics(Integer siteId) {
        return super.getCacheStatistics(siteId);
    }

    @Override
    public void expireCacheElement(FieldProcessor fp, Request request, Integer siteId, String cacheElement) {
        String cacheElementNotExists = "cache.element.notExists";
        String cacheElementDeleted = "cache.element.deleted";
        try {
            this.expireCacheElement(siteId, cacheElement);
            fp.addNoticeMessage(request.getMessage(cacheElementDeleted, new Object[0]));
        }
        catch (BusinessException e) {
            fp.addErrorMessage(request.getMessage(cacheElementNotExists, new Object[0]));
        }
    }

    @Override
    public void clearCacheStatistics(FieldProcessor fp, Request request, Integer siteId) {
        String cacheStatisticsCleared = "cache.statistics.cleared";
        this.clearCacheStatistics(siteId);
        fp.addNoticeMessage(request.getMessage(cacheStatisticsCleared, new Object[0]));
    }

    @Override
    public void clearCache(FieldProcessor fp, Request request, Integer siteId) {
        String cacheCleared = "cache.cleared";
        this.clearCache(siteId);
        fp.addNoticeMessage(request.getMessage(cacheCleared, new Object[0]));
    }

    @Override
    public void deleteTemplate(String name, FieldProcessor fp) {
        Integer code = this.deleteTemplate(name);
        String message = this.request.getMessage("template.delete.status." + code, new Object[]{name});
        if (0 == code) {
            fp.addOkMessage(message);
        } else {
            fp.addErrorMessage(message);
        }
    }

    @Override
    public List<Identifier> listTemplates() {
        return this.templateService.getInstalledTemplates();
    }

    @Override
    public void createEvent(PlatformEvent.Type type, String message) {
        this.auditableListener.createEvent(type, message);
    }
}

