/*
 * Decompiled with CFR 0.152.
 */
package org.appng.application.manager.form;

import org.appng.api.Environment;
import org.appng.api.FieldProcessor;
import org.appng.api.FileUpload;
import org.appng.api.FormValidator;
import org.appng.api.Options;
import org.appng.api.Request;
import org.appng.api.model.Application;
import org.appng.api.model.Site;
import org.appng.application.manager.form.RepositoryForm;
import org.appng.core.domain.PackageArchiveImpl;
import org.appng.forms.FormUpload;
import org.appng.xml.platform.FieldDef;

public class PackageUploadForm
extends RepositoryForm
implements FormValidator {
    private FormUpload archive;

    public void validate(Site site, Application application, Environment environment, Options options, Request request, FieldProcessor fp) {
        FieldDef field = fp.getField("archive");
        if (null != this.archive) {
            PackageArchiveImpl packageArchive = new PackageArchiveImpl(this.archive.getFile(), this.archive.getOriginalFilename());
            if (!packageArchive.isValid()) {
                fp.addErrorMessage(field, request.getMessage("packageArchive.invalid", new Object[0]));
            }
        } else {
            fp.addErrorMessage(request.getMessage("packageArchive.noFile", new Object[0]));
        }
    }

    @FileUpload(fileTypes="zip", maxSize=50L, unit=FileUpload.Unit.MB)
    public FormUpload getArchive() {
        return this.archive;
    }

    public void setArchive(FormUpload archive) {
        this.archive = archive;
    }
}

