/*
 * Decompiled with CFR 0.152.
 */
package org.appng.application.manager.business.webservice;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.NoSuchElementException;

class FastAccessFile {
    public static final char LF = '\n';
    private ByteBuffer cb;
    private long size;

    public FastAccessFile(File file) throws IOException {
        try (FileInputStream is = new FileInputStream(file);
             FileChannel fc = is.getChannel();){
            this.size = fc.size();
            this.cb = fc.map(FileChannel.MapMode.READ_ONLY, 0L, fc.size());
        }
    }

    public Iterator<String> tail(long lines) {
        long cnt = 0L;
        long i = 0L;
        for (i = this.size - 1L; i >= 0L && (this.cb.get((int)i) != 10 || ++cnt != lines + 1L); --i) {
        }
        return new LineIterator((int)i + 1);
    }

    private class LineIterator
    implements Iterator<String> {
        private static final char CR = '\r';
        private int offset;

        public LineIterator(int offset) {
            this.offset = offset;
        }

        @Override
        public boolean hasNext() {
            return this.offset < FastAccessFile.this.cb.limit();
        }

        @Override
        public String next() {
            if (this.offset >= FastAccessFile.this.cb.limit()) {
                throw new NoSuchElementException();
            }
            ByteArrayOutputStream sb = new ByteArrayOutputStream();
            while (this.offset < FastAccessFile.this.cb.limit()) {
                byte c = FastAccessFile.this.cb.get(this.offset);
                if (c == 10) {
                    ++this.offset;
                    break;
                }
                if (c != 13) {
                    sb.write(c);
                }
                ++this.offset;
            }
            try {
                return sb.toString(StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return sb.toString();
            }
        }

        @Override
        public void remove() {
        }
    }
}

