/*
 * Decompiled with CFR 0.152.
 */
package org.appng.application.manager.business;

import java.util.ArrayList;
import org.appng.api.ActionProvider;
import org.appng.api.BusinessException;
import org.appng.api.DataContainer;
import org.appng.api.DataProvider;
import org.appng.api.Environment;
import org.appng.api.FieldProcessor;
import org.appng.api.Options;
import org.appng.api.Request;
import org.appng.api.model.Application;
import org.appng.api.model.ResourceType;
import org.appng.api.model.Site;
import org.appng.api.support.SelectionFactory;
import org.appng.application.manager.form.UploadForm;
import org.appng.application.manager.service.Service;
import org.appng.application.manager.service.ServiceAware;
import org.appng.xml.platform.Option;
import org.appng.xml.platform.Selection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Lazy
@Component
@Scope(value="request")
public class Upload
extends ServiceAware
implements ActionProvider<UploadForm>,
DataProvider {
    private static final Logger log = LoggerFactory.getLogger(Upload.class);
    @Autowired
    SelectionFactory selectionFactory;

    public DataContainer getData(Site site, Application application, Environment environment, Options options, Request request, FieldProcessor fp) {
        DataContainer d = new DataContainer(fp);
        UploadForm form = new UploadForm();
        d.setItem((Object)form);
        ResourceType[] types = ResourceType.values();
        Selection selectionFromEnum = (Selection)this.selectionFactory.fromEnum("type", "type", (Enum[])types, new ArrayList());
        selectionFromEnum.getOptions().add(0, new Option());
        d.getSelections().add(selectionFromEnum);
        return d;
    }

    public void perform(Site site, Application application, Environment environment, Options options, Request request, UploadForm form, FieldProcessor fp) {
        Service service = this.getService();
        Integer applicationId = (Integer)request.convert((Object)options.getOptionValue("application", "id"), Integer.class);
        try {
            service.createResource(site, applicationId, form, fp);
        }
        catch (BusinessException ex) {
            log.error("error while processing resource", (Throwable)ex);
        }
    }
}

