/*
 * Decompiled with CFR 0.152.
 */
package org.appng.application.manager.business;

import java.util.List;
import org.appng.api.ActionProvider;
import org.appng.api.BusinessException;
import org.appng.api.DataContainer;
import org.appng.api.DataProvider;
import org.appng.api.Environment;
import org.appng.api.FieldProcessor;
import org.appng.api.Options;
import org.appng.api.Request;
import org.appng.api.model.Application;
import org.appng.api.model.Site;
import org.appng.api.model.Subject;
import org.appng.application.manager.form.SubjectForm;
import org.appng.application.manager.service.Service;
import org.appng.application.manager.service.ServiceAware;
import org.appng.core.domain.SubjectImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Lazy
@Component
@Scope(value="request")
public class Subjects
extends ServiceAware
implements DataProvider,
ActionProvider<SubjectForm> {
    private static final Logger log = LoggerFactory.getLogger(Subjects.class);
    private static final String SUBJECT = "subject";

    public void perform(Site site, Application application, Environment environment, Options options, Request request, SubjectForm valueHolder, FieldProcessor fp) {
        String action = this.getAction(options);
        String errorMessage = null;
        String okMessage = null;
        Service service = this.getService();
        Integer subjectId = (Integer)request.convert((Object)options.getOptionValue(SUBJECT, "id"), Integer.class);
        try {
            if ("create".equals(action)) {
                errorMessage = "subject.create.error";
                service.createSubject(environment.getLocale(), valueHolder, fp);
                okMessage = "subject.created";
            } else if ("update".equals(action)) {
                SubjectImpl subject = valueHolder.getSubject();
                subject.setId(subjectId);
                okMessage = "subject.updated";
                errorMessage = "subject.update.error";
                Boolean isUpdated = service.updateSubject(valueHolder, fp);
                if (isUpdated.booleanValue()) {
                    String passwordMessage = request.getMessage("subject.password.updated", new Object[]{subjectId});
                    fp.addOkMessage(passwordMessage);
                    okMessage = null;
                }
            } else if ("delete".equals(action)) {
                errorMessage = "subject.delete.error";
                Subject currentSubject = environment.getSubject();
                service.deleteSubject(currentSubject, subjectId, fp);
                okMessage = "subject.deleted";
            }
            if (null != okMessage) {
                String message = request.getMessage(okMessage, new Object[]{subjectId});
                fp.addOkMessage(message);
            }
        }
        catch (BusinessException ex) {
            String message = request.getMessage(errorMessage, new Object[]{subjectId});
            log.error(message, (Throwable)ex);
            fp.addErrorMessage(message);
        }
    }

    public DataContainer getData(Site site, Application application, Environment environment, Options options, Request request, FieldProcessor fp) {
        Service service = this.getService();
        Integer subjectId = (Integer)request.convert((Object)options.getOptionValue(SUBJECT, "id"), Integer.class);
        List languages = site.getProperties().getList("supportedLanguages", ",");
        String defaultTimezone = site.getProperties().getString("timeZone");
        DataContainer data = null;
        if (subjectId == null && "create".equals(this.getAction(options))) {
            data = service.getNewSubject(fp, defaultTimezone, languages);
        } else {
            try {
                data = service.searchSubjects(request, fp, subjectId, defaultTimezone, languages);
            }
            catch (BusinessException ex) {
                String message = request.getMessage(ex.getMessageKey(), ex.getMessageArgs());
                log.error(message, (Throwable)ex);
                fp.addErrorMessage(message);
            }
        }
        return data;
    }
}

