/*
 * Decompiled with CFR 0.152.
 */
package org.appng.application.manager.business;

import org.appng.api.ActionProvider;
import org.appng.api.BusinessException;
import org.appng.api.DataContainer;
import org.appng.api.DataProvider;
import org.appng.api.Environment;
import org.appng.api.FieldProcessor;
import org.appng.api.MessageParam;
import org.appng.api.Options;
import org.appng.api.Request;
import org.appng.api.model.Application;
import org.appng.api.model.Site;
import org.appng.application.manager.form.RoleForm;
import org.appng.application.manager.service.Service;
import org.appng.application.manager.service.ServiceAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Lazy
@Component
@Scope(value="request")
public class Roles
extends ServiceAware
implements DataProvider,
ActionProvider<RoleForm> {
    private static final Logger log = LoggerFactory.getLogger(Roles.class);

    public void perform(Site site, Application application, Environment environment, Options options, Request request, RoleForm roleForm, FieldProcessor fp) {
        String action = this.getAction(options);
        String okMessage = null;
        Service service = this.getService();
        Integer applicationroleId = (Integer)request.convert((Object)options.getOptionValue("id", "id"), Integer.class);
        try {
            if ("create".equals(action)) {
                Integer applicationId = (Integer)request.convert((Object)options.getOptionValue("application", "id"), Integer.class);
                service.createRole(roleForm, applicationId, fp);
                okMessage = "role.created";
            } else if ("update".equals(action)) {
                Integer roleId = (Integer)request.convert((Object)options.getOptionValue("id", "id"), Integer.class);
                roleForm.getRole().setId(roleId);
                service.updateRole(roleForm, fp);
                okMessage = "role.updated";
            } else if ("delete".equals(action)) {
                service.deleteRole(applicationroleId);
                okMessage = "role.deleted";
            }
            String message = request.getMessage(okMessage, new Object[]{applicationroleId});
            fp.addOkMessage(message);
        }
        catch (BusinessException e) {
            log.error("error while performing action", (Throwable)e);
            request.addErrorMessage(fp, (MessageParam)e);
        }
    }

    public DataContainer getData(Site site, Application application, Environment environment, Options options, Request request, FieldProcessor fp) {
        Service service = this.getService();
        Integer applicationRoleId = (Integer)request.convert((Object)options.getOptionValue("id", "id"), Integer.class);
        Integer applicationId = (Integer)request.convert((Object)options.getOptionValue("application", "id"), Integer.class);
        DataContainer data = null;
        if (null == applicationRoleId && "create".equals(this.getAction(options))) {
            data = service.getNewRole(fp, applicationId);
        } else {
            try {
                data = service.searchRole(fp, applicationRoleId, applicationId);
            }
            catch (BusinessException ex) {
                String message = request.getMessage(ex.getMessageKey(), ex.getMessageArgs());
                log.error(message, (Throwable)ex);
                fp.addErrorMessage(message);
            }
        }
        return data;
    }
}

