/*
 * Decompiled with CFR 0.152.
 */
package org.appng.application.manager.business;

import org.apache.commons.lang3.StringUtils;
import org.appng.api.ActionProvider;
import org.appng.api.ApplicationException;
import org.appng.api.BusinessException;
import org.appng.api.DataContainer;
import org.appng.api.DataProvider;
import org.appng.api.Environment;
import org.appng.api.FieldProcessor;
import org.appng.api.Options;
import org.appng.api.Request;
import org.appng.api.model.Application;
import org.appng.api.model.ResourceType;
import org.appng.api.model.Site;
import org.appng.application.manager.form.ResourceForm;
import org.appng.application.manager.service.Service;
import org.appng.application.manager.service.ServiceAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Lazy
@Component
@Scope(value="request")
public class Resources
extends ServiceAware
implements ActionProvider<ResourceForm>,
DataProvider {
    private static final Logger log = LoggerFactory.getLogger(Resources.class);
    private static final String TYPE = "type";
    private static final String RESOURCE = "resource";

    public void perform(Site site, Application application, Environment environment, Options options, Request request, ResourceForm form, FieldProcessor fp) {
        String action = this.getAction(options);
        String errorMessage = null;
        Service service = this.getService();
        Integer applicationId = (Integer)request.convert((Object)options.getOptionValue("application", "id"), Integer.class);
        Integer resourceId = (Integer)request.convert((Object)options.getOptionValue(RESOURCE, "id"), Integer.class);
        String resourceName = null;
        try {
            if ("delete".equals(action)) {
                errorMessage = "resource.delete.error";
                resourceName = service.deleteResource(applicationId, resourceId, fp);
            } else if ("update".equals(action)) {
                form.setId(resourceId);
                resourceName = service.updateResource(site, applicationId, form, fp);
            }
        }
        catch (BusinessException ex) {
            String message = request.getMessage(errorMessage, new Object[]{resourceName});
            log.error(message, (Throwable)ex);
            fp.addErrorMessage(message);
        }
    }

    public DataContainer getData(Site site, Application application, Environment environment, Options options, Request request, FieldProcessor fp) {
        Service service = this.getService();
        Integer applicationId = (Integer)request.convert((Object)options.getOptionValue("application", "id"), Integer.class);
        String resourceType = options.getOptionValue(RESOURCE, TYPE);
        Integer resourceId = (Integer)request.convert((Object)options.getOptionValue(RESOURCE, "id"), Integer.class);
        ResourceType type = null;
        if (StringUtils.isNotBlank((CharSequence)resourceType)) {
            type = ResourceType.valueOf((String)resourceType);
        }
        try {
            return service.searchResources(site, fp, type, resourceId, applicationId);
        }
        catch (BusinessException e) {
            throw new ApplicationException("error while loading resources for application", (Throwable)e);
        }
    }
}

