/*
 * Decompiled with CFR 0.152.
 */
package org.appng.application.manager.business;

import org.appng.api.ActionProvider;
import org.appng.api.BusinessException;
import org.appng.api.DataContainer;
import org.appng.api.DataProvider;
import org.appng.api.Environment;
import org.appng.api.FieldProcessor;
import org.appng.api.Options;
import org.appng.api.Request;
import org.appng.api.model.Application;
import org.appng.api.model.Site;
import org.appng.application.manager.form.PackageUploadForm;
import org.appng.application.manager.form.RepositoryForm;
import org.appng.application.manager.service.Service;
import org.appng.application.manager.service.ServiceAware;
import org.appng.forms.FormUpload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Lazy
@Component
@Scope(value="request")
public class Repositories
extends ServiceAware
implements DataProvider,
ActionProvider<RepositoryForm> {
    private static final Logger log = LoggerFactory.getLogger(Repositories.class);
    private static final String UPLOAD = "upload";
    private static final String ACTION_UPLOAD_ARCHIVE = "uploadArchive";
    public static final String REPOSITORY = "repository";

    public void perform(Site site, Application application, Environment environment, Options options, Request request, RepositoryForm repositoryForm, FieldProcessor fp) {
        String action = this.getAction(options);
        String errorMessage = null;
        String okMessage = null;
        Service service = this.getService();
        Integer repositoryId = (Integer)request.convert((Object)options.getOptionValue(REPOSITORY, "id"), Integer.class);
        String archiveName = null;
        try {
            if ("create".equals(action)) {
                errorMessage = "repository.create.error";
                service.createRepository(repositoryForm.getRepository(), fp);
                okMessage = "repository.created";
            } else if ("update".equals(action)) {
                repositoryForm.getRepository().setId(repositoryId);
                errorMessage = "repository.update.error";
                service.updateRepository(repositoryForm, fp);
                okMessage = "repository.updated";
            } else if ("delete".equals(action)) {
                errorMessage = "repository.delete.error";
                service.deleteRepository(repositoryId, fp);
                okMessage = "repository.deleted";
            } else if ("reload".equals(action)) {
                errorMessage = "repository.reload.error";
                service.reloadRepository(repositoryId, fp);
                okMessage = "repository.reloaded";
            } else if (ACTION_UPLOAD_ARCHIVE.equals(action)) {
                errorMessage = "repository.archive.upload.error";
                FormUpload archive = ((PackageUploadForm)repositoryForm).getArchive();
                archiveName = archive.getOriginalFilename();
                service.addArchiveToRepository(repositoryId, archive, fp);
                okMessage = "repository.archive.uploaded";
            }
            String message = request.getMessage(okMessage, new Object[]{repositoryId, archiveName});
            fp.addOkMessage(message);
        }
        catch (BusinessException ex) {
            String message = request.getMessage(errorMessage, new Object[]{repositoryId, archiveName});
            log.error(message, (Throwable)ex);
            fp.addErrorMessage(message);
        }
    }

    public DataContainer getData(Site site, Application application, Environment environment, Options options, Request request, FieldProcessor fp) {
        Service service = this.getService();
        Integer repositoryId = (Integer)request.convert((Object)options.getOptionValue(REPOSITORY, "id"), Integer.class);
        DataContainer data = null;
        if (null == repositoryId && "create".equals(this.getAction(options))) {
            data = service.getNewRepository(fp);
        } else if (UPLOAD.equals(options.getOptionValue(REPOSITORY, "mode"))) {
            data = new DataContainer(fp);
            PackageUploadForm packageUploadForm = new PackageUploadForm();
            packageUploadForm.setRepository(service.getRepository(repositoryId));
            data.setItem((Object)packageUploadForm);
        } else {
            data = service.searchRepositories(fp, repositoryId);
        }
        return data;
    }
}

