/*
 * Decompiled with CFR 0.152.
 */
package org.appng.application.manager.business;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.appng.api.ApplicationException;
import org.appng.api.BusinessException;
import org.appng.api.DataContainer;
import org.appng.api.DataProvider;
import org.appng.api.Environment;
import org.appng.api.FieldProcessor;
import org.appng.api.Options;
import org.appng.api.Request;
import org.appng.api.Scope;
import org.appng.api.model.Application;
import org.appng.api.model.Site;
import org.appng.api.support.SelectionFactory;
import org.appng.application.manager.builder.SelectionBuilder;
import org.appng.application.manager.service.PlatformEventService;
import org.appng.core.domain.PlatformEvent;
import org.appng.forms.RequestContainer;
import org.appng.xml.platform.Selection;
import org.appng.xml.platform.SelectionGroup;
import org.appng.xml.platform.SelectionType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;
import org.springframework.web.context.annotation.RequestScope;

@Service
public class PlatformEvents
implements DataProvider {
    private static final FastDateFormat FDF = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss");
    private PlatformEventService platformEventEventService;
    private EventFilter filter;
    private SelectionFactory selectionFactory;

    @Autowired
    public PlatformEvents(PlatformEventService platformEventEventService, SelectionFactory selectionFactory, EventFilter filter) {
        this.platformEventEventService = platformEventEventService;
        this.filter = filter;
        this.selectionFactory = selectionFactory;
    }

    public DataContainer getData(Site site, Application application, Environment environment, Options options, Request request, FieldProcessor fieldProcessor) {
        SelectionGroup group = new SelectionGroup();
        List selections = group.getSelections();
        Selection typeFilter = (Selection)this.selectionFactory.fromEnum("eT", "type", (Enum[])PlatformEvent.Type.values(), this.filter.eventTypes());
        typeFilter.setType(SelectionType.CHECKBOX);
        selections.add(typeFilter);
        selections.add(this.selectionFactory.getTextSelection("eX", "event", this.filter.getEX()));
        List<String> users = this.platformEventEventService.getUsers();
        Selection userSelection = this.getStringSelection("eU", users, this.filter.getEU(), "user");
        selections.add(userSelection);
        List<String> applications = this.platformEventEventService.getApplications();
        Selection applicationSelection = this.getStringSelection("eAp", applications, this.filter.getEAp(), "application");
        selections.add(applicationSelection);
        List<String> hostNames = this.platformEventEventService.getOrigins();
        Selection hostSelection = this.getStringSelection("eH", hostNames, this.filter.getEH(), "host");
        selections.add(hostSelection);
        List<String> hosts = this.platformEventEventService.getHostNames();
        Selection hostNameSelection = this.getStringSelection("eN", hosts, this.filter.getEN(), "hostName");
        selections.add(hostNameSelection);
        selections.add(this.selectionFactory.getDateSelection("eA", "createdAfter", this.filter.getEA(), FDF));
        selections.add(this.selectionFactory.getDateSelection("eB", "createdBefore", this.filter.getEB(), FDF));
        DataContainer dataContainer = new DataContainer(fieldProcessor);
        dataContainer.getSelectionGroups().add(group);
        environment.setAttribute(Scope.SESSION, "eventFilter", (Object)this.filter.copy());
        Page<PlatformEvent> events = this.platformEventEventService.getEvents(fieldProcessor.getPageable(), this.filter);
        dataContainer.setPage(events);
        return dataContainer;
    }

    private Selection getStringSelection(String id, List<String> values, String selected, String label) {
        SelectionBuilder builder = new SelectionBuilder(id);
        return ((SelectionBuilder)((SelectionBuilder)((SelectionBuilder)builder.label(label).options(values)).select(selected)).type(SelectionType.SELECT).defaultOption("", "")).build();
    }

    @Component(value="eventFilter")
    @RequestScope(proxyMode=ScopedProxyMode.TARGET_CLASS)
    public static class EventFilter
    implements DataProvider,
    Serializable {
        private Date eB;
        private Date eA;
        private String eX;
        private String eU;
        private String eH;
        private String eN;
        private String eAp;
        private List<String> eT = new ArrayList<String>();

        public DataContainer getData(Site site, Application application, Environment environment, Options options, Request request, FieldProcessor fp) {
            try {
                request.fillBindObject((Object)this, fp, (RequestContainer)request, (ClassLoader)site.getSiteClassLoader());
                DataContainer dataContainer = new DataContainer(fp);
                dataContainer.setItem((Object)this);
                return dataContainer;
            }
            catch (BusinessException e) {
                throw new ApplicationException("error filling filter", (Throwable)e);
            }
        }

        public EventFilter copy() {
            EventFilter copy = new EventFilter();
            copy.setEA(this.eA);
            copy.setEB(this.eB);
            copy.setEH(this.eH);
            copy.setEN(this.eN);
            copy.setET(this.eT);
            copy.setEU(this.eU);
            copy.setEX(this.eX);
            return copy;
        }

        public List<PlatformEvent.Type> eventTypes() {
            return this.eT.stream().filter(t -> StringUtils.isNotBlank((CharSequence)t)).map(t -> PlatformEvent.Type.valueOf((String)t)).collect(Collectors.toList());
        }

        public Date getEB() {
            return this.eB;
        }

        public Date getEA() {
            return this.eA;
        }

        public String getEX() {
            return this.eX;
        }

        public String getEU() {
            return this.eU;
        }

        public String getEH() {
            return this.eH;
        }

        public String getEN() {
            return this.eN;
        }

        public String getEAp() {
            return this.eAp;
        }

        public List<String> getET() {
            return this.eT;
        }

        public void setEB(Date eB) {
            this.eB = eB;
        }

        public void setEA(Date eA) {
            this.eA = eA;
        }

        public void setEX(String eX) {
            this.eX = eX;
        }

        public void setEU(String eU) {
            this.eU = eU;
        }

        public void setEH(String eH) {
            this.eH = eH;
        }

        public void setEN(String eN) {
            this.eN = eN;
        }

        public void setEAp(String eAp) {
            this.eAp = eAp;
        }

        public void setET(List<String> eT) {
            this.eT = eT;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EventFilter)) {
                return false;
            }
            EventFilter other = (EventFilter)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Date this$eB = this.getEB();
            Date other$eB = other.getEB();
            if (this$eB == null ? other$eB != null : !((Object)this$eB).equals(other$eB)) {
                return false;
            }
            Date this$eA = this.getEA();
            Date other$eA = other.getEA();
            if (this$eA == null ? other$eA != null : !((Object)this$eA).equals(other$eA)) {
                return false;
            }
            String this$eX = this.getEX();
            String other$eX = other.getEX();
            if (this$eX == null ? other$eX != null : !this$eX.equals(other$eX)) {
                return false;
            }
            String this$eU = this.getEU();
            String other$eU = other.getEU();
            if (this$eU == null ? other$eU != null : !this$eU.equals(other$eU)) {
                return false;
            }
            String this$eH = this.getEH();
            String other$eH = other.getEH();
            if (this$eH == null ? other$eH != null : !this$eH.equals(other$eH)) {
                return false;
            }
            String this$eN = this.getEN();
            String other$eN = other.getEN();
            if (this$eN == null ? other$eN != null : !this$eN.equals(other$eN)) {
                return false;
            }
            String this$eAp = this.getEAp();
            String other$eAp = other.getEAp();
            if (this$eAp == null ? other$eAp != null : !this$eAp.equals(other$eAp)) {
                return false;
            }
            List<String> this$eT = this.getET();
            List<String> other$eT = other.getET();
            return !(this$eT == null ? other$eT != null : !((Object)this$eT).equals(other$eT));
        }

        protected boolean canEqual(Object other) {
            return other instanceof EventFilter;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Date $eB = this.getEB();
            result = result * 59 + ($eB == null ? 43 : ((Object)$eB).hashCode());
            Date $eA = this.getEA();
            result = result * 59 + ($eA == null ? 43 : ((Object)$eA).hashCode());
            String $eX = this.getEX();
            result = result * 59 + ($eX == null ? 43 : $eX.hashCode());
            String $eU = this.getEU();
            result = result * 59 + ($eU == null ? 43 : $eU.hashCode());
            String $eH = this.getEH();
            result = result * 59 + ($eH == null ? 43 : $eH.hashCode());
            String $eN = this.getEN();
            result = result * 59 + ($eN == null ? 43 : $eN.hashCode());
            String $eAp = this.getEAp();
            result = result * 59 + ($eAp == null ? 43 : $eAp.hashCode());
            List<String> $eT = this.getET();
            result = result * 59 + ($eT == null ? 43 : ((Object)$eT).hashCode());
            return result;
        }

        public String toString() {
            return "PlatformEvents.EventFilter(eB=" + this.getEB() + ", eA=" + this.getEA() + ", eX=" + this.getEX() + ", eU=" + this.getEU() + ", eH=" + this.getEH() + ", eN=" + this.getEN() + ", eAp=" + this.getEAp() + ", eT=" + this.getET() + ")";
        }
    }
}

