/*
 * Decompiled with CFR 0.152.
 */
package org.appng.application.manager.business;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.PropertyConfigurator;
import org.appng.api.BusinessException;
import org.appng.api.Environment;
import org.appng.api.InvalidConfigurationException;
import org.appng.api.Scope;
import org.appng.api.messaging.Event;
import org.appng.api.model.Properties;
import org.appng.api.model.Site;

public class LogConfigChangedEvent
extends Event
implements Serializable {
    private final String content;

    public LogConfigChangedEvent(String siteName, String content, String configFilePath) {
        super(siteName);
        this.content = content;
    }

    public void perform(Environment environment, Site site) throws InvalidConfigurationException, BusinessException {
        try {
            Properties platformProps = (Properties)environment.getAttribute(Scope.PLATFORM, "platformConfig");
            String rootPath = platformProps.getString("platformRootPath");
            File configFilePath = new File(rootPath, "WEB-INF/conf/log4j.properties");
            FileUtils.write((File)configFilePath, (CharSequence)this.content, (Charset)StandardCharsets.UTF_8);
            new PropertyConfigurator().doConfigure(configFilePath.getAbsolutePath(), LogManager.getLoggerRepository());
        }
        catch (IOException e) {
            throw new BusinessException("error while executing ReadloadConfigEvent", (Throwable)e);
        }
    }
}

