/*
 * Decompiled with CFR 0.152.
 */
package org.appng.application.manager.business;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.appng.api.DataContainer;
import org.appng.api.DataProvider;
import org.appng.api.Environment;
import org.appng.api.FieldProcessor;
import org.appng.api.Options;
import org.appng.api.Request;
import org.appng.api.model.Application;
import org.appng.api.model.Site;
import org.appng.application.manager.service.ServiceAware;
import org.appng.core.model.JarInfo;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Lazy
@Component
@Scope(value="request")
public class Jars
extends ServiceAware
implements DataProvider {
    public DataContainer getData(Site site, Application application, Environment environment, Options options, Request request, FieldProcessor fp) {
        List<Object> jars;
        Integer siteId = (Integer)request.convert((Object)options.getOptionValue("site", "id"), Integer.class);
        DataContainer data = new DataContainer(fp);
        if (null == options.getOptionValue("tomcatJars", "show")) {
            jars = this.getService().getJars(environment, siteId);
        } else {
            jars = new ArrayList();
            File baseFolder = new File(System.getProperty("catalina.base"), "lib");
            File homeFolder = new File(System.getProperty("catalina.home"), "lib");
            FilenameFilter jarFilter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".jar");
                }
            };
            for (String jarfile : baseFolder.list(jarFilter)) {
                jars.add(JarInfo.JarInfoBuilder.getJarInfo((File)new File(baseFolder, jarfile)));
            }
            if (!baseFolder.equals(homeFolder)) {
                for (String jarfile : homeFolder.list(jarFilter)) {
                    jars.add(JarInfo.JarInfoBuilder.getJarInfo((File)new File(homeFolder, jarfile)));
                }
            }
            Collections.sort(jars);
        }
        data.setPage(jars, fp.getPageable());
        return data;
    }
}

