/*
 * Decompiled with CFR 0.152.
 */
package org.appng.application.manager.business;

import java.util.List;
import java.util.Set;
import org.appng.api.ActionProvider;
import org.appng.api.DataContainer;
import org.appng.api.DataProvider;
import org.appng.api.Environment;
import org.appng.api.FieldProcessor;
import org.appng.api.Options;
import org.appng.api.Request;
import org.appng.api.model.Application;
import org.appng.api.model.Site;
import org.appng.application.manager.form.GrantForm;
import org.appng.application.manager.service.ServiceAware;
import org.appng.core.domain.SiteApplication;
import org.appng.xml.platform.Selection;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Lazy
@Component
@Scope(value="request")
public class GrantSites
extends ServiceAware
implements ActionProvider<GrantForm>,
DataProvider {
    private static final String APPLICATION_ID = "applicationId";
    private static final String SITE_ID = "siteId";
    private static final String IDS = "ids";

    public DataContainer getData(Site site, Application application, Environment environment, Options options, Request request, FieldProcessor fieldProcessor) {
        boolean showGrantedBy;
        DataContainer dataContainer = new DataContainer(fieldProcessor);
        Integer siteId = (Integer)request.convert((Object)options.getOptionValue(IDS, SITE_ID), Integer.class);
        Integer applicationId = (Integer)request.convert((Object)options.getOptionValue(IDS, APPLICATION_ID), Integer.class);
        SiteApplication siteApplication = this.getService().getSiteApplication(siteId, applicationId);
        List<Selection> siteSelections = this.getService().getGrantedSelections(siteId, applicationId);
        GrantForm grantForm = new GrantForm(siteApplication);
        boolean bl = showGrantedBy = siteSelections.get(1).getOptions().size() > 0;
        if (!showGrantedBy) {
            siteSelections.remove(1);
        }
        grantForm.setShowGrantedBy(showGrantedBy);
        dataContainer.getSelections().addAll(siteSelections);
        dataContainer.setItem((Object)grantForm);
        return dataContainer;
    }

    public void perform(Site site, Application application, Environment environment, Options options, Request request, GrantForm grantForm, FieldProcessor fieldProcessor) {
        Integer siteId = (Integer)request.convert((Object)options.getOptionValue(IDS, SITE_ID), Integer.class);
        Integer applicationId = (Integer)request.convert((Object)options.getOptionValue(IDS, APPLICATION_ID), Integer.class);
        Set<Integer> grantedSiteIds = grantForm.getGrantedSiteIds();
        this.getService().grantSites(siteId, applicationId, grantedSiteIds);
    }
}

