/*
 * Decompiled with CFR 0.152.
 */
package org.appng.application.manager.business;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.TreeSet;
import org.appng.api.DataContainer;
import org.appng.api.DataProvider;
import org.appng.api.Environment;
import org.appng.api.FieldProcessor;
import org.appng.api.Options;
import org.appng.api.Request;
import org.appng.api.model.Application;
import org.appng.api.model.Property;
import org.appng.api.model.Site;
import org.appng.application.manager.service.ServiceAware;
import org.appng.core.domain.PropertyImpl;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Component;

@Lazy
@Component
@Scope(value="request")
public class Dictionary
extends ServiceAware
implements DataProvider {
    private static final String MESSAGES_CORE = "messages-core";

    public DataContainer getData(Site site, Application application, Environment environment, Options options, Request request, FieldProcessor fp) {
        ResourceBundle bundle = null;
        ArrayList<Property> properties = new ArrayList<Property>();
        Integer applicationId = (Integer)request.convert((Object)options.getOptionValue("application", "id"), Integer.class);
        Locale locale = environment.getLocale();
        if (null != applicationId) {
            ResourceBundleMessageSource resourceBundleMessageSource = this.getBundleForApplication(site, environment, applicationId);
        } else {
            ClassLoader parent = site.getSiteClassLoader().getParent();
            bundle = ResourceBundle.getBundle(MESSAGES_CORE, locale, parent);
            properties.addAll(this.getPropertiesFromBundle(bundle));
        }
        DataContainer data = new DataContainer(fp);
        data.setPage(properties, fp.getPageable());
        return data;
    }

    private ResourceBundleMessageSource getBundleForApplication(Site site, Environment environment, Integer applicationId) {
        for (Application p : site.getApplications()) {
            if (!((Integer)p.getId()).equals(applicationId)) continue;
            return (ResourceBundleMessageSource)p.getBean(ResourceBundleMessageSource.class);
        }
        return null;
    }

    private Collection<Property> getPropertiesFromBundle(ResourceBundle bundle) {
        TreeSet<Property> properties = new TreeSet<Property>();
        if (null != bundle) {
            Enumeration<String> keys = bundle.getKeys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                properties.add((Property)new PropertyImpl(key, bundle.getString(key)));
            }
        }
        return properties;
    }
}

