/*
 * Decompiled with CFR 0.152.
 */
package org.appng.application.manager.business;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.appng.api.ActionProvider;
import org.appng.api.DataContainer;
import org.appng.api.DataProvider;
import org.appng.api.Environment;
import org.appng.api.FieldProcessor;
import org.appng.api.Options;
import org.appng.api.Request;
import org.appng.api.model.Application;
import org.appng.api.model.Site;
import org.appng.application.manager.service.ServiceAware;
import org.appng.core.domain.DatabaseConnection;
import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.api.MigrationInfoService;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Component;

@Lazy
@Component
@Scope(value="request")
public class DatabaseConnections
extends ServiceAware
implements DataProvider,
ActionProvider<DatabaseConnection> {
    private static final String ACTION_DELETE = "delete";
    private static final String ACTION_RESET = "reset";
    private static final String ACTION_TEST = "test";
    private static final String OPT_CONNECTION = "connection";
    private static final String OPT_SITE = "site";

    public void perform(Site site, Application application, Environment environment, Options options, Request request, DatabaseConnection databaseConnection, FieldProcessor fp) {
        String action = options.getOptionValue("action", "id");
        Integer conId = (Integer)request.convert((Object)options.getOptionValue(OPT_CONNECTION, "id"), Integer.class);
        if ("update".equals(action)) {
            databaseConnection.setId(conId);
            this.getService().updateDatabaseConnection(fp, databaseConnection);
        } else if (ACTION_DELETE.equals(action)) {
            this.getService().deleteDatabaseConnection(fp, conId);
        } else if (ACTION_TEST.equals(action)) {
            this.getService().testConnection(fp, conId);
        } else if (ACTION_RESET.equals(action)) {
            this.getService().resetConnection(conId);
        }
    }

    public DataContainer getData(Site site, Application application, Environment environment, Options options, Request request, FieldProcessor fp) {
        Integer dcId = options.getInteger("id", "id");
        Integer siteId = options.getInteger(OPT_SITE, "id");
        DataContainer dataContainer = new DataContainer(fp);
        if (null == dcId) {
            Page<DatabaseConnection> connections = this.getService().getDatabaseConnections(siteId, fp);
            dataContainer.setPage(connections);
        } else if ("migrations".equals(options.getString("id", "mode"))) {
            DatabaseConnection databaseConnection = this.getService().getDatabaseConnection(dcId, true);
            MigrationInfoService migrationInfoService = databaseConnection.getMigrationInfoService();
            if (null != migrationInfoService) {
                List<MigrationInfo> migrations = Arrays.asList(migrationInfoService.all());
                dataContainer.setItems(migrations);
            } else {
                dataContainer.setItems(new ArrayList());
            }
        } else {
            DatabaseConnection connection = this.getService().getDatabaseConnection(dcId, true);
            dataContainer.setItem((Object)connection);
        }
        return dataContainer;
    }
}

