/*
 * Decompiled with CFR 0.152.
 */
package org.appng.application.manager.business;

import java.beans.ConstructorProperties;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.appng.api.ActionProvider;
import org.appng.api.DataContainer;
import org.appng.api.DataProvider;
import org.appng.api.FieldProcessor;
import org.appng.api.Options;
import org.appng.api.Request;
import org.appng.api.messaging.Event;
import org.appng.api.messaging.Messaging;
import org.appng.api.model.Application;
import org.appng.api.model.Site;
import org.appng.application.manager.business.Environment;
import org.appng.core.controller.messaging.NodeEvent;
import org.appng.core.controller.messaging.RequestNodeState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service
@Scope(value="request")
public class ClusterState
implements DataProvider,
ActionProvider<Void> {
    private static final Logger log = LoggerFactory.getLogger(ClusterState.class);

    public DataContainer getData(Site site, Application application, org.appng.api.Environment environment, Options options, Request request, FieldProcessor fieldProcessor) {
        NodeEvent.NodeState nodeState;
        boolean clusterAvailable;
        LocalNodeState localNode;
        DataContainer dataContainer = new DataContainer(fieldProcessor);
        String mode = options.getOptionValue("mode", "value");
        String nodeId = options.getOptionValue("mode", "nodeId");
        Map nodeStates = (Map)environment.getAttribute(org.appng.api.Scope.PLATFORM, "nodeState");
        LocalNodeState currentNode = localNode = this.getLocalNode(site, environment);
        HashSet<LocalNodeState> items = new HashSet<LocalNodeState>();
        items.add(localNode);
        boolean bl = clusterAvailable = null != nodeStates;
        if (!clusterAvailable) {
            if (Messaging.isEnabled((org.appng.api.Environment)environment)) {
                fieldProcessor.addErrorMessage(request.getMessage("cluster.notAvailable", new Object[0]));
            } else {
                fieldProcessor.addNoticeMessage(request.getMessage("cluster.disabled", new Object[0]));
            }
        } else if (StringUtils.isNotBlank((CharSequence)nodeId) && null != (nodeState = (NodeEvent.NodeState)nodeStates.get(nodeId))) {
            currentNode = new LocalNodeState(nodeState);
        }
        if (StringUtils.isBlank((CharSequence)mode)) {
            if (clusterAvailable) {
                nodeStates.values().forEach(ns -> items.add(new LocalNodeState((NodeEvent.NodeState)ns)));
            }
            dataContainer.setPage(items, fieldProcessor.getPageable());
        } else if (null != currentNode) {
            Map<Object, Object> entries = null;
            if ("props".equals(mode)) {
                entries = currentNode.getProps();
            } else if ("env".equals(mode)) {
                entries = currentNode.getEnv();
            } else if ("siteState".equals(mode)) {
                entries = currentNode.getSiteStates();
            }
            List<Object> sortedEntries = null == entries ? new ArrayList() : Environment.getSortedEntries(entries);
            dataContainer.setPage(sortedEntries, fieldProcessor.getPageable());
        }
        return dataContainer;
    }

    private LocalNodeState getLocalNode(Site site, org.appng.api.Environment environment) {
        NodeEvent nodeEvent = new NodeEvent(environment, site.getName());
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        NodeEvent nodeEvent2 = nodeEvent;
        nodeEvent2.getClass();
        NodeEvent.MemoryUsage heap = new NodeEvent.MemoryUsage(nodeEvent2, memoryMXBean.getHeapMemoryUsage());
        NodeEvent nodeEvent3 = nodeEvent;
        nodeEvent3.getClass();
        NodeEvent.MemoryUsage nonHeap = new NodeEvent.MemoryUsage(nodeEvent3, memoryMXBean.getNonHeapMemoryUsage());
        Map siteStates = (Map)environment.getAttribute(org.appng.api.Scope.PLATFORM, "siteState");
        LocalNodeState localNode = new LocalNodeState(Messaging.getNodeId((org.appng.api.Environment)environment), new Date(), heap, nonHeap, System.getProperties(), System.getenv(), siteStates);
        if (log.isDebugEnabled()) {
            log.debug("local node is {}", (Object)localNode);
        }
        localNode.setCurrent(true);
        return localNode;
    }

    public void perform(Site site, Application application, org.appng.api.Environment environment, Options options, Request request, Void formBean, FieldProcessor fieldProcessor) {
        site.sendEvent((Event)new RequestNodeState(site.getName()));
    }

    public class LocalNodeState {
        private final String nodeId;
        private final Date date;
        private final NodeEvent.MemoryUsage heap;
        private final NodeEvent.MemoryUsage nonHeap;
        private final Properties props;
        private final Map<String, String> env;
        private final Map<String, Site.SiteState> siteStates;
        private boolean current = false;

        public LocalNodeState(NodeEvent.NodeState nodeState) {
            this(nodeState.getNodeId(), nodeState.getDate(), nodeState.getHeap(), nodeState.getNonHeap(), nodeState.getProps(), nodeState.getEnv(), nodeState.getSiteStates());
        }

        public String getNodeId() {
            return this.nodeId;
        }

        public Date getDate() {
            return this.date;
        }

        public NodeEvent.MemoryUsage getHeap() {
            return this.heap;
        }

        public NodeEvent.MemoryUsage getNonHeap() {
            return this.nonHeap;
        }

        public Properties getProps() {
            return this.props;
        }

        public Map<String, String> getEnv() {
            return this.env;
        }

        public Map<String, Site.SiteState> getSiteStates() {
            return this.siteStates;
        }

        public boolean isCurrent() {
            return this.current;
        }

        public void setCurrent(boolean current) {
            this.current = current;
        }

        public String toString() {
            return "ClusterState.LocalNodeState(nodeId=" + this.getNodeId() + ", date=" + this.getDate() + ", heap=" + this.getHeap() + ", nonHeap=" + this.getNonHeap() + ", props=" + this.getProps() + ", env=" + this.getEnv() + ", siteStates=" + this.getSiteStates() + ", current=" + this.isCurrent() + ")";
        }

        @ConstructorProperties(value={"nodeId", "date", "heap", "nonHeap", "props", "env", "siteStates"})
        public LocalNodeState(String nodeId, Date date, NodeEvent.MemoryUsage heap, NodeEvent.MemoryUsage nonHeap, Properties props, Map<String, String> env, Map<String, Site.SiteState> siteStates) {
            this.nodeId = nodeId;
            this.date = date;
            this.heap = heap;
            this.nonHeap = nonHeap;
            this.props = props;
            this.env = env;
            this.siteStates = siteStates;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LocalNodeState)) {
                return false;
            }
            LocalNodeState other = (LocalNodeState)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$nodeId = this.getNodeId();
            String other$nodeId = other.getNodeId();
            return !(this$nodeId == null ? other$nodeId != null : !this$nodeId.equals(other$nodeId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof LocalNodeState;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $nodeId = this.getNodeId();
            result = result * 59 + ($nodeId == null ? 43 : $nodeId.hashCode());
            return result;
        }
    }
}

