/*
 * Decompiled with CFR 0.152.
 */
package org.appng.application.manager.business;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.lang3.StringUtils;
import org.appng.api.ActionProvider;
import org.appng.api.DataContainer;
import org.appng.api.DataProvider;
import org.appng.api.Environment;
import org.appng.api.FieldProcessor;
import org.appng.api.Options;
import org.appng.api.Request;
import org.appng.api.model.Application;
import org.appng.api.model.Site;
import org.appng.api.support.SelectionFactory;
import org.appng.application.manager.service.ServiceAware;
import org.appng.core.controller.AppngCache;
import org.appng.xml.platform.SelectionGroup;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Lazy
@Component
@Scope(value="request")
public class Cache
extends ServiceAware
implements ActionProvider<Void>,
DataProvider {
    private static final String F_ETR = "fEtr";
    private static final String F_CTYPE = "fCtpe";
    private static final String STATISTICS = "statistics";
    private static final String ENTRIES = "entries";
    private static final String ACTION_EXPIRE_CACHE_ELEMENT = "expireCacheElement";
    private static final String ACTION_CLEAR_CACHE_STATISTICS = "clearCacheStatistics";
    private static final String ACTION_CLEAR_CACHE = "clearCache";
    @Autowired
    private SelectionFactory selectionFactory;

    public DataContainer getData(Site site, Application application, Environment environment, Options options, Request request, FieldProcessor fieldProcessor) {
        String mode = options.getOptionValue("mode", "id");
        Integer siteId = (Integer)request.convert((Object)options.getOptionValue("site", "id"), Integer.class);
        DataContainer dataContainer = new DataContainer(fieldProcessor);
        if (STATISTICS.equals(mode)) {
            ArrayList<Map.Entry<String, String>> result = new ArrayList<Map.Entry<String, String>>();
            Map<String, String> cacheStatistics = this.getService().getCacheStatistics(siteId);
            for (Map.Entry<String, String> e : cacheStatistics.entrySet()) {
                result.add(e);
            }
            Collections.sort(result, new Comparator<Map.Entry<String, String>>(){

                @Override
                public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
                    return o1.getKey().compareTo(o2.getKey());
                }
            });
            dataContainer.setPage(result, fieldProcessor.getPageable());
        } else if (ENTRIES.equals(mode)) {
            List<AppngCache> allCacheEntries = this.getService().getCacheEntries(siteId);
            ArrayList<CacheEntry> cacheEntries = new ArrayList<CacheEntry>();
            String entryName = request.getParameter(F_ETR);
            String entryType = request.getParameter(F_CTYPE);
            boolean filterName = StringUtils.isNotBlank((CharSequence)entryName);
            boolean filterType = StringUtils.isNotBlank((CharSequence)entryType);
            for (AppngCache entry : allCacheEntries) {
                boolean typeMatches;
                String entryId = entry.getId();
                boolean nameMatches = !filterName || FilenameUtils.wildcardMatch((String)entryId.substring(entryId.indexOf(47)), (String)entryName, (IOCase)IOCase.INSENSITIVE);
                boolean bl = typeMatches = !filterType || FilenameUtils.wildcardMatch((String)entry.getContentType(), (String)entryType, (IOCase)IOCase.INSENSITIVE);
                if (!nameMatches || !typeMatches) continue;
                cacheEntries.add(new CacheEntry(entry));
            }
            SelectionFactory.Selection nameSelection = this.selectionFactory.getTextSelection(F_ETR, "name", entryName);
            SelectionFactory.Selection typeSelection = this.selectionFactory.getTextSelection(F_CTYPE, "type", entryType);
            SelectionGroup selectionGroup = new SelectionGroup();
            selectionGroup.getSelections().add(nameSelection);
            selectionGroup.getSelections().add(typeSelection);
            dataContainer.getSelectionGroups().add(selectionGroup);
            dataContainer.setPage(cacheEntries, fieldProcessor.getPageable());
        }
        return dataContainer;
    }

    public void perform(Site site, Application application, Environment environment, Options options, Request request, Void formBean, FieldProcessor fieldProcessor) {
        String action = this.getAction(options);
        if (ACTION_EXPIRE_CACHE_ELEMENT.equals(action)) {
            String cacheElement = options.getOptionValue("cacheElement", "id");
            Integer siteId = (Integer)request.convert((Object)options.getOptionValue("site", "id"), Integer.class);
            this.getService().expireCacheElement(fieldProcessor, request, siteId, cacheElement);
        } else if (ACTION_CLEAR_CACHE_STATISTICS.equals(action)) {
            Integer siteId = (Integer)request.convert((Object)options.getOptionValue("site", "id"), Integer.class);
            this.getService().clearCacheStatistics(fieldProcessor, request, siteId);
        } else if (ACTION_CLEAR_CACHE.equals(action)) {
            Integer siteId = (Integer)request.convert((Object)options.getOptionValue("site", "id"), Integer.class);
            this.getService().clearCache(fieldProcessor, request, siteId);
        }
    }

    public class CacheEntry {
        private AppngCache appngCache;

        public CacheEntry(AppngCache appngCache) {
            this.appngCache = appngCache;
        }

        public String getPath() {
            return this.appngCache.getDomain() + this.getId().substring(this.getId().indexOf(47));
        }

        public String getType() {
            String contentType = this.appngCache.getContentType();
            if (null == contentType) {
                return "<unknown>";
            }
            int idx = contentType.indexOf(59);
            return idx > 0 ? contentType.substring(0, idx) : contentType;
        }

        public String getId() {
            return this.appngCache.getId();
        }

        public long getHits() {
            return this.appngCache.getHitCount();
        }

        public Date getCreated() {
            return this.appngCache.getCreatedOrUpdated();
        }

        public Date getExpires() {
            return this.appngCache.getExpirationTime();
        }

        public double getSize() {
            return (double)this.appngCache.getContentLength() / 1024.0;
        }
    }
}

