/*
 * Decompiled with CFR 0.152.
 */
package org.appng.application.manager.business;

import java.util.Collection;
import java.util.TreeSet;
import org.appng.api.ActionProvider;
import org.appng.api.AttachmentWebservice;
import org.appng.api.DataContainer;
import org.appng.api.DataProvider;
import org.appng.api.Environment;
import org.appng.api.FieldProcessor;
import org.appng.api.GlobalTaglet;
import org.appng.api.Options;
import org.appng.api.Request;
import org.appng.api.RequestUtil;
import org.appng.api.Taglet;
import org.appng.api.Webservice;
import org.appng.api.XMLTaglet;
import org.appng.api.model.Application;
import org.appng.api.model.Site;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Lazy
@Component
@Scope(value="request")
public class Beans
implements DataProvider {
    public DataContainer getData(Site site, Application app, Environment env, Options opts, Request req, FieldProcessor fp) {
        Application application;
        String siteName = opts.getOptionValue("application", "siteName");
        String applicationName = opts.getOptionValue("application", "appName");
        Site selectedSite = RequestUtil.getSiteByName((Environment)env, (String)siteName);
        TreeSet<BeanInfo> beanInfos = new TreeSet<BeanInfo>();
        if (null != selectedSite && null != (application = selectedSite.getApplication(applicationName))) {
            this.addBeans(application, ActionProvider.class, beanInfos);
            this.addBeans(application, DataProvider.class, beanInfos);
            this.addBeans(application, Webservice.class, beanInfos);
            this.addBeans(application, AttachmentWebservice.class, beanInfos);
            this.addBeans(application, Taglet.class, beanInfos);
            this.addBeans(application, GlobalTaglet.class, beanInfos);
            this.addBeans(application, XMLTaglet.class, beanInfos);
        }
        DataContainer dataContainer = new DataContainer(fp);
        dataContainer.setItems(beanInfos);
        return dataContainer;
    }

    private void addBeans(Application application, Class<?> type, Collection<BeanInfo> beanInfos) {
        String[] names;
        for (String name : names = application.getBeanNames(type)) {
            Object bean = application.getBean(name, type);
            if (null == bean) continue;
            beanInfos.add(new BeanInfo(name, bean.getClass()));
        }
    }

    public class BeanInfo
    implements Comparable<BeanInfo> {
        private String name;
        private Class<?> type;

        public BeanInfo(String name, Class<?> type) {
            this.name = name;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Class<?> getType() {
            return this.type;
        }

        public void setType(Class<?> type) {
            this.type = type;
        }

        public String getInterfaces() {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            Class<?>[] interfaces = this.type.getInterfaces();
            if (interfaces.length == 0) {
                Class<?> superclass = this.type.getSuperclass();
                interfaces = superclass.getInterfaces();
            }
            for (Class<?> c : interfaces) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(c.getSimpleName());
                ++i;
            }
            return sb.toString();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BeanInfo other = (BeanInfo)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.type == null ? other.type != null : !this.type.equals(other.type));
        }

        private Beans getOuterType() {
            return Beans.this;
        }

        @Override
        public int compareTo(BeanInfo o) {
            return this.getName().compareTo(o.getName());
        }
    }
}

