/*
 * Decompiled with CFR 0.152.
 */
package org.appng.application.manager.business;

import org.appng.api.ActionProvider;
import org.appng.api.BusinessException;
import org.appng.api.DataContainer;
import org.appng.api.DataProvider;
import org.appng.api.Environment;
import org.appng.api.FieldProcessor;
import org.appng.api.Options;
import org.appng.api.Request;
import org.appng.api.model.Application;
import org.appng.api.model.Site;
import org.appng.application.manager.service.Service;
import org.appng.application.manager.service.ServiceAware;
import org.appng.core.domain.ApplicationImpl;
import org.appng.core.service.MigrationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Lazy
@Component
@Scope(value="request")
public class Applications
extends ServiceAware
implements DataProvider,
ActionProvider<ApplicationImpl> {
    private static final Logger log = LoggerFactory.getLogger(Applications.class);
    private static final String FORM_ACTION = "form_action";
    private static final String DEACTIVATE_APPLICATION = "deactivateApplication";
    private static final String ACTIVATE_APPLICATION = "activateApplication";
    private static final String ACTION_CONFIGURE_APPLICATION = "configure-application";
    private static final String SITE = "site";

    public void perform(Site site, Application application, Environment environment, Options options, Request request, ApplicationImpl applicationBean, FieldProcessor fp) {
        String action = this.getAction(options);
        String errorMessage = null;
        String okMessage = null;
        Service service = this.getService();
        Integer applicationId = (Integer)request.convert((Object)options.getOptionValue("application", "id"), Integer.class);
        try {
            if ("update".equals(action)) {
                applicationBean.setId(applicationId);
                errorMessage = "application.update.error";
                service.updateApplication(environment, (Application)applicationBean, fp);
                okMessage = "application.updated";
            } else if ("delete".equals(action)) {
                errorMessage = "application.delete.error";
                service.deleteApplication(applicationId, fp);
                okMessage = "application.deleted";
            } else if (ACTION_CONFIGURE_APPLICATION.equals(action)) {
                MigrationService.MigrationStatus migrationStatus = null;
                Integer siteId = (Integer)request.convert((Object)options.getOptionValue(SITE, "id"), Integer.class);
                String formAction = options.getOptionValue("action", FORM_ACTION);
                if (ACTIVATE_APPLICATION.equals(formAction)) {
                    errorMessage = "application.update.error";
                    migrationStatus = service.assignApplicationToSite(siteId, applicationId, fp);
                    okMessage = "application.activated";
                } else if (DEACTIVATE_APPLICATION.equals(formAction)) {
                    errorMessage = "application.update.error";
                    migrationStatus = service.removeApplicationFromSite(siteId, applicationId, fp);
                    okMessage = "application.deactivated";
                }
                if (migrationStatus.isErroneous()) {
                    okMessage = null;
                } else {
                    String reloadMessage = request.getMessage("reloadSite", new Object[0]);
                    fp.addNoticeMessage(reloadMessage);
                }
            }
            if (null != okMessage) {
                String message = request.getMessage(okMessage, new Object[]{applicationId});
                fp.addOkMessage(message);
            }
        }
        catch (BusinessException ex) {
            String message = request.getMessage(errorMessage, new Object[]{applicationId});
            log.error(message, (Throwable)ex);
            fp.addErrorMessage(message);
        }
    }

    public DataContainer getData(Site site, Application application, Environment environment, Options options, Request request, FieldProcessor fp) {
        Service service = this.getService();
        Integer applicationId = (Integer)request.convert((Object)options.getOptionValue("application", "id"), Integer.class);
        Integer siteId = (Integer)request.convert((Object)options.getOptionValue(SITE, "id"), Integer.class);
        DataContainer data = null;
        try {
            boolean assignedOnly = "select".equals(options.getOptionValue(SITE, "mode"));
            data = service.searchApplications(fp, siteId, applicationId, assignedOnly);
        }
        catch (BusinessException be) {
            String message = request.getMessage(be.getMessageKey(), be.getMessageArgs());
            log.error(message, (Throwable)be);
            fp.addErrorMessage(message);
        }
        return data;
    }
}

