/*
 * Decompiled with CFR 0.152.
 */
package org.appng.application.manager;

import com.google.common.net.MediaType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.appng.api.ScheduledJob;
import org.appng.api.model.Application;
import org.appng.api.model.Properties;
import org.appng.api.model.Site;
import org.appng.application.manager.business.PlatformEvents;
import org.appng.application.manager.business.webservice.PlatformEventExport;
import org.appng.application.manager.service.PlatformEventService;
import org.appng.core.domain.PlatformEvent;
import org.appng.mail.Mail;
import org.appng.mail.MailTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;

public class PlatformEventReportJob
implements ScheduledJob {
    private static final Logger log = LoggerFactory.getLogger(PlatformEventReportJob.class);
    private static final int MINUS_1 = -1;
    private static final String INTERVAL = "interval";
    private String description;
    private Map<String, Object> jobDataMap;
    private MailTransport mailTransport;
    private PlatformEventService service;
    private MessageSource messageSource;
    private Interval interval = Interval.DAY;

    @Autowired
    public PlatformEventReportJob(PlatformEventService service, MailTransport mailTransport, MessageSource messageSource) {
        this.mailTransport = mailTransport;
        this.service = service;
        this.messageSource = messageSource;
    }

    public void execute(Site site, Application application) throws Exception {
        Mail mail = this.mailTransport.createMail();
        Properties properties = application.getProperties();
        List receivers = properties.getList("eventReportReceivers", ";");
        if (!receivers.isEmpty()) {
            receivers.forEach(r -> mail.addReceiver(StringUtils.trim((String)r), Mail.RecipientType.TO));
            mail.setSubject(properties.getString("eventReportSubject"));
            mail.setFrom(properties.getString("eventReportSender"));
            mail.setTextContent(properties.getString("eventReportText"));
            PlatformEvents.EventFilter eventFilter = new PlatformEvents.EventFilter();
            String eventTypes = properties.getString("eventReportTypes");
            if (null != eventTypes) {
                Arrays.asList(eventTypes.split(" ")).forEach(t -> eventFilter.getET().add((String)t));
            }
            if (this.jobDataMap.containsKey(INTERVAL)) {
                this.interval = Interval.valueOf((String)this.jobDataMap.get(INTERVAL));
            }
            Date createdAfter = new Date();
            switch (this.interval) {
                case HOUR: {
                    createdAfter = DateUtils.addHours((Date)createdAfter, (int)-1);
                    break;
                }
                case DAY: {
                    createdAfter = DateUtils.addDays((Date)createdAfter, (int)-1);
                    break;
                }
                case WEEK: {
                    createdAfter = DateUtils.addWeeks((Date)createdAfter, (int)-1);
                    break;
                }
                case MONTH: {
                    createdAfter = DateUtils.addMonths((Date)createdAfter, (int)-1);
                }
            }
            eventFilter.setEA(createdAfter);
            List<PlatformEvent> events = this.service.getEvents(eventFilter);
            ByteArrayOutputStream out = PlatformEventExport.getEventReport(events, this.messageSource);
            ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
            String fileName = PlatformEventExport.getAttachmentName();
            mail.addAttachment((InputStream)in, fileName, MediaType.OPENDOCUMENT_SPREADSHEET.toString());
            this.mailTransport.send(mail);
        } else {
            log.info("No report receivers defined, set {} accordingly!", (Object)"eventReportReceivers");
        }
    }

    public String getDescription() {
        return this.description;
    }

    public Map<String, Object> getJobDataMap() {
        return this.jobDataMap;
    }

    public MailTransport getMailTransport() {
        return this.mailTransport;
    }

    public PlatformEventService getService() {
        return this.service;
    }

    public MessageSource getMessageSource() {
        return this.messageSource;
    }

    public Interval getInterval() {
        return this.interval;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setJobDataMap(Map<String, Object> jobDataMap) {
        this.jobDataMap = jobDataMap;
    }

    public void setMailTransport(MailTransport mailTransport) {
        this.mailTransport = mailTransport;
    }

    public void setService(PlatformEventService service) {
        this.service = service;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public void setInterval(Interval interval) {
        this.interval = interval;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PlatformEventReportJob)) {
            return false;
        }
        PlatformEventReportJob other = (PlatformEventReportJob)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Map<String, Object> this$jobDataMap = this.getJobDataMap();
        Map<String, Object> other$jobDataMap = other.getJobDataMap();
        if (this$jobDataMap == null ? other$jobDataMap != null : !((Object)this$jobDataMap).equals(other$jobDataMap)) {
            return false;
        }
        MailTransport this$mailTransport = this.getMailTransport();
        MailTransport other$mailTransport = other.getMailTransport();
        if (this$mailTransport == null ? other$mailTransport != null : !this$mailTransport.equals(other$mailTransport)) {
            return false;
        }
        PlatformEventService this$service = this.getService();
        PlatformEventService other$service = other.getService();
        if (this$service == null ? other$service != null : !this$service.equals(other$service)) {
            return false;
        }
        MessageSource this$messageSource = this.getMessageSource();
        MessageSource other$messageSource = other.getMessageSource();
        if (this$messageSource == null ? other$messageSource != null : !this$messageSource.equals(other$messageSource)) {
            return false;
        }
        Interval this$interval = this.getInterval();
        Interval other$interval = other.getInterval();
        return !(this$interval == null ? other$interval != null : !((Object)((Object)this$interval)).equals((Object)other$interval));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PlatformEventReportJob;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Map<String, Object> $jobDataMap = this.getJobDataMap();
        result = result * 59 + ($jobDataMap == null ? 43 : ((Object)$jobDataMap).hashCode());
        MailTransport $mailTransport = this.getMailTransport();
        result = result * 59 + ($mailTransport == null ? 43 : $mailTransport.hashCode());
        PlatformEventService $service = this.getService();
        result = result * 59 + ($service == null ? 43 : $service.hashCode());
        MessageSource $messageSource = this.getMessageSource();
        result = result * 59 + ($messageSource == null ? 43 : $messageSource.hashCode());
        Interval $interval = this.getInterval();
        result = result * 59 + ($interval == null ? 43 : ((Object)((Object)$interval)).hashCode());
        return result;
    }

    public String toString() {
        return "PlatformEventReportJob(description=" + this.getDescription() + ", jobDataMap=" + this.getJobDataMap() + ", mailTransport=" + this.getMailTransport() + ", service=" + this.getService() + ", messageSource=" + this.getMessageSource() + ", interval=" + (Object)((Object)this.getInterval()) + ")";
    }

    static enum Interval {
        HOUR,
        DAY,
        WEEK,
        MONTH;

    }
}

