/*
 * Copyright 2011-2018 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.appng.application.manager.form;

import javax.validation.Valid;

import org.appng.core.domain.SiteImpl;

/**
 * Bindclass used for creating/updating a {@link SiteImpl}.
 * 
 * @author Matthias Müller
 * 
 */
public class SiteForm {

	private SiteImpl site;
	private String template;

	public SiteForm() {
		this.site = new SiteImpl();
	}

	public SiteForm(SiteImpl site) {
		this.site = site;
	}

	@Valid
	public SiteImpl getSite() {
		return site;
	}

	public void setSite(SiteImpl site) {
		this.site = site;
	}

	public String getTemplate() {
		return template;
	}

	public void setTemplate(String template) {
		this.template = template;
	}

}
