/*
 * Decompiled with CFR 0.152.
 */
package org.appng.application.manager.form;

import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.appng.api.Environment;
import org.appng.api.FieldProcessor;
import org.appng.api.FormValidator;
import org.appng.api.Options;
import org.appng.api.Request;
import org.appng.api.auth.PasswordPolicy;
import org.appng.api.model.Application;
import org.appng.api.model.Site;
import org.appng.api.model.UserType;
import org.appng.core.domain.SubjectImpl;

public class SubjectForm
implements FormValidator {
    private SubjectImpl subject;
    private List<Integer> groupIds = new ArrayList<Integer>();
    private String password;
    private String passwordConfirmation;

    public SubjectForm() {
        this(new SubjectImpl());
    }

    public SubjectForm(SubjectImpl subject) {
        this.subject = subject;
    }

    public void validate(Site site, Application application, Environment environment, Options options, Request request, FieldProcessor fp) {
        if (this.isLocalUser()) {
            String action;
            if (StringUtils.isBlank((CharSequence)this.getSubject().getEmail())) {
                String message = request.getMessage("subject.enter.email", new Object[0]);
                fp.addErrorMessage(fp.getField("subject.email"), message);
            }
            if ("create".equals(action = options.getOptionValue("action", "id"))) {
                String message;
                if (null == this.password) {
                    message = request.getMessage("subject.enter.password", new Object[0]);
                    fp.addErrorMessage(fp.getField("password"), message);
                }
                if (null == this.passwordConfirmation) {
                    message = request.getMessage("subject.enter.passwordConfirmation", new Object[0]);
                    fp.addErrorMessage(fp.getField("passwordConfirmation"), message);
                }
            }
            PasswordPolicy passwordPolicy = site.getPasswordPolicy();
            if (!StringUtils.isEmpty((CharSequence)this.password)) {
                if (!passwordPolicy.isValidPassword(this.password.toCharArray())) {
                    String message = request.getMessage(passwordPolicy.getErrorMessageKey(), new Object[0]);
                    fp.addErrorMessage(fp.getField("password"), message);
                } else if (!StringUtils.equals((CharSequence)this.password, (CharSequence)this.passwordConfirmation)) {
                    String message = request.getMessage("subject.passwords.no.match", new Object[0]);
                    fp.addErrorMessage(fp.getField("passwordConfirmation"), message);
                }
            }
        }
    }

    @Valid
    public SubjectImpl getSubject() {
        return this.subject;
    }

    public void setSubject(SubjectImpl subject) {
        this.subject = subject;
    }

    public List<Integer> getGroupIds() {
        return this.groupIds;
    }

    public void setGroupIds(List<Integer> groupIds) {
        this.groupIds = groupIds;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        if (!"".equals(password)) {
            this.password = password;
        }
    }

    public String getPasswordConfirmation() {
        return this.passwordConfirmation;
    }

    public void setPasswordConfirmation(String passwordConfirmation) {
        if (!"".equals(passwordConfirmation)) {
            this.passwordConfirmation = passwordConfirmation;
        }
    }

    public boolean isLocalUser() {
        return UserType.LOCAL_USER.equals((Object)this.getSubject().getUserType());
    }
}

