/*
 * Decompiled with CFR 0.152.
 */
package org.appng.application.manager.form;

import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.appng.api.Environment;
import org.appng.api.FieldProcessor;
import org.appng.api.FormValidator;
import org.appng.api.Options;
import org.appng.api.Request;
import org.appng.api.model.Application;
import org.appng.api.model.Site;
import org.appng.core.domain.PropertyImpl;

public class PropertyForm
implements FormValidator {
    private PropertyImpl property;

    public PropertyForm() {
        this(new PropertyImpl());
    }

    public PropertyForm(PropertyImpl property) {
        this.property = property;
    }

    @Valid
    public PropertyImpl getProperty() {
        return this.property;
    }

    public void setProperty(PropertyImpl property) {
        this.property = property;
    }

    public void validate(Site site, Application application, Environment environment, Options options, Request request, FieldProcessor fp) {
        String fieldName;
        String fieldValue;
        boolean isCreate = fp.hasField("property.name");
        if (isCreate) {
            fieldValue = this.getProperty().getDefaultString();
            fieldName = "property.defaultString";
        } else {
            fieldValue = this.getProperty().getActualString();
            fieldName = "property.actualString";
        }
        int clobLength = StringUtils.length((CharSequence)this.getProperty().getClob());
        int stringLength = StringUtils.length((CharSequence)fieldValue);
        if (clobLength > 0 && stringLength > 0 || isCreate && clobLength + stringLength == 0) {
            String message = application.getMessage(environment.getLocale(), "property.stringOrClob", new Object[0]);
            fp.addErrorMessage(fp.getField("property.clob"), message);
            fp.addErrorMessage(fp.getField(fieldName), message);
        }
    }
}

