/*
 * Decompiled with CFR 0.152.
 */
package org.appng.application.manager.business;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.appng.api.ApplicationException;
import org.appng.api.AttachmentWebservice;
import org.appng.api.BusinessException;
import org.appng.api.Request;
import org.appng.api.RequestUtil;
import org.appng.api.Scope;
import org.appng.api.model.Application;
import org.appng.api.model.Properties;
import org.appng.api.model.Site;
import org.appng.api.model.Subject;
import org.appng.application.manager.business.Constants;
import org.appng.application.manager.business.Environment;
import org.appng.application.manager.business.LogConfig;
import org.appng.application.manager.business.LogViewer;
import org.appng.application.manager.business.ThreadViewer;
import org.appng.application.manager.service.Service;
import org.appng.tools.os.Command;
import org.appng.tools.os.OperatingSystem;
import org.appng.tools.os.StringConsumer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Lazy
@Component
@org.springframework.context.annotation.Scope(value="request")
public class SystemReport
implements AttachmentWebservice {
    private static final String EXT_TXT = ".txt";
    private static final String EXT_PROPERTIES = ".properties";
    private static final String EXT_ZIP = ".zip";
    private static final String DATE_PATTERN = "yyyy-MM-dd-HH-mm";
    private static final String PERM_REPORT = "platform.report";
    @Autowired
    private LogConfig logConfig;
    @Autowired
    private ThreadViewer threadViewer;
    @Autowired
    private LogViewer logViewer;
    @Autowired
    private Service service;
    @Value(value="${platform.platformRootPath}")
    private String rootPath;

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] processRequest(Site site, Application application, org.appng.api.Environment environment, Request request) throws BusinessException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Subject subject = environment.getSubject();
        if (subject == null) return out.toByteArray();
        if (!subject.isAuthenticated()) return out.toByteArray();
        if (!request.getPermissionProcessor().hasPermission(PERM_REPORT)) return out.toByteArray();
        ArchiveOutputStream os = null;
        try {
            os = new ArchiveStreamFactory().createArchiveOutputStream("zip", (OutputStream)out);
            ((ZipArchiveOutputStream)os).setLevel(9);
            this.addProperties(os, "system-properties.properties", System.getProperties());
            this.addProperties(os, "system-environment.properties", System.getenv());
            Properties platformProps = (Properties)environment.getAttribute(Scope.PLATFORM, "platformConfig");
            this.addProperties(os, "platform.properties", platformProps.getPlainProperties());
            for (String siteName : RequestUtil.getSiteNames((org.appng.api.Environment)environment)) {
                Site s = RequestUtil.getSiteByName((org.appng.api.Environment)environment, (String)siteName);
                String sitePropsName = s.getName() + "/" + siteName + EXT_PROPERTIES;
                this.addProperties(os, sitePropsName, s.getProperties().getPlainProperties());
                String rootDir = s.getProperties().getString("siteRootDir");
                String indexDir = s.getProperties().getString("indexDir");
                this.addFile(os, new File(rootDir, indexDir), s.getName() + indexDir);
            }
            String jars = StringUtils.join(this.service.getJars(environment, null), (String)Constants.NEW_LINE);
            this.addArchiveEntry(os, "lib.txt", jars);
            this.addArchiveEntry(os, "directories.txt", this.listDirectory(this.rootPath));
            this.addArchiveEntry(os, "threads.txt", this.threadViewer.getThreadDump(null, null));
            this.addArchiveEntry(os, this.logViewer.getLogfile());
            this.addArchiveEntry(os, this.logConfig.getConfigFile());
            this.addArchiveEntry(os, new File(this.rootPath, "WEB-INF/conf/appNG.properties"));
        }
        catch (IOException e) {
            try {
                throw new ApplicationException((Throwable)e);
                catch (ArchiveException e2) {
                    throw new ApplicationException((Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(os);
                IOUtils.closeQuietly((OutputStream)out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)os);
        IOUtils.closeQuietly((OutputStream)out);
        return out.toByteArray();
    }

    private void addFile(ArchiveOutputStream os, File srcFile, String currentFolder) throws FileNotFoundException, IOException {
        if (null != srcFile && srcFile.exists()) {
            for (File file : srcFile.listFiles()) {
                String path = currentFolder + "/" + file.getName();
                if (file.isDirectory()) {
                    this.addFile(os, file, path);
                    continue;
                }
                this.addArchiveEntry(os, path, file);
            }
        }
    }

    private void addProperties(ArchiveOutputStream os, String name, Map<?, ?> map) throws IOException {
        ByteArrayOutputStream propsOut = new ByteArrayOutputStream();
        for (Map.Entry<String, ?> entry : Environment.getSortedEntries(map)) {
            propsOut.write((entry.getKey() + "=" + entry.getValue() + Constants.NEW_LINE).getBytes());
        }
        this.addArchiveEntry(os, name, new ByteArrayInputStream(propsOut.toByteArray()), null);
    }

    private void addArchiveEntry(ArchiveOutputStream os, File file) throws FileNotFoundException, IOException {
        this.addArchiveEntry(os, file.getName(), file);
    }

    private void addArchiveEntry(ArchiveOutputStream os, String name, File file) throws FileNotFoundException, IOException {
        if (file.exists()) {
            this.addArchiveEntry(os, name, new FileInputStream(file), file.lastModified());
        }
    }

    private void addArchiveEntry(ArchiveOutputStream os, String name, String content) throws IOException {
        this.addArchiveEntry(os, name, new ByteArrayInputStream(content.getBytes()), null);
    }

    private void addArchiveEntry(ArchiveOutputStream os, String name, InputStream is, Long lastModified) throws IOException {
        try {
            ZipArchiveEntry entry = new ZipArchiveEntry(name);
            if (null != lastModified) {
                entry.setTime(lastModified.longValue());
            }
            os.putArchiveEntry((ArchiveEntry)entry);
            IOUtils.copy((InputStream)is, (OutputStream)os);
            os.closeArchiveEntry();
        }
        catch (IOException e) {
            IOUtils.closeQuietly((InputStream)is);
            throw e;
        }
    }

    public String getContentType() {
        return "application/zip";
    }

    public String getFileName() {
        String hostname = null;
        try {
            InetAddress addr = InetAddress.getLocalHost();
            hostname = addr.getCanonicalHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return "systemreport" + (null == hostname ? "" : "-" + hostname) + "-" + DateFormatUtils.format((Date)new Date(), (String)DATE_PATTERN) + EXT_ZIP;
    }

    public boolean isAttachment() {
        return true;
    }

    private String listDirectory(String root) {
        StringBuilder sb = new StringBuilder();
        StringConsumer outputConsumer = new StringConsumer();
        if (OperatingSystem.isWindows()) {
            Command.execute((String)("cmd /c dir /q /s " + root), (Command.StreamConsumer)outputConsumer, null);
        } else {
            Command.execute((String)("ls -lR " + root), (Command.StreamConsumer)outputConsumer, null);
        }
        List lines = outputConsumer.getResult();
        if (null != lines) {
            sb.append(StringUtils.join((Iterable)lines, (String)Constants.NEW_LINE));
        }
        return sb.toString();
    }
}

