/*
 * Decompiled with CFR 0.152.
 */
package org.appng.application.manager.business;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.appng.api.ActionProvider;
import org.appng.api.DataContainer;
import org.appng.api.DataProvider;
import org.appng.api.Environment;
import org.appng.api.FieldProcessor;
import org.appng.api.Options;
import org.appng.api.Request;
import org.appng.api.model.Application;
import org.appng.api.model.Site;
import org.appng.application.manager.service.ServiceAware;
import org.appng.core.domain.DatabaseConnection;
import org.flywaydb.core.internal.dbsupport.DbSupport;
import org.flywaydb.core.internal.dbsupport.SqlScript;
import org.flywaydb.core.internal.dbsupport.hsql.HsqlDbSupport;
import org.flywaydb.core.internal.dbsupport.mysql.MySQLDbSupport;
import org.flywaydb.core.internal.dbsupport.sqlserver.SQLServerDbSupport;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.CallableStatementCallback;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.SingleConnectionDataSource;
import org.springframework.jdbc.support.rowset.ResultSetWrappingSqlRowSet;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.jdbc.support.rowset.SqlRowSetMetaData;
import org.springframework.stereotype.Component;

@Lazy
@Component
@Scope(value="request")
public class SqlExecutor
extends ServiceAware
implements DataProvider,
ActionProvider<SqlStatement> {
    public DataContainer getData(Site site, Application application, Environment environment, Options options, Request request, FieldProcessor fieldProcessor) {
        DataContainer dataContainer = new DataContainer(fieldProcessor);
        Map sessionParams = application.getSessionParams(site, environment);
        String dcId = options.getOptionValue("connection", "id");
        SqlStatement statement = new SqlStatement((String)sessionParams.get("sql" + dcId), (String)sessionParams.remove("result" + dcId), false);
        dataContainer.setItem((Object)statement);
        return dataContainer;
    }

    public void perform(Site site, Application application, Environment environment, Options options, Request request, SqlStatement formBean, FieldProcessor fieldProcessor) {
        Integer dcId = (Integer)request.convert((Object)options.getOptionValue("connection", "id"), Integer.class);
        String sql = formBean.getContent();
        Map sessionParams = application.getSessionParams(site, environment);
        sessionParams.put("sql" + dcId, sql);
        DatabaseConnection databaseConnection = this.getService().getDatabaseConnection(dcId, false);
        SingleConnectionDataSource dataSource = new SingleConnectionDataSource(databaseConnection.getJdbcUrl(), databaseConnection.getUserName(), new String(databaseConnection.getPassword()), true);
        JdbcTemplate jdbcTemplate = new JdbcTemplate((DataSource)dataSource);
        List<String> queries = this.getQueries(sql, databaseConnection.getType());
        StringBuilder results = new StringBuilder();
        for (String query : queries) {
            SqlStatement statementResult = this.processSingleStatement(query, jdbcTemplate);
            results.append("<div style='background:#F0F0F0;border:1px solid grey'>");
            results.append(statementResult.getContent());
            results.append("</div>");
            results.append(statementResult.getResult());
            results.append("<p/>");
        }
        String result = results.toString();
        sessionParams.put("result" + dcId, result);
    }

    public SqlStatement processSingleStatement(String sql, JdbcTemplate jdbcTemplate) {
        String result;
        boolean hasError = false;
        try {
            result = (String)jdbcTemplate.execute(sql, (CallableStatementCallback)new CallableStatementCallback<String>(){

                public String doInCallableStatement(CallableStatement ps) throws SQLException, DataAccessException {
                    String result = "";
                    ps.execute();
                    int up = ps.getUpdateCount();
                    ResultSet rs = ps.getResultSet();
                    if (null != rs) {
                        result = SqlExecutor.this.buildResultSetTable((SqlRowSet)new ResultSetWrappingSqlRowSet(rs));
                    } else if (up > -1) {
                        result = "<div>" + up + " row(s) affected</div>";
                    }
                    return result;
                }
            });
        }
        catch (DataAccessException e) {
            result = "<div style='border:1px solid red'>" + e.getCause().getMessage() + "</div>";
            hasError = true;
        }
        return new SqlStatement(sql, result, hasError);
    }

    public String buildResultSetTable(SqlRowSet rowSet) {
        StringBuilder sb = new StringBuilder();
        int rows = 0;
        if (null != rowSet) {
            SqlRowSetMetaData metaData = rowSet.getMetaData();
            sb.append("<table border='1px solid grey' cellpadding='0' cellspacing='0'>");
            sb.append("<tr>");
            for (String col : metaData.getColumnNames()) {
                sb.append("<th>" + col + "</th>");
            }
            sb.append("</tr>");
            int columnCount = metaData.getColumnCount();
            while (rowSet.next()) {
                ++rows;
                sb.append("<tr style='vertical-align:top'>");
                for (int i = 1; i <= columnCount; ++i) {
                    sb.append("<td>" + rowSet.getObject(i) + "</td>");
                }
                sb.append("</tr>");
            }
            sb.append("</table>");
        }
        sb.append("<div>" + rows + " row(s) selected</div>");
        return sb.toString();
    }

    public List<String> getQueries(String sql, DatabaseConnection.DatabaseType type) {
        MySQLDbSupport dbSupport = null;
        switch (type) {
            case MYSQL: {
                dbSupport = new MySQLDbSupport(null);
                break;
            }
            case MSSQL: {
                dbSupport = new SQLServerDbSupport(null);
                break;
            }
            case HSQL: {
                dbSupport = new HsqlDbSupport(null);
            }
        }
        SqlScript sqlScript = new SqlScript(sql, (DbSupport)dbSupport);
        ArrayList<String> queries = new ArrayList<String>();
        sqlScript.getSqlStatements().forEach(query -> queries.add(query.getSql()));
        return queries;
    }

    public static class SqlStatement {
        private String content;
        private String result;
        private boolean hasError;

        public SqlStatement() {
        }

        public SqlStatement(String content, String result, boolean hasError) {
            this.content = content;
            this.result = result;
            this.hasError = hasError;
        }

        public String getContent() {
            return this.content;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public String getResult() {
            return this.result;
        }

        public void setResult(String result) {
            this.result = result;
        }

        public boolean isHasError() {
            return this.hasError;
        }

        public void setHasError(boolean hasError) {
            this.hasError = hasError;
        }
    }
}

