/*
 * Decompiled with CFR 0.152.
 */
package org.appng.application.manager.business;

import java.util.Properties;
import org.appng.api.ActionProvider;
import org.appng.api.BusinessException;
import org.appng.api.DataContainer;
import org.appng.api.DataProvider;
import org.appng.api.Environment;
import org.appng.api.FieldProcessor;
import org.appng.api.InvalidConfigurationException;
import org.appng.api.Options;
import org.appng.api.Request;
import org.appng.api.model.Application;
import org.appng.api.model.Site;
import org.appng.application.manager.form.SiteForm;
import org.appng.application.manager.service.Service;
import org.appng.application.manager.service.ServiceAware;
import org.appng.core.domain.SiteImpl;
import org.appng.core.service.InitializerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Lazy
@Component
@Scope(value="request")
public class Sites
extends ServiceAware
implements DataProvider,
ActionProvider<SiteForm> {
    private static final Logger log = LoggerFactory.getLogger(Sites.class);
    public static final String SITE = "site";

    public void perform(Site site, Application application, Environment environment, Options options, Request request, SiteForm siteForm, FieldProcessor fp) {
        String action = this.getAction(options);
        String errorMessage = null;
        String okMessage = null;
        Service service = this.getService();
        Integer siteId = (Integer)request.convert((Object)options.getOptionValue(SITE, "id"), Integer.class);
        try {
            if ("create".equals(action)) {
                errorMessage = "site.create.error";
                service.createSite(siteForm, fp);
                okMessage = "site.created";
            } else if ("update".equals(action)) {
                SiteImpl siteBean = siteForm.getSite();
                siteBean.setId(siteId);
                errorMessage = "site.update.error";
                service.updateSite(siteForm, fp);
                okMessage = "site.updated";
            } else if ("delete".equals(action)) {
                errorMessage = "site.delete.error";
                String host = request.getHost();
                service.deleteSite(host, siteId, fp, site);
                okMessage = "site.deleted";
            } else if ("reload".equals(action)) {
                errorMessage = "site.reloaded.error";
                service.reloadSite(application, siteId, fp);
                okMessage = "site.reloaded";
            } else if ("reloadPlatform".equals(action)) {
                errorMessage = "platform.reload.error";
                this.reloadPlatform(site, application, request, fp);
                okMessage = "platform.reloaded";
            }
            String message = request.getMessage(okMessage, new Object[]{siteId});
            fp.addOkMessage(message);
        }
        catch (BusinessException ex) {
            String message = request.getMessage(errorMessage, new Object[]{siteId});
            log.error("error during action '" + action + "': " + message, (Throwable)ex);
            fp.addErrorMessage(message);
        }
    }

    public DataContainer getData(Site site, Application application, Environment environment, Options options, Request request, FieldProcessor fp) {
        Service service = this.getService();
        Integer siteId = (Integer)request.convert((Object)options.getOptionValue(SITE, "id"), Integer.class);
        DataContainer data = null;
        if (null == siteId && "create".equals(this.getAction(options))) {
            data = service.getNewSite(fp);
        } else {
            try {
                data = service.searchSites(fp, siteId);
            }
            catch (BusinessException e) {
                String message = request.getMessage(e.getMessageKey(), e.getMessageArgs());
                log.error(message, (Throwable)e);
                fp.addErrorMessage(message);
            }
        }
        return data;
    }

    public void reloadPlatform(Site site, Application application, Request request, FieldProcessor fp) throws BusinessException {
        InitializerService initializerService = (InitializerService)application.getBean(InitializerService.class);
        try {
            try {
                initializerService.reloadPlatform(new Properties(), request.getEnvironment(), site.getName(), null, null);
            }
            catch (InvalidConfigurationException e) {
                throw new BusinessException("Invalid configuration", (Throwable)e);
            }
        }
        catch (Exception e) {
            request.handleException(fp, e);
        }
    }
}

